/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.logging.LogRecord;
import org.apache.sis.internal.netcdf.Convention;
import org.apache.sis.internal.netcdf.DiscreteSampling;
import org.apache.sis.internal.netcdf.Grid;
import org.apache.sis.internal.netcdf.GridCacheKey;
import org.apache.sis.internal.netcdf.GridMapping;
import org.apache.sis.internal.netcdf.Node;
import org.apache.sis.internal.netcdf.Resources;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.referencing.ReferencingFactoryContainer;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.logging.PerformanceLevel;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;

public abstract class Decoder
extends ReferencingFactoryContainer
implements Closeable {
    public static final String FORMAT_NAME = "netCDF";
    public Path location;
    private Convention convention;
    public NameSpace namespace;
    public final DefaultNameFactory nameFactory;
    public final GeometryLibrary geomlib;
    final Datum[] datumCache;
    final Map<Object, GridMapping> gridMapping;
    final Map<GridCacheKey, MathTransform> localizationGrids;
    public final StoreListeners listeners;
    public volatile boolean canceled;

    protected Decoder(GeometryLibrary geomlib, StoreListeners listeners) {
        Objects.requireNonNull(listeners);
        this.geomlib = geomlib;
        this.listeners = listeners;
        this.nameFactory = DefaultFactories.forBuildin(NameFactory.class, DefaultNameFactory.class);
        this.datumCache = new Datum[4];
        this.gridMapping = new HashMap<Object, GridMapping>();
        this.localizationGrids = new HashMap<GridCacheKey, MathTransform>();
    }

    protected final void initialize() {
        this.convention = Convention.find(this);
    }

    public final Convention convention() {
        return this.convention != null ? this.convention : Convention.DEFAULT;
    }

    public abstract String getFilename();

    public abstract String[] getFormatDescription();

    public abstract void setSearchPath(String ... var1);

    public abstract String[] getSearchPath();

    public abstract Collection<String> getAttributeNames();

    public abstract String stringValue(String var1);

    public abstract Number numericValue(String var1);

    protected final Number parseNumber(String name, String value) {
        Number n;
        int s = value.indexOf(32);
        if (s >= 0) {
            value = value.substring(0, s);
        }
        try {
            n = value.indexOf(46) >= 0 ? (Number)Double.valueOf(value) : (Number)Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            this.illegalAttributeValue(name, value, e);
            n = null;
        }
        return n;
    }

    final void illegalAttributeValue(String name, String value, NumberFormatException e) {
        this.listeners.warning(Resources.forLocale(this.listeners.getLocale()).getString((short)21, this.getFilename(), name, value), e);
    }

    public abstract Date dateValue(String var1);

    public abstract Date[] numberToDate(String var1, Number ... var2);

    public TimeZone getTimeZone() {
        return TimeZone.getTimeZone("UTC");
    }

    public String getId() {
        return this.stringValue("_Id");
    }

    public String getTitle() {
        return this.stringValue("_Title");
    }

    public abstract Variable[] getVariables();

    public abstract DiscreteSampling[] getDiscreteSampling() throws IOException, DataStoreException;

    public abstract Grid[] getGrids() throws IOException, DataStoreException;

    public final List<CoordinateReferenceSystem> getReferenceSystemInfo() throws IOException, DataStoreException {
        ArrayList<CoordinateReferenceSystem> list = new ArrayList<CoordinateReferenceSystem>();
        for (Variable variable : this.getVariables()) {
            GridMapping m = GridMapping.forVariable(variable);
            if (m == null) continue;
            Decoder.addIfNotPresent(list, m.crs);
        }
        if (list.isEmpty()) {
            ArrayList<Exception> warnings = new ArrayList<Exception>();
            for (Grid grid : this.getGrids()) {
                Decoder.addIfNotPresent(list, grid.getCoordinateReferenceSystem(this, warnings));
            }
        }
        return list;
    }

    private static void addIfNotPresent(List<CoordinateReferenceSystem> list, CoordinateReferenceSystem crs) {
        if (crs != null) {
            int i = list.size();
            while (--i >= 0) {
                if (!Utilities.deepEquals(crs, list.get(i), ComparisonMode.ALLOW_VARIANT)) continue;
                return;
            }
            list.add(crs);
        }
    }

    protected abstract Node findNode(String var1);

    final void performance(Class<?> caller, String method, short resourceKey, long time) {
        time = System.nanoTime() - time;
        LogRecord record = Resources.forLocale(this.listeners.getLocale()).getLogRecord(PerformanceLevel.forDuration(time, TimeUnit.NANOSECONDS), resourceKey, this.getFilename(), (double)time / 1.0E9);
        record.setLoggerName("org.apache.sis.storage.netcdf");
        Logging.log(caller, method, record);
    }
}

