/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.logging.Level;
import javax.measure.Unit;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.NamedElement;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.TemporalUtilities;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.DefaultGeocentricCRS;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

abstract class CRSBuilder<D extends Datum, CS extends CoordinateSystem> {
    private final Class<D> datumType;
    private final String datumBase;
    private final byte datumIndex;
    private final byte minDim;
    private final byte maxDim;
    private byte dimension;
    private Axis[] axes;
    protected D datum;
    protected CS coordinateSystem;
    protected SingleCRS referenceSystem;
    private NoSuchAuthorityCodeException warnings;
    static final int DATUM_CACHE_SIZE = 4;

    private CRSBuilder(Class<D> datumType, String datumBase, byte datumIndex, byte minDim, byte maxDim) {
        this.datumType = datumType;
        this.datumBase = datumBase;
        this.datumIndex = datumIndex;
        this.minDim = minDim;
        this.maxDim = maxDim;
        this.axes = new Axis[3];
    }

    public static void dispatch(List<CRSBuilder<?, ?>> components, Axis axis) throws DataStoreContentException {
        Supplier<CRSBuilder> constructor;
        Class addTo;
        int i;
        int alternative = -1;
        switch (axis.abbreviation) {
            case 'h': {
                i = components.size();
                while (--i >= 0) {
                    if (!(components.get(i) instanceof Projected)) continue;
                    alternative = i;
                    break;
                }
            }
            case '\u03bb': 
            case '\u03c6': {
                addTo = Geographic.class;
                constructor = Geographic::new;
                break;
            }
            case 'r': 
            case '\u03a9': 
            case '\u03b8': {
                addTo = Spherical.class;
                constructor = Spherical::new;
                break;
            }
            case 'E': 
            case 'N': {
                addTo = Projected.class;
                constructor = Projected::new;
                break;
            }
            case 'D': 
            case 'H': {
                addTo = Vertical.class;
                constructor = Vertical::new;
                break;
            }
            case 't': {
                addTo = Temporal.class;
                constructor = Temporal::new;
                break;
            }
            default: {
                addTo = Engineering.class;
                constructor = Engineering::new;
            }
        }
        i = components.size();
        while (--i >= 0) {
            CRSBuilder<?, ?> builder = components.get(i);
            if (!addTo.isInstance(builder) && i != alternative) continue;
            super.add(axis);
            return;
        }
        CRSBuilder builder = constructor.get();
        if (addTo == Projected.class) {
            int i2 = components.size();
            block10: while (--i2 >= 0) {
                CRSBuilder<?, ?> replace = components.get(i2);
                for (Axis a : replace.axes) {
                    if (a.abbreviation != 'h') continue block10;
                }
                for (Axis a : replace.axes) {
                    builder.add(a);
                }
                components.remove(i2);
                break;
            }
        }
        builder.add(axis);
        components.add(builder);
    }

    private void add(Axis axis) throws DataStoreContentException {
        if (this.dimension == 127) {
            throw new DataStoreContentException(this.getFirstAxis().coordinates.errors().getString((short)36, "axes", (short)128));
        }
        if (this.dimension >= this.axes.length) {
            this.axes = Arrays.copyOf(this.axes, this.dimension * 2);
        }
        byte by = this.dimension;
        this.dimension = (byte)(by + 1);
        this.axes[by] = axis;
    }

    final boolean is3D() {
        return this.dimension >= 3;
    }

    final Axis getFirstAxis() {
        return this.axes[0];
    }

    public final SingleCRS build(Decoder decoder) throws FactoryException, DataStoreException, IOException {
        if (this.dimension < this.minDim || this.dimension > this.maxDim) {
            Variable axis = this.getFirstAxis().coordinates;
            throw new DataStoreContentException(axis.resources().getString((short)10, axis.getFilename(), this.getClass().getSimpleName(), this.dimension, NamedElement.listNames(this.axes, this.dimension, ", ")));
        }
        this.datum = (Datum)this.datumType.cast(decoder.datumCache[this.datumIndex]);
        this.setPredefinedComponents(decoder);
        if (this.datum == null) {
            this.createDatum(decoder.getDatumFactory(), CRSBuilder.properties("Unknown datum presumably based upon ".concat(this.datumBase)));
        }
        decoder.datumCache[this.datumIndex] = this.datum;
        if (this.coordinateSystem != null) {
            int i = this.dimension;
            while (--i >= 0) {
                Axis expected = this.axes[i];
                if (expected != null && expected.isSameUnitAndDirection(this.coordinateSystem.getAxis(i))) continue;
                this.coordinateSystem = null;
                this.referenceSystem = null;
                break;
            }
        }
        if (this.referenceSystem == null) {
            Map<String, ?> properties;
            if (this.coordinateSystem == null) {
                StringJoiner joiner = new StringJoiner(" ");
                CSFactory csFactory = decoder.getCSFactory();
                CoordinateSystemAxis[] iso = new CoordinateSystemAxis[this.dimension];
                for (int i = 0; i < iso.length; ++i) {
                    Axis axis = this.axes[i];
                    joiner.add(axis.getName());
                    iso[i] = axis.toISO(csFactory, i);
                }
                this.createCS(csFactory, CRSBuilder.properties(joiner.toString()), iso);
                properties = CRSBuilder.properties(this.coordinateSystem.getName());
            } else {
                properties = CRSBuilder.properties(NamedElement.listNames(this.axes, this.dimension, " "));
            }
            this.createCRS(decoder.getCRSFactory(), properties);
        }
        CoordinateSystem cs = this.referenceSystem.getCoordinateSystem();
        int i = cs.getDimension();
        while (--i >= 0) {
            double last;
            double first;
            Vector coordinates;
            int length;
            CoordinateSystemAxis axis = cs.getAxis(i);
            if (!RangeMeaning.WRAPAROUND.equals((Object)axis.getRangeMeaning()) || (length = (coordinates = this.axes[i].read()).size()) == 0 || !(Math.min(first = coordinates.doubleValue(0), last = coordinates.doubleValue(length - 1)) >= 0.0) || !(Math.max(first, last) > axis.getMaximumValue())) continue;
            this.referenceSystem = (SingleCRS)AbstractCRS.castOrCopy((CoordinateReferenceSystem)this.referenceSystem).forConvention(AxesConvention.POSITIVE_RANGE);
            break;
        }
        if (this.warnings != null) {
            decoder.listeners.warning(Level.FINE, null, (Exception)((Object)this.warnings));
        }
        return this.referenceSystem;
    }

    final void recoverableException(NoSuchAuthorityCodeException e) {
        if (this.warnings == null) {
            this.warnings = e;
        } else {
            this.warnings.addSuppressed((Throwable)e);
        }
    }

    private static Map<String, ?> properties(Object name) {
        return Collections.singletonMap("name", name);
    }

    final Integer epsgCandidateCS(Unit<?> defaultUnit) {
        Unit<?> unit = this.getFirstAxis().getUnit();
        if (unit == null) {
            unit = defaultUnit;
        }
        AxisDirection[] directions = new AxisDirection[this.dimension];
        for (int i = 0; i < directions.length; ++i) {
            directions[i] = this.axes[i].direction;
        }
        return CoordinateSystems.getEpsgCode(unit, directions);
    }

    abstract void setPredefinedComponents(Decoder var1) throws FactoryException;

    abstract void createDatum(DatumFactory var1, Map<String, ?> var2) throws FactoryException;

    abstract void createCS(CSFactory var1, Map<String, ?> var2, CoordinateSystemAxis[] var3) throws FactoryException;

    abstract void createCRS(CRSFactory var1, Map<String, ?> var2) throws FactoryException;

    private static final class Engineering
    extends CRSBuilder<EngineeringDatum, AffineCS> {
        public Engineering() {
            super(EngineeringDatum.class, "affine coordinate system", (byte)3, (byte)2, (byte)3);
        }

        @Override
        void setPredefinedComponents(Decoder decoder) {
        }

        @Override
        void createDatum(DatumFactory factory, Map<String, ?> properties) throws FactoryException {
            this.datum = factory.createEngineeringDatum(properties);
        }

        @Override
        void createCS(CSFactory factory, Map<String, ?> properties, CoordinateSystemAxis[] axes) throws FactoryException {
            this.coordinateSystem = axes.length > 2 ? factory.createAffineCS(properties, axes[0], axes[1], axes[2]) : factory.createAffineCS(properties, axes[0], axes[1]);
        }

        @Override
        void createCRS(CRSFactory factory, Map<String, ?> properties) throws FactoryException {
            this.referenceSystem = factory.createEngineeringCRS(properties, (EngineeringDatum)this.datum, this.coordinateSystem);
        }
    }

    private static final class Temporal
    extends CRSBuilder<TemporalDatum, TimeCS> {
        public Temporal() {
            super(TemporalDatum.class, "", (byte)2, (byte)1, (byte)1);
        }

        @Override
        void setPredefinedComponents(Decoder decoder) {
            CommonCRS.Temporal predefined;
            Axis axis = this.getFirstAxis();
            Unit<?> unit = axis.getUnit();
            if (Units.DAY.equals(unit)) {
                predefined = CommonCRS.Temporal.JULIAN;
            } else if (Units.SECOND.equals(unit)) {
                predefined = CommonCRS.Temporal.UNIX;
            } else if (Units.MILLISECOND.equals(unit)) {
                predefined = CommonCRS.Temporal.JAVA;
            } else {
                return;
            }
            this.coordinateSystem = predefined.crs().getCoordinateSystem();
        }

        @Override
        void createDatum(DatumFactory factory, Map<String, ?> properties) throws FactoryException {
            Axis axis = this.getFirstAxis();
            axis.getUnit();
            Instant epoch = axis.coordinates.epoch;
            CommonCRS.Temporal c = CommonCRS.Temporal.forEpoch(epoch);
            if (c != null) {
                this.datum = c.datum();
            } else {
                properties = CRSBuilder.properties("Time since " + epoch);
                this.datum = factory.createTemporalDatum(properties, TemporalUtilities.toDate(epoch));
            }
        }

        @Override
        void createCS(CSFactory factory, Map<String, ?> properties, CoordinateSystemAxis[] axes) throws FactoryException {
            this.coordinateSystem = factory.createTimeCS(properties, axes[0]);
        }

        @Override
        void createCRS(CRSFactory factory, Map<String, ?> properties) throws FactoryException {
            properties = CRSBuilder.properties(this.getFirstAxis().coordinates.getUnitsString());
            this.referenceSystem = factory.createTemporalCRS(properties, (TemporalDatum)this.datum, (TimeCS)this.coordinateSystem);
        }
    }

    private static final class Vertical
    extends CRSBuilder<VerticalDatum, VerticalCS> {
        public Vertical() {
            super(VerticalDatum.class, "Mean Sea Level", (byte)1, (byte)1, (byte)1);
        }

        @Override
        void setPredefinedComponents(Decoder decoder) {
            CommonCRS.Vertical predefined;
            Axis axis = this.getFirstAxis();
            Unit<?> unit = axis.getUnit();
            if (Units.METRE.equals(unit)) {
                predefined = AxisDirection.UP.equals((Object)axis.direction) ? CommonCRS.Vertical.MEAN_SEA_LEVEL : CommonCRS.Vertical.DEPTH;
            } else if (Units.HECTOPASCAL.equals(unit)) {
                predefined = CommonCRS.Vertical.BAROMETRIC;
            } else {
                return;
            }
            this.coordinateSystem = predefined.crs().getCoordinateSystem();
        }

        @Override
        void createDatum(DatumFactory factory, Map<String, ?> properties) throws FactoryException {
            this.datum = factory.createVerticalDatum(properties, VerticalDatumType.GEOIDAL);
        }

        @Override
        void createCS(CSFactory factory, Map<String, ?> properties, CoordinateSystemAxis[] axes) throws FactoryException {
            this.coordinateSystem = factory.createVerticalCS(properties, axes[0]);
        }

        @Override
        void createCRS(CRSFactory factory, Map<String, ?> properties) throws FactoryException {
            this.referenceSystem = factory.createVerticalCRS(properties, (VerticalDatum)this.datum, (VerticalCS)this.coordinateSystem);
        }
    }

    private static final class Projected
    extends Geodetic<CartesianCS> {
        private CommonCRS sphericalDatum;
        private static final Conversion UNKNOWN_PROJECTION;

        public Projected() {
            super((byte)2);
        }

        @Override
        void setPredefinedComponents(Decoder decoder) throws FactoryException {
            super.setPredefinedComponents(decoder);
            this.sphericalDatum = decoder.convention().defaultHorizontalCRS(true);
            this.datum = this.sphericalDatum.datum();
            if (this.isPredefinedCS(Units.METRE)) {
                this.coordinateSystem = decoder.getStandardProjectedCS();
            }
        }

        @Override
        void createCS(CSFactory factory, Map<String, ?> properties, CoordinateSystemAxis[] axes) throws FactoryException {
            this.coordinateSystem = axes.length > 2 ? factory.createCartesianCS(properties, axes[0], axes[1], axes[2]) : factory.createCartesianCS(properties, axes[0], axes[1]);
        }

        @Override
        void createCRS(CRSFactory factory, Map<String, ?> properties) throws FactoryException {
            GeographicCRS baseCRS;
            boolean is3D = ((CartesianCS)this.coordinateSystem).getDimension() >= 3;
            GeographicCRS geographicCRS = baseCRS = is3D ? this.sphericalDatum.geographic3D() : this.sphericalDatum.geographic();
            if (!baseCRS.getDatum().equals(this.datum)) {
                baseCRS = factory.createGeographicCRS(properties, (GeodeticDatum)this.datum, baseCRS.getCoordinateSystem());
            }
            this.referenceSystem = factory.createProjectedCRS(properties, baseCRS, UNKNOWN_PROJECTION, (CartesianCS)this.coordinateSystem);
        }

        static {
            DefaultCoordinateOperationFactory factory = DefaultFactories.forBuildin(CoordinateOperationFactory.class, DefaultCoordinateOperationFactory.class);
            try {
                OperationMethod method = factory.getOperationMethod("Equidistant Cylindrical (Spherical)");
                UNKNOWN_PROJECTION = factory.createDefiningConversion(CRSBuilder.properties("Not specified (presumed Plate Carr\u00e9e)"), method, method.getParameters().createValue());
            }
            catch (FactoryException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    private static final class Geographic
    extends Geodetic<EllipsoidalCS> {
        public Geographic() {
            super((byte)2);
        }

        @Override
        void setPredefinedComponents(Decoder decoder) throws FactoryException {
            super.setPredefinedComponents(decoder);
            if (this.isPredefinedCS(Units.DEGREE)) {
                GeographicCRS crs;
                if (this.is3D()) {
                    crs = this.defaultCRS.geographic3D();
                    if (this.isLongitudeFirst) {
                        crs = DefaultGeographicCRS.castOrCopy(crs).forConvention(AxesConvention.RIGHT_HANDED);
                    }
                } else {
                    crs = this.isLongitudeFirst ? this.defaultCRS.normalizedGeographic() : this.defaultCRS.geographic();
                }
                this.referenceSystem = crs;
                this.coordinateSystem = crs.getCoordinateSystem();
                this.datum = crs.getDatum();
            } else {
                this.datum = this.defaultCRS.datum();
                Integer epsg = this.epsgCandidateCS(Units.DEGREE);
                if (epsg != null) {
                    try {
                        this.coordinateSystem = decoder.getCSAuthorityFactory().createEllipsoidalCS(epsg.toString());
                    }
                    catch (NoSuchAuthorityCodeException e) {
                        this.recoverableException(e);
                    }
                }
            }
        }

        @Override
        void createCS(CSFactory factory, Map<String, ?> properties, CoordinateSystemAxis[] axes) throws FactoryException {
            this.coordinateSystem = axes.length > 2 ? factory.createEllipsoidalCS(properties, axes[0], axes[1], axes[2]) : factory.createEllipsoidalCS(properties, axes[0], axes[1]);
        }

        @Override
        void createCRS(CRSFactory factory, Map<String, ?> properties) throws FactoryException {
            this.referenceSystem = factory.createGeographicCRS(properties, (GeodeticDatum)this.datum, (EllipsoidalCS)this.coordinateSystem);
        }
    }

    private static final class Spherical
    extends Geodetic<SphericalCS> {
        public Spherical() {
            super((byte)3);
        }

        @Override
        void setPredefinedComponents(Decoder decoder) throws FactoryException {
            super.setPredefinedComponents(decoder);
            if (this.isPredefinedCS(Units.DEGREE)) {
                GeocentricCRS crs = this.defaultCRS.spherical();
                if (this.isLongitudeFirst) {
                    crs = DefaultGeocentricCRS.castOrCopy(crs).forConvention(AxesConvention.RIGHT_HANDED);
                }
                this.referenceSystem = crs;
                this.coordinateSystem = (SphericalCS)crs.getCoordinateSystem();
                this.datum = crs.getDatum();
            } else {
                this.datum = this.defaultCRS.datum();
            }
        }

        @Override
        void createCS(CSFactory factory, Map<String, ?> properties, CoordinateSystemAxis[] axes) throws FactoryException {
            this.coordinateSystem = factory.createSphericalCS(properties, axes[0], axes[1], axes[2]);
        }

        @Override
        void createCRS(CRSFactory factory, Map<String, ?> properties) throws FactoryException {
            this.referenceSystem = factory.createGeocentricCRS(properties, (GeodeticDatum)this.datum, (SphericalCS)this.coordinateSystem);
        }
    }

    private static abstract class Geodetic<CS extends CoordinateSystem>
    extends CRSBuilder<GeodeticDatum, CS> {
        protected CommonCRS defaultCRS;
        protected boolean isLongitudeFirst;

        Geodetic(byte minDim) {
            super(GeodeticDatum.class, "GRS 1980", (byte)0, minDim, (byte)3);
        }

        @Override
        void setPredefinedComponents(Decoder decoder) throws FactoryException {
            this.defaultCRS = decoder.convention().defaultHorizontalCRS(false);
        }

        @Override
        final void createDatum(DatumFactory factory, Map<String, ?> properties) throws FactoryException {
            GeodeticDatum template = this.defaultCRS.datum();
            this.datum = factory.createGeodeticDatum(properties, template.getEllipsoid(), template.getPrimeMeridian());
        }

        final boolean isPredefinedCS(Unit<?> expected) {
            Axis axis = this.getFirstAxis();
            Unit<?> unit = axis.getUnit();
            if (unit == null || expected.equals(unit)) {
                this.isLongitudeFirst = AxisDirection.EAST.equals((Object)axis.direction);
                if (this.isLongitudeFirst || AxisDirection.NORTH.equals((Object)axis.direction)) {
                    return true;
                }
            }
            return false;
        }
    }
}

