/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata.sql;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.metadata.sql.Dialect;
import org.apache.sis.internal.metadata.sql.TypeMapper;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.FactoryException;

public class SQLBuilder {
    public final Dialect dialect;
    private final String quote;
    private final boolean quoteSchema;
    private final String escape;
    private final StringBuilder buffer = new StringBuilder();

    public SQLBuilder(DatabaseMetaData metadata, boolean quoteSchema) throws SQLException {
        this.dialect = Dialect.guess(metadata);
        this.quote = metadata.getIdentifierQuoteString();
        this.escape = metadata.getSearchStringEscape();
        this.quoteSchema = quoteSchema;
    }

    public SQLBuilder(SQLBuilder other) {
        this.dialect = other.dialect;
        this.escape = other.escape;
        this.quote = other.quote;
        this.quoteSchema = other.quoteSchema;
    }

    public final boolean isEmpty() {
        return this.buffer.length() == 0;
    }

    public final SQLBuilder clear() {
        this.buffer.setLength(0);
        return this;
    }

    public final SQLBuilder append(int n) {
        this.buffer.append(n);
        return this;
    }

    public final SQLBuilder append(char c) {
        this.buffer.append(c);
        return this;
    }

    public final SQLBuilder append(String keyword) {
        this.buffer.append(keyword);
        return this;
    }

    public final SQLBuilder appendIdentifier(String identifier) {
        this.buffer.append(this.quote).append(identifier).append(this.quote);
        return this;
    }

    public final SQLBuilder appendIdentifier(String schema, String identifier) {
        if (schema != null) {
            if (this.quoteSchema) {
                this.appendIdentifier(schema);
            } else {
                this.buffer.append(schema);
            }
            this.buffer.append('.');
        }
        return this.appendIdentifier(identifier);
    }

    public final SQLBuilder appendIdentifier(String catalog, String schema, String identifier) {
        if (catalog != null && !catalog.isEmpty()) {
            this.appendIdentifier(catalog);
            this.buffer.append('.');
            if (schema == null) {
                return this.appendIdentifier("").appendIdentifier(identifier);
            }
        }
        return this.appendIdentifier(schema, identifier);
    }

    public final SQLBuilder appendCondition(Object value) throws FactoryException {
        if (value == null) {
            this.buffer.append(" IS NULL");
            return this;
        }
        this.buffer.append('=');
        return this.appendValue(value);
    }

    public final SQLBuilder appendValue(Object value) throws FactoryException {
        if (value == null) {
            this.buffer.append("NULL");
        } else if (value instanceof Boolean) {
            this.buffer.append((Boolean)value != false ? "TRUE" : "FALSE");
        } else if (value instanceof Number) {
            this.buffer.append(value);
        } else {
            if (value instanceof IdentifiedObject) {
                value = ReferencingServices.getInstance().getPreferredIdentifier((IdentifiedObject)value);
            }
            this.buffer.append('\'').append(SQLBuilder.doubleQuotes(value)).append('\'');
        }
        return this;
    }

    public final SQLBuilder appendEscaped(String value) {
        StringTokenizer tokens = new StringTokenizer(value, "_%", true);
        while (tokens.hasMoreTokens()) {
            this.buffer.append(tokens.nextToken());
            if (!tokens.hasMoreTokens()) break;
            this.buffer.append(this.escape).append(tokens.nextToken());
        }
        return this;
    }

    public final String createColumn(String schema, String table, String column, Class<?> type, int maxLength) {
        this.clear().append("ALTER TABLE ").appendIdentifier(schema, table).append(" ADD COLUMN ").appendIdentifier(column).append(' ');
        String sqlType = TypeMapper.keywordFor(type);
        if (sqlType != null) {
            this.append(sqlType);
        } else {
            this.append("VARCHAR(").append(maxLength).append(')');
        }
        return this.toString();
    }

    public final String createForeignKey(String schema, String table, String column, String target, String primaryKey, boolean cascade) {
        if (this.dialect == Dialect.DERBY) {
            cascade = false;
        }
        this.buffer.setLength(0);
        String name = this.buffer.append(table).append('_').append(column).append("_fkey").toString();
        return this.clear().append("ALTER TABLE ").appendIdentifier(schema, table).append(" ADD CONSTRAINT ").appendIdentifier(name).append(" FOREIGN KEY(").appendIdentifier(column).append(") REFERENCES ").appendIdentifier(schema, target).append(" (").appendIdentifier(primaryKey).append(") ON UPDATE ").append(cascade ? "CASCADE" : "RESTRICT").append(" ON DELETE RESTRICT").toString();
    }

    public static String doubleQuotes(Object value) {
        return value.toString().replace("'", "''");
    }

    public final String toString() {
        return this.buffer.toString();
    }
}

