/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.referencing;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.measure.Unit;
import javax.xml.bind.annotation.XmlElement;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gco.PropertyType;
import org.apache.sis.internal.jaxb.referencing.CC_GeneralOperationParameter;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.provider.MapProjection;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.DefaultParameterValueGroup;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public final class CC_OperationMethod
extends PropertyType<CC_OperationMethod, OperationMethod> {
    public CC_OperationMethod() {
    }

    @Override
    protected Class<OperationMethod> getBoundType() {
        return OperationMethod.class;
    }

    private CC_OperationMethod(OperationMethod method) {
        super(method);
    }

    @Override
    protected CC_OperationMethod wrap(OperationMethod method) {
        return new CC_OperationMethod(method);
    }

    @XmlElement(name="OperationMethod")
    public DefaultOperationMethod getElement() {
        return DefaultOperationMethod.castOrCopy((OperationMethod)this.metadata);
    }

    public void setElement(DefaultOperationMethod method) {
        if (!CC_GeneralOperationParameter.isValid((GeneralParameterDescriptor)method.getParameters())) {
            throw new IllegalArgumentException(Errors.format((short)89, "parameters"));
        }
        this.metadata = method;
    }

    public static GeneralParameterValue[] filterImplicit(GeneralParameterValue[] array) {
        int n = 0;
        for (GeneralParameterValue value : array) {
            if (CC_OperationMethod.isImplicitParameter(value.getDescriptor())) continue;
            array[n++] = value;
        }
        return ArraysExt.resize(array, n);
    }

    public static GeneralParameterDescriptor[] filterImplicit(GeneralParameterDescriptor[] array) {
        int n = 0;
        for (GeneralParameterDescriptor descriptor : array) {
            if (CC_OperationMethod.isImplicitParameter(descriptor)) continue;
            array[n++] = descriptor;
        }
        return ArraysExt.resize(array, n);
    }

    static boolean isImplicitParameter(GeneralParameterDescriptor descriptor) {
        return descriptor == MapProjection.SEMI_MAJOR || descriptor == MapProjection.SEMI_MINOR;
    }

    public static ParameterDescriptorGroup group(Identifier name, GeneralParameterDescriptor[] descriptors) {
        OperationMethod method;
        try {
            method = CoordinateOperations.factory().getOperationMethod(name.getCode());
        }
        catch (FactoryException e) {
            Context.warningOccured(Context.current(), DefaultOperationMethod.class, "setDescriptors", (Exception)((Object)e), true);
            method = null;
        }
        Map<String, Identifier> properties = Collections.singletonMap("name", name);
        if (method != null) {
            ParameterDescriptorGroup parameters = method.getParameters();
            return CC_GeneralOperationParameter.merge(DefaultOperationMethod.class, properties, IdentifiedObjects.getProperties((IdentifiedObject)parameters, new String[0]), 1, 1, descriptors, parameters, true);
        }
        return new DefaultParameterDescriptorGroup(properties, 1, 1, descriptors);
    }

    public static void store(GeneralParameterValue[] parameters, Collection<GeneralParameterValue> addTo, Map<GeneralParameterDescriptor, GeneralParameterDescriptor> replacements) {
        for (Object p : parameters) {
            GeneralParameterDescriptor replacement = replacements.get(p.getDescriptor());
            if (replacement != null) {
                Cloneable target;
                ParameterValue source;
                if (p instanceof ParameterValue) {
                    source = (ParameterValue)p;
                    target = new DefaultParameterValue((ParameterDescriptor)replacement);
                    Object value = source.getValue();
                    Unit unit = source.getUnit();
                    if (unit == null) {
                        target.setValue(value);
                    } else if (value instanceof double[]) {
                        target.setValue((double[])value, unit);
                    } else {
                        target.setValue(((Number)value).doubleValue(), unit);
                    }
                    p = target;
                } else if (p instanceof ParameterValueGroup) {
                    source = (ParameterValueGroup)p;
                    target = new DefaultParameterValueGroup((ParameterDescriptorGroup)replacement);
                    List values = source.values();
                    CC_OperationMethod.store(values.toArray(new GeneralParameterValue[values.size()]), target.values(), replacements);
                    p = target;
                }
            }
            addTo.add((GeneralParameterValue)p);
        }
    }
}

