/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.metadata.replace;

import java.util.Objects;
import java.util.Set;
import javax.measure.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gco.GO_GenericName;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.simple.SimpleIdentifiedObject;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.iso.DefaultMemberName;
import org.apache.sis.util.iso.Names;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.MemberName;
import org.opengis.util.TypeName;

@XmlType(name="SV_Parameter_Type", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0", propOrder={"memberName", "legacyName", "description", "optionality", "optionalityLabel", "repeatability", "valueType"})
@XmlRootElement(name="SV_Parameter", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0")
public final class ServiceParameter
extends SimpleIdentifiedObject
implements ParameterDescriptor {
    private static final long serialVersionUID = -5335736212313243889L;
    @XmlElement(required=true, name="name")
    @XmlJavaTypeAdapter(value=GO_GenericName.Since2014.class)
    MemberName memberName;
    @XmlElement
    InternationalString description;
    public boolean optionality;
    @XmlElement(required=true)
    public boolean repeatability;
    private transient ParameterDescriptor descriptor;

    ServiceParameter() {
    }

    private ServiceParameter(ParameterDescriptor<?> parameter) {
        super((IdentifiedObject)parameter);
        this.memberName = ServiceParameter.getMemberName(parameter);
        this.optionality = parameter.getMinimumOccurs() > 0;
        this.repeatability = parameter.getMaximumOccurs() > 1;
    }

    public static ServiceParameter castOrCopy(ParameterDescriptor<?> parameter) {
        if (parameter == null || parameter instanceof ServiceParameter) {
            return (ServiceParameter)parameter;
        }
        return new ServiceParameter(parameter);
    }

    public static MemberName getMemberName(ParameterDescriptor<?> parameter) {
        if (parameter != null) {
            String code;
            Class valueClass;
            ReferenceIdentifier id = parameter.getName();
            if (id instanceof MemberName) {
                return (MemberName)id;
            }
            for (GenericName alias : CollectionsExt.nonNull(parameter.getAlias())) {
                if (!(alias instanceof MemberName)) continue;
                return (MemberName)alias;
            }
            if (id != null && (valueClass = parameter.getValueClass()) != null && (code = id.getCode()) != null) {
                return Names.createMemberName(id.getCodeSpace(), null, code, valueClass);
            }
        }
        return null;
    }

    @XmlElement(name="name", namespace="http://www.isotc211.org/2005/srv")
    private DefaultMemberName getLegacyName() {
        return FilterByVersion.LEGACY_METADATA.accept() ? DefaultMemberName.castOrCopy(this.memberName) : null;
    }

    private void setLegacyName(DefaultMemberName value) {
        this.ensureUndefined();
        this.memberName = value;
    }

    private void ensureUndefined() throws IllegalStateException {
        if (this.memberName != null) {
            throw new IllegalStateException(Errors.format((short)164, "name"));
        }
    }

    @Override
    public synchronized ReferenceIdentifier getName() {
        if (this.name == null && this.memberName != null) {
            this.name = this.memberName instanceof ReferenceIdentifier ? (ReferenceIdentifier)this.memberName : new NameToIdentifier((GenericName)this.memberName);
        }
        return this.name;
    }

    public Class<?> getValueClass() {
        return this.memberName != null ? Names.toClass(this.memberName.getAttributeType()) : null;
    }

    @XmlElement(name="valueType", namespace="http://www.isotc211.org/2005/srv")
    @XmlJavaTypeAdapter(value=GO_GenericName.class)
    final TypeName getValueType() {
        if (this.memberName != null && FilterByVersion.LEGACY_METADATA.accept()) {
            return this.memberName.getAttributeType();
        }
        return null;
    }

    public InternationalString getDescription() {
        return this.description;
    }

    @XmlElement(name="optionality", required=true)
    final Boolean getOptionality() {
        return FilterByVersion.CURRENT_METADATA.accept() ? Boolean.valueOf(this.optionality) : null;
    }

    final void setOptionality(Boolean optional) {
        if (optional != null) {
            this.optionality = optional;
        }
    }

    @XmlElement(name="optionality", namespace="http://www.isotc211.org/2005/srv")
    final String getOptionalityLabel() {
        return FilterByVersion.LEGACY_METADATA.accept() ? (this.optionality ? "Optional" : "Mandatory") : null;
    }

    final void setOptionalityLabel(String optional) {
        if (optional != null) {
            this.optionality = Boolean.parseBoolean(optional) || optional.equalsIgnoreCase("Optional");
        }
    }

    public int getMinimumOccurs() {
        return this.optionality ? 0 : 1;
    }

    public int getMaximumOccurs() {
        return this.repeatability ? Integer.MAX_VALUE : 1;
    }

    public Set<?> getValidValues() {
        return null;
    }

    public Comparable<?> getMinimumValue() {
        return null;
    }

    public Comparable<?> getMaximumValue() {
        return null;
    }

    public Object getDefaultValue() {
        return null;
    }

    public Unit<?> getUnit() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParameterValue<?> createValue() {
        ParameterDescriptor<?> desc;
        ServiceParameter serviceParameter = this;
        synchronized (serviceParameter) {
            desc = this.descriptor;
            if (desc == null) {
                this.descriptor = desc = ReferencingServices.getInstance().toImplementation(this);
            }
        }
        return desc.createValue();
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        ParameterDescriptor that;
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode) && object instanceof ParameterDescriptor && (that = (ParameterDescriptor)object).getUnit() == null && that.getDefaultValue() == null && that.getValueClass() == this.getValueClass()) {
            if (mode.isIgnoringMetadata()) {
                return Objects.equals(ServiceParameter.toString((Identifier)this.getName()), ServiceParameter.toString((Identifier)that.getName()));
            }
            return that.getMinimumOccurs() == this.getMinimumOccurs() && that.getMaximumOccurs() == this.getMaximumOccurs() && that.getValidValues() == null && that.getMinimumValue() == null && that.getMaximumValue() == null;
        }
        return false;
    }

    private static String toString(Identifier identifier) {
        return identifier != null ? identifier.toString() : null;
    }
}

