/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.metadata.replace;

import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.metadata.replace.RS_Identifier;
import org.apache.sis.internal.simple.SimpleIdentifiedObject;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.ReferenceSystem;

@XmlType(name="MD_ReferenceSystem_Type", namespace="http://standards.iso.org/iso/19115/-3/mrs/1.0")
@XmlRootElement(name="MD_ReferenceSystem", namespace="http://standards.iso.org/iso/19115/-3/mrs/1.0")
public class ReferenceSystemMetadata
extends SimpleIdentifiedObject
implements ReferenceSystem {
    private static final long serialVersionUID = 2810145397032096087L;
    private boolean isLegacyMetadata;

    public ReferenceSystemMetadata() {
    }

    public ReferenceSystemMetadata(ReferenceSystem crs) {
        super((IdentifiedObject)crs);
    }

    public ReferenceSystemMetadata(ReferenceIdentifier name) {
        super(name);
    }

    private void beforeMarshal(Marshaller marshaller) {
        this.isLegacyMetadata = !FilterByVersion.CURRENT_METADATA.accept();
    }

    @Override
    @XmlElement(name="referenceSystemIdentifier")
    public final ReferenceIdentifier getName() {
        ReferenceIdentifier name = super.getName();
        if (this.isLegacyMetadata) {
            name = RS_Identifier.wrap((Identifier)name);
        }
        return name;
    }

    public final void setName(ReferenceIdentifier name) {
        this.name = name;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (super.equals(object, mode) && object instanceof ReferenceSystem) {
            ReferenceSystem that = (ReferenceSystem)object;
            if (mode.isIgnoringMetadata()) {
                return Utilities.deepEquals(this.getName(), that.getName(), mode);
            }
            return that.getDomainOfValidity() == null && that.getScope() == null;
        }
        return false;
    }
}

