/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.lan;

import java.util.Locale;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.lan.LanguageCode;
import org.apache.sis.internal.jaxb.lan.PT_Locale;

public final class LocaleAdapter
extends XmlAdapter<LanguageCode, Locale> {
    private LocaleAdapter() {
    }

    public Locale unmarshal(LanguageCode value) {
        Context context = Context.current();
        return Context.converter(context).toLocale(context, value.getLanguage());
    }

    public LanguageCode marshal(Locale value) {
        return LanguageCode.create(Context.current(), value);
    }

    public static final class Wrapped
    extends XmlAdapter<PT_Locale, Locale> {
        private Wrapped() {
        }

        public PT_Locale marshal(Locale value) {
            if (value == null) {
                return null;
            }
            PT_Locale p = new PT_Locale(value);
            p.setCharacterSet(null);
            return p;
        }

        public Locale unmarshal(PT_Locale value) {
            return value != null ? value.getLocale() : null;
        }
    }
}

