/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gml;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.sis.internal.geoapi.temporal.Instant;
import org.apache.sis.internal.jaxb.gml.TimeInstant;

@XmlTransient
public abstract class TimePeriodBound {
    TimePeriodBound() {
    }

    abstract XMLGregorianCalendar calendar();

    public String toString() {
        return String.valueOf(this.calendar());
    }

    public static final class GML2
    extends TimePeriodBound {
        @XmlElement(name="TimeInstant")
        public TimeInstant timeInstant;

        public GML2() {
        }

        GML2(Instant instant) {
            this.timeInstant = new TimeInstant(instant);
        }

        @Override
        XMLGregorianCalendar calendar() {
            TimeInstant timeInstant = this.timeInstant;
            return timeInstant != null ? timeInstant.timePosition : null;
        }
    }

    public static final class GML3
    extends TimePeriodBound {
        @XmlAttribute
        public String indeterminatePosition;
        @XmlValue
        public XMLGregorianCalendar value;

        public GML3() {
        }

        GML3(Instant instant, String indeterminate) {
            this.value = TimeInstant.toXML(instant);
            if (this.value == null) {
                this.indeterminatePosition = indeterminate;
            }
        }

        @Override
        XMLGregorianCalendar calendar() {
            return this.value;
        }
    }
}

