/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gml;

import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import org.apache.sis.internal.geoapi.temporal.Instant;
import org.apache.sis.internal.geoapi.temporal.Period;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gco.PropertyType;
import org.apache.sis.internal.jaxb.gml.TimeInstant;
import org.apache.sis.internal.jaxb.gml.TimePeriod;
import org.apache.sis.internal.jaxb.gml.TimePeriodBound;
import org.apache.sis.internal.util.TemporalUtilities;
import org.apache.sis.internal.xml.XmlUtilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.temporal.TemporalPrimitive;

public class TM_Primitive
extends PropertyType<TM_Primitive, TemporalPrimitive> {
    public TM_Primitive() {
    }

    private TM_Primitive(TemporalPrimitive metadata) {
        super(metadata);
    }

    @Override
    protected TM_Primitive wrap(TemporalPrimitive value) {
        return new TM_Primitive(value);
    }

    @Override
    protected final Class<TemporalPrimitive> getBoundType() {
        return TemporalPrimitive.class;
    }

    @XmlElement(name="TimePeriod")
    public final TimePeriod getTimePeriod() {
        TemporalPrimitive metadata = (TemporalPrimitive)this.metadata;
        return metadata instanceof Period ? new TimePeriod((Period)metadata) : null;
    }

    @XmlElement(name="TimeInstant")
    public final TimeInstant getTimeInstant() {
        TemporalPrimitive metadata = (TemporalPrimitive)this.metadata;
        return metadata instanceof Instant ? new TimeInstant((Instant)metadata) : null;
    }

    public final void setTimePeriod(TimePeriod period) {
        this.metadata = null;
        if (period != null) {
            Context context = Context.current();
            Date begin = TM_Primitive.toDate(context, period.begin);
            Date end = TM_Primitive.toDate(context, period.end);
            if (begin != null || end != null) {
                if (begin != null && end != null && end.before(begin)) {
                    Context.warningOccured(context, TemporalPrimitive.class, "setTimePeriod", Errors.class, (short)60, begin, end);
                } else {
                    try {
                        this.metadata = TemporalUtilities.createPeriod(begin, end);
                        period.copyIdTo(this.metadata);
                    }
                    catch (UnsupportedOperationException e) {
                        TM_Primitive.warningOccured("setTimePeriod", e);
                    }
                }
            }
        }
    }

    public final void setTimeInstant(TimeInstant instant) {
        Date position;
        this.metadata = null;
        if (instant != null && (position = XmlUtilities.toDate(Context.current(), instant.timePosition)) != null) {
            try {
                this.metadata = TemporalUtilities.createInstant(position);
                instant.copyIdTo(this.metadata);
            }
            catch (UnsupportedOperationException e) {
                TM_Primitive.warningOccured("setTimeInstant", e);
            }
        }
    }

    private static Date toDate(Context context, TimePeriodBound bound) {
        return bound != null ? XmlUtilities.toDate(context, bound.calendar()) : null;
    }

    private static void warningOccured(String method, Exception e) {
        if (!e.getMessage().contains("sis-temporal")) {
            Context.warningOccured(Context.current(), TM_Primitive.class, method, e, true);
        }
    }

    public static final class Since2014
    extends TM_Primitive {
        @Override
        protected TM_Primitive wrap(TemporalPrimitive value) {
            return this.accept2014() ? super.wrap(value) : null;
        }
    }
}

