/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gml;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.measure.Units;
import org.apache.sis.util.resources.Errors;

@XmlType(name="MeasureType")
public final class Measure {
    private static final UnitFormat UCUM = new UnitFormat(Locale.ROOT);
    @XmlValue
    public double value;
    public Unit<?> unit;
    public boolean asXPointer;

    public Measure() {
        this.value = Double.NaN;
    }

    public Measure(double value, Unit<?> unit) {
        this.value = value;
        this.unit = unit;
    }

    @XmlAttribute(name="uom", required=true)
    public String getUOM() {
        return Measure.getUOM(this.unit, this.asXPointer, false);
    }

    public static String getUOM(Unit<?> unit, boolean asXPointer, boolean inAxis) {
        Integer code;
        if (!asXPointer && (code = Units.getEpsgCode(unit, inAxis)) != null) {
            return "urn:ogc:def:uom:EPSG::" + code;
        }
        if (unit == null || unit.equals(Units.UNITY)) {
            return "";
        }
        Context context = Context.current();
        StringBuilder link = Context.schema(context, "gmd", "http://schemas.opengis.net/iso/19139/20070417/");
        link.append("resources/uom/gmxUom.xml").append("#xpointer(//*[@gml:id='");
        try {
            UCUM.format(unit, link);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return link.append("'])").toString();
    }

    public void setUOM(String uom) throws URISyntaxException {
        Context context = Context.current();
        this.unit = Context.converter(context).toUnit(context, uom);
    }

    public <Q extends Quantity<Q>> Unit<Q> getUnit(Class<Q> type) {
        return this.unit != null ? this.unit.asType(type) : null;
    }

    public boolean setUnit(Unit<?> newUnit) {
        boolean changed = this.unit != null && !this.unit.equals(newUnit);
        this.unit = newUnit;
        return changed;
    }

    public static void missingUOM(Class<?> caller, String methodName) {
        Context.warningOccured(Context.current(), caller, methodName, Errors.class, (short)76, "uom", "Measure");
    }

    static {
        UCUM.setStyle(UnitFormat.Style.UCUM);
    }
}

