/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gco;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlType(name="UnlimitedInteger_Type")
@XmlRootElement(name="UnlimitedInteger")
final class UnlimitedInteger {
    @XmlValue
    @XmlSchemaType(name="nonNegativeInteger")
    private Integer value;
    @XmlAttribute(name="isInfinite")
    private Boolean isInfinite;

    UnlimitedInteger() {
    }

    UnlimitedInteger(Integer value, boolean inclusive) {
        if (value == null) {
            this.isInfinite = Boolean.TRUE;
        } else {
            if (!inclusive) {
                value = Math.decrementExact(value);
            }
            this.value = value;
        }
    }

    final boolean isInfinite() {
        return this.isInfinite != null && this.isInfinite != false;
    }

    final Integer value() {
        return this.isInfinite() ? null : this.value;
    }

    @XmlAttribute(name="nil", namespace="http://www.w3.org/2001/XMLSchema-instance")
    private Boolean getNil() {
        return this.value == null ? Boolean.TRUE : null;
    }

    private void setNil(Boolean nil) {
        if (nil != null && nil.booleanValue()) {
            this.value = null;
        }
    }

    public String toString() {
        return this.isInfinite() ? "\u221e" : (this.value == null ? "nil" : this.value.toString());
    }
}

