/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gco;

import java.util.Locale;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gco.CharSequenceAdapter;
import org.apache.sis.internal.jaxb.gco.GO_CharacterString;
import org.opengis.util.InternationalString;

public class StringAdapter
extends XmlAdapter<GO_CharacterString, String> {
    protected StringAdapter() {
    }

    public static String toString(CharSequence text) {
        Locale locale;
        Context context;
        if (text == null) {
            return null;
        }
        if (text instanceof InternationalString && (context = Context.current()) != null && (locale = context.getLocale()) != null) {
            return ((InternationalString)text).toString(locale);
        }
        return text.toString();
    }

    static String toString(GO_CharacterString value) {
        return value != null ? StringAdapter.toString(value.toCharSequence()) : null;
    }

    public String unmarshal(GO_CharacterString value) {
        return StringAdapter.toString(value);
    }

    public GO_CharacterString marshal(String value) {
        return CharSequenceAdapter.wrap(Context.current(), value, value);
    }

    public static final class Since2014
    extends StringAdapter {
        @Override
        public GO_CharacterString marshal(String value) {
            return FilterByVersion.CURRENT_METADATA.accept() ? super.marshal(value) : null;
        }
    }
}

