/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.jts;

import java.util.Map;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.internal.feature.jts.GeometryCoordinateTransform;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.referencing.CRS;
import org.apache.sis.util.Static;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class JTS
extends Static {
    public static final String CRS_KEY = "CRS";

    private JTS() {
    }

    public static CoordinateReferenceSystem getCoordinateReferenceSystem(Geometry geometry) throws FactoryException {
        if (geometry != null) {
            Map map;
            Object value;
            Object userData = geometry.getUserData();
            if (userData instanceof CoordinateReferenceSystem) {
                return (CoordinateReferenceSystem)userData;
            }
            if (userData instanceof Map && (value = (map = (Map)userData).get(CRS_KEY)) instanceof CoordinateReferenceSystem) {
                return (CoordinateReferenceSystem)value;
            }
            int srid = geometry.getSRID();
            if (srid > 0) {
                return CRS.forCode("EPSG:" + srid);
            }
        }
        return null;
    }

    private static CoordinateOperation findOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, Geometry areaOfInterest) throws FactoryException {
        DefaultGeographicBoundingBox bbox = new DefaultGeographicBoundingBox();
        try {
            Envelope e = areaOfInterest.getEnvelopeInternal();
            bbox.setBounds(new Envelope2D(sourceCRS, e.getMinX(), e.getMinY(), e.getWidth(), e.getHeight()));
        }
        catch (TransformException ex) {
            bbox = null;
            Logging.ignorableException(Logging.getLogger("org.apache.sis.geometry"), JTS.class, "transform", ex);
        }
        return CRS.findOperation(sourceCRS, targetCRS, bbox);
    }

    public static Geometry transform(Geometry geometry, CoordinateReferenceSystem targetCRS) throws FactoryException, TransformException {
        if (geometry != null && targetCRS != null) {
            CoordinateReferenceSystem sourceCRS = JTS.getCoordinateReferenceSystem(geometry);
            if (sourceCRS == null) {
                throw new TransformException(Errors.format((short)157));
            }
            if (!Utilities.equalsIgnoreMetadata(sourceCRS, targetCRS)) {
                geometry = JTS.transform(geometry, JTS.findOperation(sourceCRS, targetCRS, geometry));
            }
        }
        return geometry;
    }

    public static Geometry transform(Geometry geometry, CoordinateOperation operation) throws FactoryException, TransformException {
        if (geometry != null && operation != null) {
            CoordinateReferenceSystem crs;
            CoordinateReferenceSystem sourceCRS = operation.getSourceCRS();
            if (sourceCRS != null && (crs = JTS.getCoordinateReferenceSystem(geometry)) != null && !Utilities.equalsIgnoreMetadata(sourceCRS, crs)) {
                operation = JTS.findOperation(crs, operation.getTargetCRS(), geometry);
            }
            geometry = JTS.transform(geometry, operation.getMathTransform());
            geometry.setUserData((Object)operation.getTargetCRS());
        }
        return geometry;
    }

    public static Geometry transform(Geometry geometry, MathTransform transform) throws TransformException {
        if (geometry != null && transform != null && !transform.isIdentity()) {
            GeometryCoordinateTransform gct = new GeometryCoordinateTransform(transform, geometry.getFactory());
            geometry = gct.transform(geometry);
        }
        return geometry;
    }
}

