/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.j2d.ShapeProperties;
import org.apache.sis.internal.referencing.j2d.ShapeUtilities;
import org.apache.sis.math.Vector;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.UnsupportedImplementationException;

final class Java2D
extends Geometries<Shape> {
    Java2D() {
        super(GeometryLibrary.JAVA2D, Shape.class, Point2D.class, Shape.class, Shape.class);
    }

    @Override
    final String tryGetLabel(Object geometry) {
        if (geometry instanceof Shape) {
            Class<?> c = geometry.getClass();
            Class<?> e = c.getEnclosingClass();
            return Classes.getShortName(e != null ? e : c);
        }
        return null;
    }

    @Override
    final GeneralEnvelope tryGetEnvelope(Object geometry) {
        Rectangle2D bounds;
        if (geometry instanceof Shape && !(bounds = ((Shape)geometry).getBounds2D()).isEmpty()) {
            GeneralEnvelope env = new GeneralEnvelope(2);
            env.setRange(0, bounds.getMinX(), bounds.getMaxX());
            env.setRange(1, bounds.getMinY(), bounds.getMaxY());
            return env;
        }
        return null;
    }

    @Override
    final double[] tryGetCoordinate(Object point) {
        if (point instanceof Point2D) {
            Point2D pt = (Point2D)point;
            return new double[]{pt.getX(), pt.getY()};
        }
        return null;
    }

    @Override
    final Object tryGetCentroid(Object geometry) {
        if (geometry instanceof Shape) {
            RectangularShape frame = geometry instanceof RectangularShape ? (RectangularShape)geometry : ((Shape)geometry).getBounds2D();
            return new Point2D.Double(frame.getCenterX(), frame.getCenterY());
        }
        return null;
    }

    @Override
    public Object createPoint(double x, double y) {
        return new Point2D.Double(x, y);
    }

    @Override
    public Shape createPolyline(int dimension, Vector ... coordinates) {
        double y2;
        double x2;
        double y1;
        Vector v;
        double x1;
        if (dimension != 2) {
            throw new UnsupportedOperationException(Java2D.unsupported(dimension));
        }
        int length = 0;
        boolean isFloat = true;
        for (Vector v2 : coordinates) {
            if (v2 == null) continue;
            length = Math.addExact(length, v2.size());
            if (!isFloat) continue;
            isFloat = Numbers.getEnumConstant(v2.getElementType()) <= 8;
        }
        if (!((length /= 2) != 2 || coordinates.length != 1 || Double.isNaN(x1 = (v = coordinates[0]).doubleValue(0)) || Double.isNaN(y1 = v.doubleValue(1)) || Double.isNaN(x2 = v.doubleValue(2)) || Double.isNaN(y2 = v.doubleValue(3)))) {
            Line2D path = isFloat ? new Line2D.Float() : new Line2D.Double();
            path.setLine(x1, y1, x2, y2);
            return path;
        }
        Path2D path = isFloat ? new Path2D.Float(1, length) : new Path2D.Double(1, length);
        boolean lineTo = false;
        for (Vector v3 : coordinates) {
            int size = v3.size();
            int i = 0;
            while (i < size) {
                double x = v3.doubleValue(i++);
                double y = v3.doubleValue(i++);
                if (Double.isNaN(x) || Double.isNaN(y)) {
                    lineTo = false;
                    continue;
                }
                if (lineTo) {
                    path.lineTo(x, y);
                    continue;
                }
                path.moveTo(x, y);
                lineTo = true;
            }
        }
        return ShapeUtilities.toPrimitive(path);
    }

    @Override
    final Shape tryMergePolylines(Object next, Iterator<?> polylines) {
        if (!(next instanceof Shape) && !(next instanceof Point2D)) {
            return null;
        }
        boolean isFloat = ShapeUtilities.isFloat(next);
        Path2D path = isFloat ? new Path2D.Float() : new Path2D.Double();
        boolean lineTo = false;
        block0: while (true) {
            if (next instanceof Point2D) {
                double x = ((Point2D)next).getX();
                double y = ((Point2D)next).getY();
                if (Double.isNaN(x) || Double.isNaN(y)) {
                    lineTo = false;
                } else if (lineTo) {
                    path.lineTo(x, y);
                } else {
                    path.moveTo(x, y);
                    lineTo = true;
                }
            } else {
                path.append((Shape)next, false);
                lineTo = false;
            }
            while (polylines.hasNext()) {
                next = polylines.next();
                if (next == null) continue;
                if (!isFloat || ShapeUtilities.isFloat(next)) continue block0;
                path = new Path2D.Double(path);
                isFloat = false;
                continue block0;
            }
            break;
        }
        return ShapeUtilities.toPrimitive(path);
    }

    @Override
    final String tryFormatWKT(Object geometry, double flatness) {
        return geometry instanceof Shape ? new ShapeProperties((Shape)geometry).toWKT(flatness) : null;
    }

    @Override
    public Object parseWKT(String wkt) {
        throw new UnsupportedImplementationException(Java2D.unsupported("parseWKT"));
    }
}

