/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.math.Vector;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.Classes;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class JTS
extends Geometries<Geometry> {
    private final GeometryFactory factory = new GeometryFactory();

    JTS() {
        super(GeometryLibrary.JTS, Geometry.class, Point.class, LineString.class, Polygon.class);
    }

    @Override
    public Object parseWKT(String wkt) throws ParseException {
        return new WKTReader(this.factory).read(wkt);
    }

    @Override
    final String tryFormatWKT(Object geometry, double flatness) {
        return geometry instanceof Geometry ? ((Geometry)geometry).toText() : null;
    }

    @Override
    final String tryGetLabel(Object geometry) {
        return geometry instanceof Geometry ? Classes.getShortClassName(geometry) : null;
    }

    @Override
    final GeneralEnvelope tryGetEnvelope(Object geometry) {
        if (geometry instanceof Geometry) {
            Envelope bounds = ((Geometry)geometry).getEnvelopeInternal();
            GeneralEnvelope env = new GeneralEnvelope(2);
            env.setRange(0, bounds.getMinX(), bounds.getMaxX());
            env.setRange(1, bounds.getMinY(), bounds.getMaxY());
            if (!env.isEmpty()) {
                return env;
            }
        }
        return null;
    }

    @Override
    final double[] tryGetCoordinate(Object point) {
        double[] coord;
        Coordinate pt;
        if (point instanceof Point) {
            pt = ((Point)point).getCoordinate();
        } else if (point instanceof Coordinate) {
            pt = (Coordinate)point;
        } else {
            return null;
        }
        double z = pt.getZ();
        if (Double.isNaN(z)) {
            coord = new double[2];
        } else {
            coord = new double[3];
            coord[2] = z;
        }
        coord[1] = pt.y;
        coord[0] = pt.x;
        return coord;
    }

    @Override
    final CoordinateReferenceSystem tryGetCoordinateReferenceSystem(Object geometry) throws FactoryException {
        if (geometry instanceof Geometry) {
            return org.apache.sis.internal.feature.jts.JTS.getCoordinateReferenceSystem((Geometry)geometry);
        }
        return super.tryGetCoordinateReferenceSystem(geometry);
    }

    private static void copyMetadata(Geometry source, Geometry target) {
        target.setSRID(source.getSRID());
        Object crs = source.getUserData();
        if (!(crs instanceof CoordinateReferenceSystem)) {
            if (!(crs instanceof Map)) {
                return;
            }
            if (!((crs = ((Map)crs).get("CRS")) instanceof CoordinateReferenceSystem)) {
                return;
            }
        }
        target.setUserData(crs);
    }

    @Override
    final Object tryGetCentroid(Object geometry) {
        if (geometry instanceof Geometry) {
            Geometry jts = (Geometry)geometry;
            Point centroid = jts.getCentroid();
            JTS.copyMetadata(jts, (Geometry)centroid);
            return centroid;
        }
        return null;
    }

    @Override
    public Object createPoint(double x, double y) {
        return this.factory.createPoint(new Coordinate(x, y));
    }

    @Override
    public Geometry createPolyline(int dimension, Vector ... coords) {
        boolean is3D;
        boolean bl = is3D = dimension == 3;
        if (!is3D && dimension != 2) {
            throw new UnsupportedOperationException(JTS.unsupported(dimension));
        }
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>(32);
        ArrayList<LineString> lines = new ArrayList<LineString>();
        for (Vector v : coords) {
            if (v == null) continue;
            int size = v.size();
            int i = 0;
            while (i < size) {
                double x = v.doubleValue(i++);
                double y = v.doubleValue(i++);
                if (!Double.isNaN(x) && !Double.isNaN(y)) {
                    Coordinate c = is3D ? new Coordinate(x, y, v.doubleValue(i++)) : new Coordinate(x, y);
                    coordinates.add(c);
                    continue;
                }
                if (is3D) {
                    ++i;
                }
                this.toLineString(coordinates, lines);
                coordinates.clear();
            }
        }
        this.toLineString(coordinates, lines);
        return this.toGeometry(lines);
    }

    private void toLineString(List<Coordinate> coordinates, List<LineString> addTo) {
        int s = coordinates.size();
        if (s >= 2) {
            Coordinate[] ca = coordinates.toArray(new Coordinate[s]);
            Object line = ca[0].equals2D(ca[s - 1]) ? this.factory.createLinearRing(ca) : this.factory.createLineString(ca);
            addTo.add((LineString)line);
        }
    }

    private Geometry toGeometry(List<LineString> lines) {
        int s = lines.size();
        switch (s) {
            case 0: {
                return this.factory.createLinearRing((Coordinate[])null);
            }
            case 1: {
                return (Geometry)lines.get(0);
            }
        }
        return this.factory.createMultiLineString(lines.toArray(new LineString[s]));
    }

    @Override
    final Geometry tryMergePolylines(Object next, Iterator<?> polylines) {
        if (!(next instanceof MultiLineString || next instanceof LineString || next instanceof Point)) {
            return null;
        }
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        ArrayList<LineString> lines = new ArrayList<LineString>();
        block0: while (true) {
            if (next instanceof Point) {
                Coordinate pt = ((Point)next).getCoordinate();
                if (!Double.isNaN(pt.x) && !Double.isNaN(pt.y)) {
                    coordinates.add(pt);
                } else {
                    this.toLineString(coordinates, lines);
                    coordinates.clear();
                }
            } else {
                Geometry g = (Geometry)next;
                int n = g.getNumGeometries();
                for (int i = 0; i < n; ++i) {
                    LineString ls = (LineString)g.getGeometryN(i);
                    if (coordinates.isEmpty()) {
                        lines.add(ls);
                        continue;
                    }
                    coordinates.addAll(Arrays.asList(ls.getCoordinates()));
                    this.toLineString(coordinates, lines);
                    coordinates.clear();
                }
            }
            while (polylines.hasNext()) {
                next = polylines.next();
                if (next == null) continue;
                continue block0;
            }
            break;
        }
        this.toLineString(coordinates, lines);
        return this.toGeometry(lines);
    }

    @Override
    Object tryBuffer(Object geometry, double distance) {
        if (geometry instanceof Geometry) {
            Geometry jts = (Geometry)geometry;
            Geometry buffer = jts.buffer(distance);
            JTS.copyMetadata(jts, buffer);
            return buffer;
        }
        return null;
    }

    Geometry tryTransform(Object geometry, CoordinateOperation operation, CoordinateReferenceSystem targetCRS) throws FactoryException, TransformException {
        if (geometry instanceof Geometry) {
            if (operation != null) {
                return org.apache.sis.internal.feature.jts.JTS.transform((Geometry)geometry, operation);
            }
            return org.apache.sis.internal.feature.jts.JTS.transform((Geometry)geometry, targetCRS);
        }
        return null;
    }
}

