/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.math.Vector;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.Classes;
import org.apache.sis.util.UnsupportedImplementationException;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public abstract class Geometries<G> {
    public final GeometryLibrary library;
    public final Class<G> rootClass;
    public final Class<?> pointClass;
    public final Class<? extends G> polylineClass;
    public final Class<? extends G> polygonClass;
    private static Geometries<?> implementation;
    private final Geometries<?> fallback;

    Geometries(GeometryLibrary library, Class<G> rootClass, Class<?> pointClass, Class<? extends G> polylineClass, Class<? extends G> polygonClass) {
        this.library = library;
        this.rootClass = rootClass;
        this.pointClass = pointClass;
        this.polylineClass = polylineClass;
        this.polygonClass = polygonClass;
        this.fallback = implementation;
    }

    private static void register(String name) {
        String classname = Geometries.class.getName();
        classname = classname.substring(0, classname.lastIndexOf(46) + 1).concat(name);
        try {
            implementation = (Geometries)Class.forName(classname).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (LinkageError | ReflectiveOperationException e) {
            LogRecord record = Resources.forLocale(null).getLogRecord(Level.CONFIG, (short)19, name, e.toString());
            record.setLoggerName("org.apache.sis.geometry");
            Logging.log(Geometries.class, "register", record);
        }
    }

    public static Geometries<?> implementation(GeometryLibrary library) {
        if (library == null) {
            return implementation;
        }
        Geometries<?> g = implementation;
        while (g != null) {
            if (g.library == library) {
                return g;
            }
            g = g.fallback;
        }
        throw new IllegalArgumentException(Resources.format((short)21, (Object)library));
    }

    public static Geometries<?> implementation(Class<?> type) {
        Geometries<?> g = implementation;
        while (g != null) {
            if (g.rootClass.isAssignableFrom(type)) {
                return g;
            }
            g = g.fallback;
        }
        return implementation;
    }

    public static boolean isKnownType(Class<?> type) {
        Geometries<?> g = implementation;
        while (g != null) {
            if (g.rootClass.isAssignableFrom(type)) {
                return true;
            }
            g = g.fallback;
        }
        return false;
    }

    CoordinateReferenceSystem tryGetCoordinateReferenceSystem(Object point) throws FactoryException {
        return null;
    }

    public static CoordinateReferenceSystem getCoordinateReferenceSystem(Object geometry) throws FactoryException {
        Geometries<?> g = implementation;
        while (g != null) {
            CoordinateReferenceSystem crs = g.tryGetCoordinateReferenceSystem(geometry);
            if (crs != null) {
                return crs;
            }
            g = g.fallback;
        }
        return null;
    }

    abstract double[] tryGetCoordinate(Object var1);

    public static double[] getCoordinate(Object point) {
        Geometries<?> g = implementation;
        while (g != null) {
            double[] coord = g.tryGetCoordinate(point);
            if (coord != null) {
                return coord;
            }
            g = g.fallback;
        }
        return null;
    }

    abstract GeneralEnvelope tryGetEnvelope(Object var1);

    public static GeneralEnvelope getEnvelope(Object geometry) {
        Geometries<?> g = implementation;
        while (g != null) {
            GeneralEnvelope env = g.tryGetEnvelope(geometry);
            if (env != null) {
                return env;
            }
            g = g.fallback;
        }
        return null;
    }

    abstract Object tryGetCentroid(Object var1);

    public static Object getCentroid(Object geometry) {
        Geometries<?> g = implementation;
        while (g != null) {
            Object center = g.tryGetCentroid(geometry);
            if (center != null) {
                return center;
            }
            g = g.fallback;
        }
        return null;
    }

    abstract String tryGetLabel(Object var1);

    public static String toString(Object geometry) {
        Geometries<?> g = implementation;
        while (g != null) {
            String s = g.tryGetLabel(geometry);
            if (s != null) {
                GeneralEnvelope env = g.tryGetEnvelope(geometry);
                if (env != null) {
                    String bbox = env.toString();
                    s = s + bbox.substring(bbox.indexOf(40));
                }
                return s;
            }
            g = g.fallback;
        }
        return null;
    }

    public static String formatWKT(Object geometry, double flatness) {
        Geometries<?> g = implementation;
        while (g != null) {
            String wkt = g.tryFormatWKT(geometry, flatness);
            if (wkt != null) {
                return wkt;
            }
            g = g.fallback;
        }
        return null;
    }

    abstract String tryFormatWKT(Object var1, double var2);

    public abstract Object parseWKT(String var1) throws Exception;

    public abstract Object createPoint(double var1, double var3);

    public abstract G createPolyline(int var1, Vector ... var2);

    abstract G tryMergePolylines(Object var1, Iterator<?> var2);

    public static Object mergePolylines(Iterator<?> paths) {
        while (paths.hasNext()) {
            Object first = paths.next();
            if (first == null) continue;
            Geometries<?> g = implementation;
            while (g != null) {
                Object merged = g.tryMergePolylines(first, paths);
                if (merged != null) {
                    return merged;
                }
                g = g.fallback;
            }
            throw new ClassCastException(Geometries.unsupportedImplementation(first));
        }
        return null;
    }

    Object tryBuffer(Object geometry, double distance) {
        if (this.rootClass.isInstance(geometry)) {
            throw new UnsupportedImplementationException(Geometries.unsupported("buffer"));
        }
        return null;
    }

    public static Object buffer(Object geometry, double distance) {
        Geometries<?> g = implementation;
        while (g != null) {
            Object center = g.tryBuffer(geometry, distance);
            if (center != null) {
                return center;
            }
            g = g.fallback;
        }
        return null;
    }

    Object tryTransform(Object geometry, CoordinateOperation operation, CoordinateReferenceSystem targetCRS) throws FactoryException, TransformException {
        if (this.rootClass.isInstance(geometry)) {
            throw new UnsupportedImplementationException(Geometries.unsupported("transform"));
        }
        return null;
    }

    public static Object transform(Object geometry, CoordinateOperation operation) throws FactoryException, TransformException {
        if (geometry != null && operation != null) {
            Geometries<?> g = implementation;
            while (g != null) {
                Object result = g.tryTransform(geometry, operation, null);
                if (result != null) {
                    return result;
                }
                g = g.fallback;
            }
            if (!operation.getMathTransform().isIdentity()) {
                return null;
            }
        }
        return geometry;
    }

    public static Object transform(Object geometry, CoordinateReferenceSystem targetCRS) throws FactoryException, TransformException {
        if (geometry != null && targetCRS != null) {
            Geometries<?> g = implementation;
            while (g != null) {
                Object result = g.tryTransform(geometry, null, targetCRS);
                if (result != null) {
                    return result;
                }
                g = g.fallback;
            }
            return null;
        }
        return geometry;
    }

    static String unsupported(String operation) {
        return Errors.format((short)162, operation);
    }

    static String unsupported(int dimension) {
        return Resources.format((short)20, dimension);
    }

    private static String unsupportedImplementation(Object geometry) {
        return Errors.format((short)163, Classes.getClass(geometry));
    }

    static {
        Geometries.register("Java2D");
        Geometries.register("JTS");
        Geometries.register("ESRI");
    }
}

