/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.internal.feature.FeatureUtilities;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.util.Static;
import org.apache.sis.util.iso.Names;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.ScopedName;

public final class AttributeConvention
extends Static {
    private static final LocalName SCOPE = Names.createLocalName("Apache", null, "sis");
    public static final ScopedName IDENTIFIER_PROPERTY = Names.createScopedName((GenericName)SCOPE, null, "identifier");
    public static final ScopedName GEOMETRY_PROPERTY = Names.createScopedName((GenericName)SCOPE, null, "geometry");
    public static final ScopedName ENVELOPE_PROPERTY = Names.createScopedName((GenericName)SCOPE, null, "envelope");
    public static final ScopedName CRS_CHARACTERISTIC = Names.createScopedName((GenericName)SCOPE, null, "crs");
    public static final ScopedName MAXIMAL_LENGTH_CHARACTERISTIC = Names.createScopedName((GenericName)SCOPE, null, "maximalLength");
    public static final GenericName VALID_VALUES_CHARACTERISTIC = Names.createScopedName((GenericName)SCOPE, null, "validValues");
    public static final String IDENTIFIER = "sis:identifier";
    public static final String GEOMETRY = "sis:geometry";

    private AttributeConvention() {
    }

    public static boolean contains(GenericName name) {
        while (name instanceof ScopedName) {
            if (SCOPE.equals(((ScopedName)name).path())) {
                return true;
            }
            name = ((ScopedName)name).tail();
        }
        return false;
    }

    public static boolean hasIdentifier(DefaultFeatureType feature) {
        if (feature != null) {
            try {
                return feature.getProperty(IDENTIFIER) != null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isGeometryAttribute(AbstractIdentifiedType type) {
        while (type instanceof AbstractOperation) {
            type = ((AbstractOperation)type).getResult();
        }
        return type instanceof DefaultAttributeType && Geometries.isKnownType(((DefaultAttributeType)type).getValueClass());
    }

    public static boolean characterizedByCRS(AbstractIdentifiedType type) {
        return AttributeConvention.hasCharacteristic(type, CRS_CHARACTERISTIC.toString(), CoordinateReferenceSystem.class);
    }

    public static CoordinateReferenceSystem getCRSCharacteristic(Object attribute) {
        return (CoordinateReferenceSystem)AttributeConvention.getCharacteristic(attribute, CRS_CHARACTERISTIC.toString());
    }

    public static CoordinateReferenceSystem getCRSCharacteristic(DefaultFeatureType feature, AbstractIdentifiedType attribute) {
        return (CoordinateReferenceSystem)AttributeConvention.getCharacteristic(feature, attribute, CRS_CHARACTERISTIC.toString());
    }

    public static boolean characterizedByMaximalLength(AbstractIdentifiedType type) {
        return AttributeConvention.hasCharacteristic(type, MAXIMAL_LENGTH_CHARACTERISTIC.toString(), Integer.class);
    }

    public static Integer getMaximalLengthCharacteristic(Object attribute) {
        return (Integer)AttributeConvention.getCharacteristic(attribute, MAXIMAL_LENGTH_CHARACTERISTIC.toString());
    }

    public static Integer getMaximalLengthCharacteristic(DefaultFeatureType feature, AbstractIdentifiedType attribute) {
        return (Integer)AttributeConvention.getCharacteristic(feature, attribute, MAXIMAL_LENGTH_CHARACTERISTIC.toString());
    }

    private static boolean hasCharacteristic(AbstractIdentifiedType type, String name, Class<?> valueClass) {
        DefaultAttributeType<?> at;
        while (type instanceof AbstractOperation) {
            type = ((AbstractOperation)type).getResult();
        }
        if (type instanceof DefaultAttributeType && (at = ((DefaultAttributeType)type).characteristics().get(name)) != null) {
            return valueClass.isAssignableFrom(at.getValueClass());
        }
        return false;
    }

    private static Object getCharacteristic(Object attribute, String name) {
        if (attribute instanceof AbstractAttribute) {
            Object value;
            AbstractAttribute<?> at = ((AbstractAttribute)attribute).characteristics().get(name);
            if (at != null && (value = at.getValue()) != null) {
                return value;
            }
            DefaultAttributeType<?> type = ((AbstractAttribute)attribute).getType().characteristics().get(name);
            if (type != null) {
                return type.getDefaultValue();
            }
        }
        return null;
    }

    private static Object getCharacteristic(DefaultFeatureType feature, AbstractIdentifiedType property, String characteristic) {
        DefaultAttributeType<?> type;
        String referent = FeatureUtilities.linkOf(property);
        if (referent != null && feature != null) {
            property = feature.getProperty(referent);
        }
        if (property instanceof DefaultAttributeType && (type = ((DefaultAttributeType)property).characteristics().get(characteristic)) != null) {
            return type.getDefaultValue();
        }
        return null;
    }
}

