/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.earth.netcdf;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.sis.internal.netcdf.Convention;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Linearizer;
import org.apache.sis.internal.netcdf.Node;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.VariableRole;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransferFunction;
import org.apache.sis.storage.netcdf.AttributeNames;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class GCOM_C
extends Convention {
    private static final Pattern SENTINEL_VALUE = Pattern.compile(".*\\bGCOM-C\\b.*");
    private static final Map<String, String> ATTRIBUTES;
    private static final String GEOMETRY_DATA = "Geometry_data";
    private static final String[] NO_DATA;
    private static final String SUFFIX = "_DN";
    private static final String[] CORNERS;

    @Override
    protected boolean isApplicableTo(Decoder decoder) {
        String[] path = decoder.getSearchPath();
        decoder.setSearchPath("Global_attributes");
        String s = decoder.stringValue("Satellite");
        decoder.setSearchPath(path);
        return s != null && SENTINEL_VALUE.matcher(s).matches();
    }

    @Override
    public String[] getSearchPath() {
        return new String[]{"Global_attributes", null, "Processing_attributes"};
    }

    @Override
    public String mapAttributeName(String name) {
        return ATTRIBUTES.getOrDefault(name, name);
    }

    @Override
    public VariableRole roleOf(Variable variable) {
        String group;
        VariableRole role = super.roleOf(variable);
        if (role == VariableRole.COVERAGE && GEOMETRY_DATA.equalsIgnoreCase(group = variable.getGroupName())) {
            role = VariableRole.OTHER;
        }
        return role;
    }

    @Override
    public String nameOfDimension(Variable dataOrAxis, int index) {
        String name = super.nameOfDimension(dataOrAxis, index);
        if (name == null) {
            if ("QA_flag".equals(dataOrAxis.getName()) && dataOrAxis.getAttributeType("Spatial_resolution") != null) {
                switch (index) {
                    case 0: {
                        name = "Line grids";
                        break;
                    }
                    case 1: {
                        name = "Pixel grids";
                    }
                }
            }
        } else if ("Piexl grids".equalsIgnoreCase(name)) {
            name = "Pixel grids";
        }
        return name;
    }

    @Override
    public Set<Linearizer> linearizers(Decoder decoder) {
        return Collections.singleton(Linearizer.GROUND_TRACK);
    }

    @Override
    public Set<String> nameOfMappingNode(Variable data) {
        LinkedHashSet<String> names = new LinkedHashSet<String>(4);
        names.add(GEOMETRY_DATA);
        names.addAll(super.nameOfMappingNode(data));
        return names;
    }

    @Override
    public Map<String, Object> projection(Node node) {
        String method;
        String code;
        String name = node.getAttributeAsString("Image_projection");
        if (name == null) {
            return super.projection(node);
        }
        int s = name.indexOf(32);
        String string = code = s >= 0 ? name.substring(0, s) : name;
        if (code.equalsIgnoreCase("EQA")) {
            method = "Sinusoidal";
        } else if (code.equalsIgnoreCase("EQR")) {
            method = "Equidistant Cylindrical (Spherical)";
        } else if (code.equalsIgnoreCase("PS")) {
            method = "Polar Stereographic (variant A)";
        } else {
            return super.projection(node);
        }
        HashMap<String, Object> definition = new HashMap<String, Object>(4);
        definition.put("grid_mapping_name", method);
        definition.put("conversion_name", name);
        return definition;
    }

    @Override
    public MathTransform gridToCRS(Node node, MathTransform baseToCRS) throws TransformException {
        double[] corners = new double[CORNERS.length];
        for (int i = 0; i < corners.length; ++i) {
            corners[i] = node.getAttributeAsNumber(CORNERS[i]);
        }
        baseToCRS.transform(corners, 0, corners, 0, corners.length / 2);
        double sx = (corners[2] - corners[0] + (corners[6] - corners[4])) / 2.0;
        double sy = (corners[1] - corners[5] + (corners[3] - corners[7])) / 2.0;
        if (Double.isFinite(sx /= node.getAttributeAsNumber("Number_of_pixels") - 1.0) && Double.isFinite(sy /= node.getAttributeAsNumber("Number_of_lines") - 1.0)) {
            Matrix3 m = new Matrix3();
            m.m00 = sx;
            m.m11 = -sy;
            m.m02 = corners[0];
            m.m12 = corners[1];
            return MathTransforms.linear(m);
        }
        return super.gridToCRS(node, baseToCRS);
    }

    @Override
    public CommonCRS defaultHorizontalCRS(boolean spherical) {
        return CommonCRS.SPHERE;
    }

    @Override
    public NumberRange<?> validRange(Variable data) {
        NumberRange<?> range = super.validRange(data);
        if (range == null) {
            double min = data.getAttributeAsNumber("Minimum_valid_DN");
            double max = data.getAttributeAsNumber("Maximum_valid_DN");
            if (Double.isFinite(min) && Double.isFinite(max)) {
                range = NumberRange.createBestFit(min, true, max, true);
            }
        }
        return range;
    }

    @Override
    public Map<Number, Object> nodataValues(Variable data) {
        Map<Number, Object> pads = super.nodataValues(data);
        for (String name : NO_DATA) {
            double value = data.getAttributeAsNumber(name);
            if (!Double.isFinite(value)) continue;
            if (name.endsWith(SUFFIX)) {
                name = name.substring(0, name.length() - SUFFIX.length());
            }
            pads.put(value, name.replace('_', ' '));
        }
        return pads;
    }

    @Override
    public TransferFunction transferFunction(Variable data) {
        TransferFunction tr = super.transferFunction(data);
        if (tr.isIdentity()) {
            double slope = data.getAttributeAsNumber("Slope");
            double offset = data.getAttributeAsNumber("Offset");
            if (Double.isFinite(slope)) {
                tr.setScale(slope);
            }
            if (Double.isFinite(offset)) {
                tr.setOffset(offset);
            }
        }
        return tr;
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("title", "Product_name");
        m.put("product_version", "Product_version");
        m.put(AttributeNames.IDENTIFIER.TEXT, "Product_file_name");
        m.put("date_created", "Processing_UT");
        m.put(AttributeNames.CREATOR.INSTITUTION, "Processing_organization");
        m.put("summary", "Dataset_description");
        m.put(AttributeNames.PLATFORM.TEXT, "Satellite");
        m.put(AttributeNames.INSTRUMENT.TEXT, "Sensor");
        m.put("processing_level", "Product_level");
        m.put("source", "Input_files");
        m.put(AttributeNames.TIME.MINIMUM, "Scene_start_time");
        m.put(AttributeNames.TIME.MAXIMUM, "Scene_end_time");
        ATTRIBUTES = m;
        NO_DATA = new String[]{"Error_DN", "Land_DN", "Cloud_error_DN", "Retrieval_error_DN"};
        CORNERS = new String[]{"Upper_left_latitude", "Upper_left_longitude", "Upper_right_latitude", "Upper_right_longitude", "Lower_left_latitude", "Lower_left_longitude", "Lower_right_latitude", "Lower_right_longitude"};
    }
}

