/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage;

import java.awt.Point;
import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RasterFormatException;
import java.awt.image.WritableRaster;
import java.nio.Buffer;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.Static;

public final class RasterFactory
extends Static {
    private RasterFactory() {
    }

    public static WritableRaster createRaster(DataBuffer buffer, int width, int height, int pixelStride, int scanlineStride, int[] bankIndices, int[] bandOffsets, Point location) {
        ComponentSampleModel model;
        int dataType = buffer.getDataType();
        if (buffer.getNumBanks() == 1 && (bankIndices == null || bankIndices[0] == 0)) {
            switch (dataType) {
                case 0: 
                case 1: {
                    return WritableRaster.createInterleavedRaster(buffer, width, height, scanlineStride, pixelStride, bandOffsets, location);
                }
                case 3: {
                    if (bandOffsets.length != 1 || pixelStride != 1) break;
                    return WritableRaster.createBandedRaster(buffer, width, height, scanlineStride, new int[1], bandOffsets, location);
                }
            }
            model = new PixelInterleavedSampleModel(dataType, width, height, pixelStride, scanlineStride, bandOffsets);
        } else {
            if (bankIndices == null) {
                bankIndices = ArraysExt.range(0, bandOffsets.length);
            }
            if (pixelStride == 1) {
                switch (dataType) {
                    case 0: 
                    case 1: 
                    case 3: {
                        return WritableRaster.createBandedRaster(buffer, width, height, scanlineStride, bankIndices, bandOffsets, location);
                    }
                }
                model = new BandedSampleModel(dataType, width, height, scanlineStride, bankIndices, bandOffsets);
            } else {
                model = new ComponentSampleModel(dataType, width, height, pixelStride, scanlineStride, bankIndices, bandOffsets);
            }
        }
        return WritableRaster.createWritableRaster(model, buffer, location);
    }

    public static int getType(Class<?> sample, boolean unsigned) {
        switch (Numbers.getEnumConstant(sample)) {
            case 3: {
                if (!unsigned) break;
                return 0;
            }
            case 4: {
                return unsigned ? 1 : 2;
            }
            case 5: {
                if (unsigned) break;
                return 3;
            }
            case 8: {
                return 4;
            }
            case 9: {
                return 5;
            }
        }
        return 32;
    }

    public static DataBuffer wrap(int dataType, Buffer ... data) {
        Object arrays;
        int numBands = data.length;
        switch (dataType) {
            case 1: 
            case 2: {
                arrays = new short[numBands][];
                break;
            }
            case 3: {
                arrays = new int[numBands][];
                break;
            }
            case 0: {
                arrays = new byte[numBands][];
                break;
            }
            case 4: {
                arrays = new float[numBands][];
                break;
            }
            case 5: {
                arrays = new double[numBands][];
                break;
            }
            default: {
                return null;
            }
        }
        int[] offsets = new int[numBands];
        int length = 0;
        for (int i = 0; i < numBands; ++i) {
            Buffer buffer = data[i];
            ArgumentChecks.ensureNonNullElement("data", i, buffer);
            arrays[i] = (short[])buffer.array();
            offsets[i] = Math.addExact(buffer.arrayOffset(), buffer.position());
            int r = buffer.remaining();
            if (i == 0) {
                length = r;
                continue;
            }
            if (length == r) continue;
            throw new RasterFormatException(Resources.format((short)38));
        }
        switch (dataType) {
            case 0: {
                return new DataBufferByte((byte[][])arrays, length, offsets);
            }
            case 2: {
                return new DataBufferShort((short[][])arrays, length, offsets);
            }
            case 1: {
                return new DataBufferUShort((short[][])arrays, length, offsets);
            }
            case 3: {
                return new DataBufferInt((int[][])arrays, length, offsets);
            }
            case 4: {
                return new DataBufferFloat((float[][])arrays, length, offsets);
            }
            case 5: {
                return new DataBufferDouble((double[][])arrays, length, offsets);
            }
        }
        return null;
    }
}

