/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class ConvertedGridCoverage
extends GridCoverage {
    private final GridCoverage packed;
    private final MathTransform1D[] toConverted;
    private final MathTransform1D[] toPacked;
    private final boolean isIdentity;

    public static GridCoverage create(GridCoverage packed) {
        List<SampleDimension> sds = packed.getSampleDimensions();
        ArrayList<SampleDimension> cfs = new ArrayList<SampleDimension>(sds.size());
        for (SampleDimension sd : sds) {
            cfs.add(sd.forConvertedValues(true));
        }
        return cfs.equals(sds) ? packed : new ConvertedGridCoverage(packed, sds, cfs);
    }

    private ConvertedGridCoverage(GridCoverage packed, List<SampleDimension> sampleDimensions, List<SampleDimension> converted) {
        super(packed.getGridGeometry(), converted);
        int numBands = sampleDimensions.size();
        this.toConverted = new MathTransform1D[numBands];
        this.toPacked = new MathTransform1D[numBands];
        boolean isIdentity = true;
        MathTransform1D identity = (MathTransform1D)MathTransforms.identity(1);
        for (int i = 0; i < numBands; ++i) {
            MathTransform1D tr;
            this.toConverted[i] = tr = sampleDimensions.get(i).getTransferFunction().orElse(identity);
            isIdentity &= tr.isIdentity();
            try {
                tr = tr.inverse();
            }
            catch (NoninvertibleTransformException ex) {
                tr = (MathTransform1D)MathTransforms.linear(Double.NaN, 0.0);
            }
            this.toPacked[i] = tr;
        }
        this.isIdentity = isIdentity;
        this.packed = packed;
    }

    @Override
    public RenderedImage render(GridExtent sliceExtent) {
        RenderedImage render = this.packed.render(sliceExtent);
        if (this.isIdentity) {
            return render;
        }
        Raster raster = render.getNumXTiles() == 1 && render.getNumYTiles() == 1 ? render.getTile(render.getMinTileX(), render.getMinTileY()) : render.getData();
        SampleModel baseSm = raster.getSampleModel();
        DataBuffer dataBuffer = raster.getDataBuffer();
        SampleConverter convSm = new SampleConverter(baseSm, this.toConverted, this.toPacked);
        WritableRaster convRaster = WritableRaster.createWritableRaster(convSm, dataBuffer, null);
        ScaledColorModel cm = new ScaledColorModel(this.getSampleDimensions().get(0).getSampleRange().get());
        return new BufferedImage(cm, convRaster, false, null);
    }

    @Override
    public GridCoverage forConvertedValues(boolean converted) {
        return converted ? this : this.packed;
    }

    private static final class ScaledColorModel
    extends ColorModel {
        private final float scale;
        private final float offset;

        ScaledColorModel(NumberRange<?> range) {
            super(32);
            double scale = 255.0 / (range.getMaxDouble() - range.getMinDouble());
            this.scale = (float)scale;
            this.offset = (float)(range.getMinDouble() / scale);
        }

        @Override
        public boolean isCompatibleRaster(Raster raster) {
            return this.isCompatibleSampleModel(raster.getSampleModel());
        }

        @Override
        public boolean isCompatibleSampleModel(SampleModel sm) {
            return sm instanceof SampleConverter;
        }

        @Override
        public int getRGB(Object inData) {
            float value = inData instanceof float[] ? ((float[])inData)[0] : (inData instanceof int[] ? (float)((int[])inData)[0] : (inData instanceof double[] ? (float)((double[])inData)[0] : (inData instanceof byte[] ? (float)((byte[])inData)[0] : (inData instanceof short[] ? (float)((short[])inData)[0] : (inData instanceof long[] ? (float)((long[])inData)[0] : (inData instanceof Number[] ? ((Number[])inData)[0].floatValue() : (inData instanceof Byte[] ? (float)((Byte[])inData)[0].byteValue() : 0.0f)))))));
            int c = (int)((value - this.offset) * this.scale);
            if (c < 0) {
                c = 0;
            } else if (c > 255) {
                c = 255;
            }
            return 0xFF000000 | c << 16 | c << 8 | c;
        }

        @Override
        public int getRed(int pixel) {
            int argb = this.getRGB((Object)pixel);
            return 0xFF & argb >>> 16;
        }

        @Override
        public int getGreen(int pixel) {
            int argb = this.getRGB((Object)pixel);
            return 0xFF & argb >>> 8;
        }

        @Override
        public int getBlue(int pixel) {
            int argb = this.getRGB((Object)pixel);
            return 0xFF & argb;
        }

        @Override
        public int getAlpha(int pixel) {
            int argb = this.getRGB((Object)pixel);
            return 0xFF & argb >>> 24;
        }

        @Override
        public int getRed(Object pixel) {
            int argb = this.getRGB(pixel);
            return 0xFF & argb >>> 16;
        }

        @Override
        public int getGreen(Object pixel) {
            int argb = this.getRGB(pixel);
            return 0xFF & argb >>> 8;
        }

        @Override
        public int getBlue(Object pixel) {
            int argb = this.getRGB(pixel);
            return 0xFF & argb;
        }

        @Override
        public int getAlpha(Object pixel) {
            int argb = this.getRGB(pixel);
            return 0xFF & argb >>> 24;
        }
    }

    private static final class SampleConverter
    extends SampleModel {
        private final SampleModel base;
        private final int baseDataType;
        private final MathTransform1D[] toConverted;
        private final MathTransform1D[] toPacked;

        SampleConverter(SampleModel base, MathTransform1D[] toConverted, MathTransform1D[] toPacked) {
            super(4, base.getWidth(), base.getHeight(), base.getNumBands());
            this.base = base;
            this.baseDataType = base.getDataType();
            this.toConverted = toConverted;
            this.toPacked = toPacked;
        }

        @Override
        public int getNumDataElements() {
            return this.base.getNumDataElements();
        }

        @Override
        public Object getDataElements(int x, int y, Object obj, DataBuffer data) {
            float[] pixel;
            Object buffer = this.base.getDataElements(x, y, null, data);
            if (obj == null) {
                pixel = new float[this.numBands];
            } else {
                if (!(obj instanceof float[])) {
                    throw new ClassCastException("Unsupported array type, expecting a float array.");
                }
                pixel = (float[])obj;
            }
            switch (this.baseDataType) {
                case 0: {
                    int i;
                    Object[] b = (byte[])buffer;
                    for (i = 0; i < b.length; ++i) {
                        pixel[i] = b[i];
                    }
                    break;
                }
                case 2: {
                    int i;
                    Object[] b = (short[])buffer;
                    for (i = 0; i < b.length; ++i) {
                        pixel[i] = b[i];
                    }
                    break;
                }
                case 1: {
                    int i;
                    Object[] b = (short[])buffer;
                    for (i = 0; i < b.length; ++i) {
                        pixel[i] = Short.toUnsignedInt(b[i]);
                    }
                    break;
                }
                case 3: {
                    int i;
                    Object[] b = (int[])buffer;
                    for (i = 0; i < b.length; ++i) {
                        pixel[i] = b[i];
                    }
                    break;
                }
                case 4: {
                    Object[] b = (float[])buffer;
                    System.arraycopy(b, 0, pixel, 0, b.length);
                    break;
                }
                case 5: {
                    int i;
                    Object[] b = (double[])buffer;
                    for (i = 0; i < b.length; ++i) {
                        pixel[i] = b[i];
                    }
                    break;
                }
                default: {
                    throw new ClassCastException("Unsupported base array type.");
                }
            }
            try {
                for (int i = 0; i < this.toConverted.length; ++i) {
                    pixel[i] = (float)this.toConverted[i].transform((double)pixel[i]);
                }
            }
            catch (TransformException ex) {
                Arrays.fill(pixel, Float.NaN);
            }
            return pixel;
        }

        @Override
        public void setDataElements(int x, int y, Object obj, DataBuffer data) {
            Objects.requireNonNull(obj);
            if (!(obj instanceof float[])) {
                throw new ClassCastException("Unsupported array type, expecting a float array.");
            }
            float[] pixel = (float[])obj;
            try {
                for (int i = 0; i < this.toConverted.length; ++i) {
                    pixel[i] = (float)this.toPacked[i].transform((double)pixel[i]);
                }
            }
            catch (TransformException ex) {
                Arrays.fill(pixel, Float.NaN);
            }
            switch (this.baseDataType) {
                case 0: {
                    byte[] b = new byte[pixel.length];
                    for (int i = 0; i < b.length; ++i) {
                        b[i] = (byte)pixel[i];
                    }
                    this.base.setDataElements(x, y, b, data);
                    break;
                }
                case 2: {
                    short[] b = new short[pixel.length];
                    for (int i = 0; i < b.length; ++i) {
                        b[i] = (short)pixel[i];
                    }
                    this.base.setDataElements(x, y, b, data);
                    break;
                }
                case 1: {
                    short[] b = new short[pixel.length];
                    for (int i = 0; i < b.length; ++i) {
                        b[i] = (short)pixel[i];
                    }
                    this.base.setDataElements(x, y, b, data);
                    break;
                }
                case 3: {
                    int[] b = new int[pixel.length];
                    for (int i = 0; i < b.length; ++i) {
                        b[i] = (int)pixel[i];
                    }
                    this.base.setDataElements(x, y, b, data);
                    break;
                }
                case 4: {
                    this.base.setDataElements(x, y, pixel, data);
                    break;
                }
                case 5: {
                    double[] b = new double[pixel.length];
                    for (int i = 0; i < b.length; ++i) {
                        b[i] = pixel[i];
                    }
                    this.base.setDataElements(x, y, b, data);
                    break;
                }
                default: {
                    throw new ClassCastException("Unsupported base array type.");
                }
            }
        }

        @Override
        public int getSample(int x, int y, int b, DataBuffer data) {
            return (int)this.getSampleDouble(x, y, b, data);
        }

        @Override
        public float getSampleFloat(int x, int y, int b, DataBuffer data) {
            try {
                return (float)this.toConverted[b].transform((double)this.base.getSampleFloat(x, y, b, data));
            }
            catch (TransformException ex) {
                return Float.NaN;
            }
        }

        @Override
        public double getSampleDouble(int x, int y, int b, DataBuffer data) {
            try {
                return this.toConverted[b].transform(this.base.getSampleDouble(x, y, b, data));
            }
            catch (TransformException ex) {
                return Double.NaN;
            }
        }

        @Override
        public void setSample(int x, int y, int b, int s, DataBuffer data) {
            this.setSample(x, y, b, (double)s, data);
        }

        @Override
        public void setSample(int x, int y, int b, double s, DataBuffer data) {
            try {
                s = this.toPacked[b].transform(s);
            }
            catch (TransformException ex) {
                s = Double.NaN;
            }
            this.base.setSample(x, y, b, s, data);
        }

        @Override
        public void setSample(int x, int y, int b, float s, DataBuffer data) {
            this.setSample(x, y, b, (double)s, data);
        }

        @Override
        public SampleModel createCompatibleSampleModel(int w, int h) {
            SampleModel cp = this.base.createCompatibleSampleModel(w, h);
            return new SampleConverter(cp, this.toConverted, this.toPacked);
        }

        @Override
        public SampleModel createSubsetSampleModel(int[] bands) {
            SampleModel cp = this.base.createSubsetSampleModel(bands);
            MathTransform1D[] trs = new MathTransform1D[bands.length];
            MathTransform1D[] ivtrs = new MathTransform1D[bands.length];
            for (int i = 0; i < bands.length; ++i) {
                trs[i] = this.toConverted[bands[i]];
                ivtrs[i] = this.toPacked[bands[i]];
            }
            return new SampleConverter(cp, trs, ivtrs);
        }

        @Override
        public DataBuffer createDataBuffer() {
            return this.base.createDataBuffer();
        }

        @Override
        public int[] getSampleSize() {
            int[] sizes = new int[this.numBands];
            Arrays.fill(sizes, 32);
            return sizes;
        }

        @Override
        public int getSampleSize(int band) {
            return 32;
        }
    }
}

