/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.nio.Buffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Optional;
import org.apache.sis.image.PixelIterator;
import org.apache.sis.image.SequenceType;
import org.apache.sis.image.TransferType;
import org.apache.sis.image.WritablePixelIterator;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

class DefaultIterator
extends WritablePixelIterator {
    int tileX;
    int tileY;
    int x;
    int y;
    int currentLowerX;
    int currentUpperX;
    int currentUpperY;

    DefaultIterator(Raster input, WritableRaster output, Rectangle subArea, Dimension window) {
        super(input, output, subArea, window);
        this.currentLowerX = this.lowerX;
        this.currentUpperX = this.upperX;
        this.currentUpperY = this.upperY;
        this.x = Math.decrementExact(this.lowerX);
        this.y = this.lowerY;
    }

    DefaultIterator(RenderedImage input, WritableRenderedImage output, Rectangle subArea, Dimension window) {
        super(input, output, subArea, window);
        this.tileX = Math.decrementExact(this.tileLowerX);
        this.tileY = this.tileLowerY;
        this.currentLowerX = this.lowerX;
        this.currentUpperX = this.lowerX;
        this.currentUpperY = this.lowerY;
        this.x = Math.decrementExact(this.lowerX);
        this.y = this.lowerY;
        if (this.tileUpperY == Integer.MAX_VALUE) {
            throw new ArithmeticException(Errors.format((short)188, 32));
        }
    }

    @Override
    public void rewind() {
        this.close();
        if (this.image == null) {
            this.tileX = 0;
            this.tileY = 0;
            this.currentUpperX = this.upperX;
            this.currentUpperY = this.upperY;
        } else {
            this.tileX = this.tileLowerX - 1;
            this.tileY = this.tileLowerY;
            this.currentUpperX = this.lowerX;
            this.currentUpperY = this.lowerY;
        }
        this.currentLowerX = this.lowerX;
        this.x = this.lowerX - 1;
        this.y = this.lowerY;
    }

    @Override
    public Optional<SequenceType> getIterationOrder() {
        if (this.image == null || this.tileUpperX - this.tileLowerX <= 1 && this.tileUpperY - this.tileLowerY <= 1) {
            return Optional.of(SequenceType.LINEAR);
        }
        return Optional.empty();
    }

    @Override
    public Point getPosition() {
        int message;
        if (this.x < this.lowerX) {
            message = 37;
        } else if (this.tileY >= this.tileUpperY) {
            message = 36;
        } else {
            return new Point(this.x, this.y);
        }
        throw new IllegalStateException(Resources.format((short)message));
    }

    @Override
    public void moveTo(int px, int py) {
        if (px < this.lowerX || px >= this.upperX || py < this.lowerY || py >= this.upperY) {
            throw new IndexOutOfBoundsException(Resources.format((short)47, px, py));
        }
        if (this.image != null) {
            int tx = Math.floorDiv(px - this.tileGridXOffset, this.tileWidth);
            int ty = Math.floorDiv(py - this.tileGridYOffset, this.tileHeight);
            if (tx != this.tileX || ty != this.tileY) {
                this.close();
                this.tileX = tx;
                this.tileY = ty;
                if (this.fetchTile() > py || this.currentLowerX > px) {
                    throw new RasterFormatException(Resources.format((short)35, this.tileX, this.tileY));
                }
            }
        }
        this.x = px;
        this.y = py;
    }

    @Override
    public boolean next() {
        if (++this.x >= this.currentUpperX) {
            if (++this.y >= this.currentUpperY) {
                this.close();
                if (++this.tileX >= this.tileUpperX) {
                    if (++this.tileY >= this.tileUpperY) {
                        this.endOfIteration();
                        return false;
                    }
                    this.tileX = this.tileLowerX;
                }
                this.y = this.fetchTile();
            }
            this.x = this.currentLowerX;
        }
        return true;
    }

    final int fetchTile() {
        this.currentRaster = null;
        if (this.destination != null) {
            this.destRaster = this.destination.getWritableTile(this.tileX, this.tileY);
            if (this.destination == this.image) {
                this.currentRaster = this.destRaster;
            }
        }
        if (this.currentRaster == null) {
            this.currentRaster = this.image.getTile(this.tileX, this.tileY);
        }
        int minX = this.currentRaster.getMinX();
        int minY = this.currentRaster.getMinY();
        this.currentLowerX = Math.max(this.lowerX, minX);
        this.currentUpperX = Math.min(this.upperX, minX + this.tileWidth);
        this.currentUpperY = Math.min(this.upperY, minY + this.tileHeight);
        if (this.currentRaster.getNumBands() != this.numBands) {
            throw new RasterFormatException(Resources.format((short)35, this.tileX, this.tileY));
        }
        return Math.max(this.lowerY, minY);
    }

    final void endOfIteration() {
        boolean error = this.tileY > Math.max(this.tileUpperY, this.tileLowerY + 1);
        this.x = this.currentUpperX - 1;
        this.y = this.currentUpperY - 1;
        this.tileX = this.tileUpperX - 1;
        this.tileY = this.tileUpperY;
        if (error) {
            throw new IllegalStateException(Resources.format((short)36));
        }
    }

    @Override
    public int getSample(int band) {
        return this.currentRaster.getSample(this.x, this.y, band);
    }

    @Override
    public float getSampleFloat(int band) {
        return this.currentRaster.getSampleFloat(this.x, this.y, band);
    }

    @Override
    public double getSampleDouble(int band) {
        return this.currentRaster.getSampleDouble(this.x, this.y, band);
    }

    @Override
    public void setSample(int band, int value) {
        this.destRaster.setSample(this.x, this.y, band, value);
    }

    @Override
    public void setSample(int band, float value) {
        this.destRaster.setSample(this.x, this.y, band, value);
    }

    @Override
    public void setSample(int band, double value) {
        this.destRaster.setSample(this.x, this.y, band, value);
    }

    @Override
    public int[] getPixel(int[] dest) {
        return this.currentRaster.getPixel(this.x, this.y, dest);
    }

    @Override
    public float[] getPixel(float[] dest) {
        return this.currentRaster.getPixel(this.x, this.y, dest);
    }

    @Override
    public double[] getPixel(double[] dest) {
        return this.currentRaster.getPixel(this.x, this.y, dest);
    }

    @Override
    public void setPixel(int[] dest) {
        this.destRaster.setPixel(this.x, this.y, dest);
    }

    @Override
    public void setPixel(float[] dest) {
        this.destRaster.setPixel(this.x, this.y, dest);
    }

    @Override
    public void setPixel(double[] dest) {
        this.destRaster.setPixel(this.x, this.y, dest);
    }

    @Override
    public <T extends Buffer> PixelIterator.Window<T> createWindow(TransferType<T> type) {
        ArgumentChecks.ensureNonNull("type", type);
        int length = this.numBands * this.windowWidth * this.windowHeight;
        int transferLength = length - this.numBands * Math.min(this.windowWidth, this.windowHeight);
        switch (type.dataBufferType) {
            case 3: {
                return new IntWindow(new int[length], new int[transferLength]);
            }
            case 4: {
                return new FloatWindow(new float[length], new float[transferLength]);
            }
            case 5: {
                return new DoubleWindow(new double[length], new double[transferLength]);
            }
        }
        throw new AssertionError(type);
    }

    final void update(WindowBase<?> window, Object data) {
        boolean fullWidth;
        Raster raster = this.currentRaster;
        int subEndX = raster.getMinX() - this.x + raster.getWidth();
        int subEndY = raster.getMinY() - this.y + raster.getHeight();
        int subWidth = Math.min(this.windowWidth, subEndX);
        int subHeight = Math.min(this.windowHeight, subEndY);
        boolean bl = fullWidth = subWidth == this.windowWidth;
        if (fullWidth && subHeight == this.windowHeight) {
            Object transfer = window.getPixels(raster, this.x, this.y, subWidth, subHeight, true);
            if (transfer != data) {
                System.arraycopy(transfer, 0, data, 0, this.numBands * subWidth * subHeight);
            }
            return;
        }
        int destOffset = 0;
        int subX = 0;
        int subY = 0;
        int tileSubX = this.tileX;
        int tileSubY = this.tileY;
        int stride = this.windowWidth * this.numBands;
        int rewind = subEndX;
        while (true) {
            if (subWidth > 0 && subHeight > 0) {
                Object transfer = window.getPixels(raster, this.x + subX, this.y + subY, subWidth, subHeight, false);
                if (fullWidth) {
                    int fullLength = stride * subHeight;
                    System.arraycopy(transfer, 0, data, destOffset, fullLength);
                    destOffset += fullLength;
                } else {
                    int rowLength = this.numBands * subWidth;
                    int fullLength = rowLength * subHeight;
                    for (int srcOffset = 0; srcOffset < fullLength; srcOffset += rowLength) {
                        System.arraycopy(transfer, srcOffset, data, destOffset, rowLength);
                        destOffset += stride;
                    }
                }
            }
            if (subEndX < this.windowWidth) {
                subX = subEndX;
                subEndX += this.tileWidth;
                ++tileSubX;
            } else {
                if (subEndY >= this.windowHeight) {
                    return;
                }
                subY = subEndY;
                subEndY += this.tileHeight;
                ++tileSubY;
                tileSubX = this.tileX;
                subEndX = rewind;
                subX = 0;
            }
            raster = this.image.getTile(tileSubX, tileSubY);
            destOffset = (subY * this.windowWidth + subX) * this.numBands;
            subWidth = Math.min(this.windowWidth, subEndX) - subX;
            subHeight = Math.min(this.windowHeight, subEndY) - subY;
            fullWidth = subWidth == this.windowWidth;
        }
    }

    @Override
    public final void close() {
        if (this.destination != null && this.destRaster != null) {
            this.destRaster = null;
            this.destination.releaseWritableTile(this.tileX, this.tileY);
        }
    }

    private final class DoubleWindow
    extends WindowBase<DoubleBuffer> {
        private final double[] data;
        private final double[] transfer;

        DoubleWindow(double[] data, double[] transfer) {
            super(DoubleBuffer.wrap(data).asReadOnlyBuffer());
            this.data = data;
            this.transfer = transfer;
        }

        @Override
        Object getPixels(Raster raster, int subX, int subY, int subWidth, int subHeight, boolean direct) {
            return raster.getPixels(subX, subY, subWidth, subHeight, direct ? this.data : this.transfer);
        }

        @Override
        public void update() {
            ((DoubleBuffer)this.values).clear();
            DefaultIterator.this.update(this, this.data);
        }
    }

    private final class FloatWindow
    extends WindowBase<FloatBuffer> {
        private final float[] data;
        private final float[] transfer;

        FloatWindow(float[] data, float[] transfer) {
            super(FloatBuffer.wrap(data).asReadOnlyBuffer());
            this.data = data;
            this.transfer = transfer;
        }

        @Override
        Object getPixels(Raster raster, int subX, int subY, int subWidth, int subHeight, boolean direct) {
            return raster.getPixels(subX, subY, subWidth, subHeight, direct ? this.data : this.transfer);
        }

        @Override
        public void update() {
            ((FloatBuffer)this.values).clear();
            DefaultIterator.this.update(this, this.data);
        }
    }

    private final class IntWindow
    extends WindowBase<IntBuffer> {
        private final int[] data;
        private final int[] transfer;

        IntWindow(int[] data, int[] transfer) {
            super(IntBuffer.wrap(data).asReadOnlyBuffer());
            this.data = data;
            this.transfer = transfer;
        }

        @Override
        Object getPixels(Raster raster, int subX, int subY, int subWidth, int subHeight, boolean direct) {
            return raster.getPixels(subX, subY, subWidth, subHeight, direct ? this.data : this.transfer);
        }

        @Override
        public void update() {
            ((IntBuffer)this.values).clear();
            DefaultIterator.this.update(this, this.data);
        }
    }

    private static abstract class WindowBase<T extends Buffer>
    extends PixelIterator.Window<T> {
        WindowBase(T buffer) {
            super(buffer);
        }

        abstract Object getPixels(Raster var1, int var2, int var3, int var4, int var5, boolean var6);
    }
}

