/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Objects;
import org.apache.sis.geometry.AbstractDirectPosition;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeneralDirectPosition
extends AbstractDirectPosition
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -1775358214919832302L;
    private static volatile Field coordinatesField;
    public final double[] coordinates;
    @Deprecated
    public transient double[] ordinates;
    private CoordinateReferenceSystem crs;

    public GeneralDirectPosition(CoordinateReferenceSystem crs) {
        this(crs.getCoordinateSystem().getDimension());
        this.crs = crs;
    }

    public GeneralDirectPosition(int dimension) throws NegativeArraySizeException {
        this.coordinates = new double[dimension];
        this.ordinates = this.coordinates;
    }

    public GeneralDirectPosition(double ... coordinates) {
        this.coordinates = coordinates;
        this.ordinates = coordinates;
    }

    public GeneralDirectPosition(DirectPosition point) {
        this.coordinates = point.getCoordinate();
        this.crs = point.getCoordinateReferenceSystem();
        ArgumentChecks.ensureDimensionMatches("crs", this.coordinates.length, this.crs);
        this.ordinates = this.coordinates;
    }

    public GeneralDirectPosition(CharSequence wkt) throws IllegalArgumentException {
        this.coordinates = GeneralDirectPosition.parse(wkt);
        if (this.coordinates == null) {
            throw new IllegalArgumentException(Errors.format((short)154, "POINT", wkt));
        }
        this.ordinates = this.coordinates;
    }

    public final int getDimension() {
        return this.coordinates.length;
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        ArgumentChecks.ensureDimensionMatches("crs", this.getDimension(), crs);
        this.crs = crs;
    }

    @Override
    public final double[] getCoordinate() {
        return (double[])this.coordinates.clone();
    }

    public void setCoordinate(double ... coordinates) throws MismatchedDimensionException {
        if (coordinates == null) {
            Arrays.fill(this.coordinates, Double.NaN);
        } else {
            ArgumentChecks.ensureDimensionMatches("coordinates", this.coordinates.length, coordinates);
            System.arraycopy(coordinates, 0, this.coordinates, 0, coordinates.length);
        }
    }

    public final double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        return this.coordinates[dimension];
    }

    public void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
        this.coordinates[dimension] = value;
    }

    @Override
    public void setLocation(DirectPosition position) throws MismatchedDimensionException {
        if (position == null) {
            Arrays.fill(this.coordinates, Double.NaN);
        } else {
            ArgumentChecks.ensureDimensionMatches("position", this.coordinates.length, position);
            this.setCoordinateReferenceSystem(position.getCoordinateReferenceSystem());
            for (int i = 0; i < this.coordinates.length; ++i) {
                this.coordinates[i] = position.getOrdinate(i);
            }
        }
    }

    @Override
    public String toString() {
        return GeneralDirectPosition.toString(this, ArraysExt.isSinglePrecision(this.coordinates));
    }

    static Field getCoordinatesField(Class<?> type) throws NoSuchFieldException {
        Field field = type.getDeclaredField("coordinates");
        AccessController.doPrivileged(() -> {
            field.setAccessible(true);
            return null;
        });
        return field;
    }

    public GeneralDirectPosition clone() {
        try {
            Field field = coordinatesField;
            if (field == null) {
                coordinatesField = field = GeneralDirectPosition.getCoordinatesField(GeneralDirectPosition.class);
            }
            GeneralDirectPosition e = (GeneralDirectPosition)super.clone();
            field.set(e, this.coordinates.clone());
            e.ordinates = e.coordinates;
            return e;
        }
        catch (CloneNotSupportedException | ReflectiveOperationException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.ordinates = this.coordinates;
    }

    @Override
    public int hashCode() {
        int code = Arrays.hashCode(this.coordinates) + Objects.hashCode(this.getCoordinateReferenceSystem());
        assert (code == super.hashCode());
        return code;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof GeneralDirectPosition) {
            GeneralDirectPosition that = (GeneralDirectPosition)object;
            return Arrays.equals(this.coordinates, that.coordinates) && Objects.equals(this.crs, that.crs);
        }
        return super.equals(object);
    }
}

