/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.referencing.CRS;
import org.apache.sis.util.Utilities;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

class EnvelopeReducer {
    static final EnvelopeReducer UNION = new EnvelopeReducer("union");
    static final EnvelopeReducer INTERSECT = new EnvelopeReducer("intersect"){

        @Override
        void reduce(GeneralEnvelope result, Envelope other) {
            result.intersect(other);
        }

        @Override
        void reduce(DefaultGeographicBoundingBox result, GeographicBoundingBox other) {
            result.intersect(other);
        }
    };
    private final String caller;

    EnvelopeReducer(String caller) {
        this.caller = caller;
    }

    void reduce(GeneralEnvelope result, Envelope other) {
        result.add(other);
    }

    void reduce(DefaultGeographicBoundingBox result, GeographicBoundingBox other) {
        result.add(other);
    }

    final GeneralEnvelope reduce(Envelope[] envelopes) throws TransformException {
        GeneralEnvelope[] reduced = new GeneralEnvelope[envelopes.length];
        int count = 0;
        block4: for (Envelope envelope : envelopes) {
            if (envelope == null) continue;
            CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
            for (int i = 0; i < count; ++i) {
                GeneralEnvelope previous = reduced[i];
                if (!Utilities.equalsIgnoreMetadata(crs, previous.getCoordinateReferenceSystem())) continue;
                this.reduce(previous, envelope);
                continue block4;
            }
            reduced[count++] = new GeneralEnvelope(envelope);
        }
        switch (count) {
            case 0: {
                return null;
            }
            case 1: {
                return reduced[0];
            }
        }
        ReferencingServices converter = ReferencingServices.getInstance();
        CoordinateReferenceSystem[] crs = new CoordinateReferenceSystem[count];
        DefaultGeographicBoundingBox more = new DefaultGeographicBoundingBox();
        DefaultGeographicBoundingBox bbox = null;
        for (int i = 0; i < count; ++i) {
            GeneralEnvelope e = reduced[i];
            crs[i] = e.getCoordinateReferenceSystem();
            if (converter.setBounds(e, more, this.caller) == null) continue;
            if (bbox == null) {
                bbox = more;
                more = new DefaultGeographicBoundingBox();
                continue;
            }
            this.reduce(bbox, more);
        }
        CoordinateReferenceSystem target = CRS.suggestCommonTarget(bbox, crs);
        if (target == null) {
            throw new TransformException(Resources.format((short)82));
        }
        GeneralEnvelope result = null;
        for (int i = 0; i < count; ++i) {
            Envelope other = Envelopes.transform(reduced[i], target);
            if (result == null) {
                result = GeneralEnvelope.castOrCopy(other);
                continue;
            }
            this.reduce(result, other);
        }
        return result;
    }
}

