/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collection;
import java.util.Collections;
import org.apache.sis.feature.AbstractAssociation;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FeatureType;
import org.apache.sis.metadata.iso.quality.AbstractElement;
import org.apache.sis.metadata.iso.quality.DefaultConformanceResult;
import org.apache.sis.metadata.iso.quality.DefaultDataQuality;
import org.apache.sis.metadata.iso.quality.DefaultDomainConsistency;
import org.apache.sis.metadata.iso.quality.DefaultScope;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

final class Validator {
    final DefaultDataQuality quality = new DefaultDataQuality();

    Validator(ScopeCode scope) {
        if (scope != null) {
            this.quality.setScope(new DefaultScope(scope));
        }
    }

    private AbstractElement addViolationReport(AbstractElement report, AbstractIdentifiedType type, InternationalString explanation) {
        if (report == null) {
            GenericName name = type.getName();
            report = new DefaultDomainConsistency();
            report.setMeasureIdentification((Identifier)(name instanceof Identifier ? (Identifier)name : new NamedIdentifier(name)));
            report.setEvaluationMethodType(EvaluationMethodType.DIRECT_INTERNAL);
            this.quality.getReports().add(report);
        }
        report.getResults().add(new DefaultConformanceResult(null, (CharSequence)explanation, false));
        return report;
    }

    private static Collection<?> asList(Object value, int maximumOccurrences) {
        if (maximumOccurrences <= 1) {
            return value != null ? Collections.singletonList(value) : Collections.emptyList();
        }
        return (Collection)value;
    }

    void validate(FeatureType type, AbstractFeature feature) {
        for (AbstractIdentifiedType pt : type.getProperties(true)) {
            DataQuality pq;
            Object property = feature.getProperty(pt.getName().toString());
            if (property instanceof AbstractAttribute) {
                pq = ((AbstractAttribute)property).quality();
            } else if (property instanceof AbstractAssociation) {
                pq = ((AbstractAssociation)property).quality();
            } else {
                if (property instanceof AbstractAttribute) {
                    this.validate(((AbstractAttribute)property).getType(), ((AbstractAttribute)property).getValues());
                    continue;
                }
                if (!(property instanceof AbstractAssociation)) continue;
                this.validate(((AbstractAssociation)property).getRole(), ((AbstractAssociation)property).getValues());
                continue;
            }
            if (pq == null) continue;
            this.quality.getReports().addAll(pq.getReports());
        }
    }

    void validateAny(AbstractIdentifiedType type, Object value) {
        if (type instanceof DefaultAttributeType) {
            this.validate((DefaultAttributeType)type, Validator.asList(value, ((DefaultAttributeType)type).getMaximumOccurs()));
        }
        if (type instanceof DefaultAssociationRole) {
            this.validate((DefaultAssociationRole)type, Validator.asList(value, ((DefaultAssociationRole)type).getMaximumOccurs()));
        }
    }

    void validate(DefaultAttributeType<?> type, Collection<?> values) {
        AbstractElement report = null;
        for (Object value : values) {
            Class<?> valueClass = type.getValueClass();
            if (valueClass.isInstance(value)) continue;
            report = this.addViolationReport(report, type, Errors.formatInternational((short)59, type.getName(), valueClass, value.getClass()));
            break;
        }
        this.verifyCardinality(report, type, type.getMinimumOccurs(), type.getMaximumOccurs(), values.size());
    }

    void validate(DefaultAssociationRole role, Collection<?> values) {
        AbstractElement report = null;
        for (Object value : values) {
            DefaultFeatureType type = ((AbstractFeature)value).getType();
            DefaultFeatureType valueType = role.getValueType();
            if (valueType.isAssignableFrom(type)) continue;
            report = this.addViolationReport(report, role, Errors.formatInternational((short)59, role.getName(), valueType.getName(), type.getName()));
            break;
        }
        this.verifyCardinality(report, role, role.getMinimumOccurs(), role.getMaximumOccurs(), values.size());
    }

    private void verifyCardinality(AbstractElement report, AbstractIdentifiedType type, int minimumOccurs, int maximumOccurs, int count) {
        if (count < minimumOccurs) {
            InternationalString message = count == 0 ? Errors.formatInternational((short)89, (Object)type.getName()) : Errors.formatInternational((short)128, minimumOccurs, type.getName());
            this.addViolationReport(report, type, message);
        } else if (count > maximumOccurs) {
            InternationalString message = maximumOccurs == 0 ? Errors.formatInternational((short)41, (Object)type.getName()) : Errors.formatInternational((short)130, maximumOccurs, type.getName());
            this.addViolationReport(report, type, message);
        }
    }
}

