/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.AssociationView;
import org.apache.sis.feature.AttributeView;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.FieldType;
import org.apache.sis.feature.Property;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;

final class PropertyView {
    private PropertyView() {
    }

    static Property create(AbstractFeature feature, AbstractIdentifiedType type) {
        if (type instanceof DefaultAttributeType) {
            return AttributeView.create(feature, (DefaultAttributeType)type);
        }
        if (type instanceof DefaultAssociationRole) {
            return AssociationView.create(feature, (DefaultAssociationRole)type);
        }
        if (type instanceof AbstractOperation) {
            return (Property)((AbstractOperation)type).apply(feature, null);
        }
        throw new IllegalArgumentException(Errors.format((short)149, Classes.getClass(type)));
    }

    static Object getValue(AbstractFeature feature, String name) {
        Object value = feature.getPropertyValue(name);
        if (value instanceof Iterable) {
            Iterator it = ((Iterable)value).iterator();
            if (!it.hasNext()) {
                return null;
            }
            value = it.next();
            if (it.hasNext()) {
                throw new IllegalStateException(Resources.format((short)14, name));
            }
        }
        return value;
    }

    static void setValue(AbstractFeature feature, String name, Object value) {
        feature.setPropertyValue(name, PropertyView.singletonOrEmpty(value));
    }

    static <V> List<V> singletonOrEmpty(V element) {
        return element != null ? Collections.singletonList(element) : Collections.emptyList();
    }

    static <V> Collection<V> getValues(AbstractFeature feature, String name, Class<V> expected) {
        Object values = feature.getPropertyValue(name);
        if (values instanceof Collection) {
            Class actual;
            if (values instanceof CheckedContainer && expected != (actual = ((CheckedContainer)values).getElementType())) {
                throw new ClassCastException(Errors.format((short)143, name, expected, actual));
            }
            return (Collection)values;
        }
        return PropertyView.singletonOrEmpty(expected.cast(values));
    }

    static void setValues(AbstractFeature feature, String name, Collection<?> values) {
        feature.setPropertyValue(name, values);
    }

    static int hashCode(AbstractFeature feature, String name) {
        return Objects.hashCode(name) ^ System.identityHashCode(feature);
    }

    static String toString(Class<?> classe, Class<?> valueClass, GenericName name, Collection<?> values) {
        return FieldType.toString(false, classe.getSimpleName(), name, Classes.getShortName(valueClass), values.iterator()).toString();
    }
}

