/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.distance;

import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.measure.Longitude;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.GeodeticCalculator;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Deprecated
public class LatLonPointRadius {
    private final DirectPosition center;
    private final double radius;

    public LatLonPointRadius(DirectPosition center, double radius) {
        this.center = center;
        this.radius = radius;
    }

    public DirectPosition2D[] getCircularRegionApproximation(int numberOfPoints) {
        if (this.radius >= 20037.58) {
            DirectPosition2D[] points;
            points = new DirectPosition2D[]{new DirectPosition2D(-180.0, -90.0), new DirectPosition2D(-180.0, 90.0), new DirectPosition2D(180.0, 90.0), new DirectPosition2D(180.0, -90.0), points[0]};
            return points;
        }
        DirectPosition2D[] points = new DirectPosition2D[numberOfPoints + 1];
        double bearingIncrement = 0.0;
        if (numberOfPoints > 0) {
            bearingIncrement = 360 / numberOfPoints;
        }
        GeodeticCalculator calculator = GeodeticCalculator.create((CoordinateReferenceSystem)CommonCRS.SPHERE.geographic());
        calculator.setStartGeographicPoint(this.center.getOrdinate(1), this.center.getOrdinate(0));
        calculator.setGeodesicDistance(this.radius);
        for (int i = 0; i < numberOfPoints; ++i) {
            calculator.setStartingAzimuth((double)i * bearingIncrement);
            DirectPosition p = calculator.getEndPoint();
            points[i] = new DirectPosition2D(p.getOrdinate(1), p.getOrdinate(0));
        }
        points[numberOfPoints] = points[0];
        return points;
    }

    public Rectangle2D getRectangularRegionApproximation(int numberOfPoints) {
        if (this.radius >= 20037.58) {
            return new Rectangle2D.Double(0.0, 0.0, 360.0, 180.0);
        }
        int numberOfCrossOvers = 0;
        GeodeticCalculator calculator = GeodeticCalculator.create((CoordinateReferenceSystem)CommonCRS.SPHERE.geographic());
        calculator.setStartGeographicPoint(this.center.getOrdinate(1), this.center.getOrdinate(0));
        Path2D.Double path = new Path2D.Double();
        double initX = Double.NaN;
        double previousX = Double.NaN;
        calculator.setGeodesicDistance(this.radius);
        for (int i = 0; i < 360; ++i) {
            calculator.setStartingAzimuth(i);
            DirectPosition pt = calculator.getEndPoint();
            double x = pt.getOrdinate(1) + 180.0;
            double y = pt.getOrdinate(0) + 90.0;
            if (i == 0) {
                initX = Longitude.normalize(x);
                ((Path2D)path).moveTo(x, y);
                continue;
            }
            ((Path2D)path).lineTo(x, y);
            double d = previousX;
            previousX = Longitude.normalize(x);
            if (!LatLonPointRadius.dateLineCrossOver(d, previousX)) continue;
            ++numberOfCrossOvers;
        }
        if (LatLonPointRadius.dateLineCrossOver(previousX, initX)) {
            ++numberOfCrossOvers;
        }
        if (numberOfCrossOvers == 1) {
            Rectangle2D r = path.getBounds2D();
            Rectangle2D.Double lowerHalf = new Rectangle2D.Double(0.0, 0.0, 360.0, r.getMaxY());
            if (lowerHalf.contains(this.center.getOrdinate(0) + 180.0, this.center.getOrdinate(1) + 90.0)) {
                return lowerHalf;
            }
            return new Rectangle2D.Double(0.0, r.getMinY(), 360.0, 180.0 - r.getMinY());
        }
        if (path.contains(this.center.getOrdinate(0) + 180.0, this.center.getOrdinate(1) + 90.0)) {
            Rectangle2D r = path.getBounds2D();
            if (r.getMaxX() - r.getMinX() > 359.0) {
                return new Rectangle2D.Double(0.0, 0.0, 360.0, 180.0);
            }
            if (r.getMinX() < 0.0 || r.getMaxX() > 360.0) {
                return new Rectangle2D.Double(0.0, r.getY(), 360.0, r.getHeight());
            }
            return path.getBounds2D();
        }
        Area pathArea = new Area(path);
        Area wholeMap = new Area(new Rectangle2D.Double(0.0, 0.0, 360.0, 180.0));
        wholeMap.subtract(pathArea);
        return wholeMap.getBounds2D();
    }

    private static boolean dateLineCrossOver(double longitude1, double longitude2) {
        return Math.abs(longitude1 - longitude2) > 180.0;
    }
}

