/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.nio.Buffer;
import java.util.Arrays;
import org.apache.sis.coverage.MismatchedCoverageRangeException;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.internal.coverage.ColorModelFactory;
import org.apache.sis.internal.coverage.RasterFactory;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.math.Vector;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.MismatchedDimensionException;

public class ImageRenderer {
    private final long offsetX;
    private final long offsetY;
    private final int imageX;
    private final int imageY;
    private final int width;
    private final int height;
    private final int pixelStride;
    private final int scanlineStride;
    private int strideFactor;
    private final SampleDimension[] bands;
    private int[] bandOffsets;
    private int[] bankIndices;
    private int visibleBand;
    private DataBuffer buffer;

    public ImageRenderer(GridCoverage coverage, GridExtent sliceExtent) {
        ArgumentChecks.ensureNonNull("coverage", coverage);
        this.bands = CollectionsExt.toArray(coverage.getSampleDimensions(), SampleDimension.class);
        GridExtent source = coverage.getGridGeometry().getExtent();
        if (sliceExtent != null) {
            int dimension = sliceExtent.getDimension();
            if (source.getDimension() != dimension) {
                throw new MismatchedDimensionException(Errors.format((short)81, "target", source.getDimension(), dimension));
            }
        } else {
            sliceExtent = source;
        }
        int[] dimensions = sliceExtent.getSubspaceDimensions(2);
        int xd = dimensions[0];
        int yd = dimensions[1];
        long xcov = source.getLow(xd);
        long ycov = source.getLow(yd);
        long xreq = sliceExtent.getLow(xd);
        long yreq = sliceExtent.getLow(yd);
        long xmin = Math.max(xreq, xcov);
        long ymin = Math.max(yreq, ycov);
        long xmax = Math.min(sliceExtent.getHigh(xd), source.getHigh(xd));
        long ymax = Math.min(sliceExtent.getHigh(yd), source.getHigh(yd));
        if (xmax < xmin || ymax < ymin) {
            int d = xmax < xmin ? xd : yd;
            throw new DisjointExtentException(source.getAxisIdentification(d, d), source.getLow(d), source.getHigh(d), sliceExtent.getLow(d), sliceExtent.getHigh(d));
        }
        this.width = Math.incrementExact(Math.toIntExact(xmax - xmin));
        this.height = Math.incrementExact(Math.toIntExact(ymax - ymin));
        this.imageX = Math.toIntExact(Math.subtractExact(xreq, xmin));
        this.imageY = Math.toIntExact(Math.subtractExact(yreq, ymin));
        this.offsetX = Math.subtractExact(xmin, xcov);
        this.offsetY = Math.subtractExact(ymin, ycov);
        long pixelStride = 1L;
        for (int i = 0; i < xd; ++i) {
            pixelStride = Math.multiplyExact(pixelStride, source.getSize(i));
        }
        long scanlineStride = pixelStride;
        for (int i = xd; i < yd; ++i) {
            scanlineStride = Math.multiplyExact(scanlineStride, source.getSize(i));
        }
        this.pixelStride = Math.toIntExact(pixelStride);
        this.scanlineStride = Math.toIntExact(scanlineStride);
    }

    public final int getNumBands() {
        return this.bands.length;
    }

    private void ensureExpectedBandCount(int n, boolean acceptOne) {
        int e;
        if (!(n == 1 & acceptOne) && n != (e = this.getNumBands())) {
            throw new MismatchedCoverageRangeException(Resources.format((short)49, e, n));
        }
    }

    public final Rectangle getBounds() {
        return new Rectangle(this.imageX, this.imageY, this.width, this.height);
    }

    public void setData(DataBuffer data) {
        ArgumentChecks.ensureNonNull("data", data);
        this.ensureExpectedBandCount(data.getNumBanks(), true);
        this.buffer = data;
    }

    public void setData(int dataType, Buffer ... data) {
        ArgumentChecks.ensureNonNull("data", data);
        this.ensureExpectedBandCount(data.length, true);
        DataBuffer banks = RasterFactory.wrap(dataType, data);
        if (banks == null) {
            throw new IllegalArgumentException(Resources.format((short)50, dataType));
        }
        this.setData(banks);
    }

    public void setData(Vector ... data) {
        ArgumentChecks.ensureNonNull("data", data);
        this.ensureExpectedBandCount(data.length, true);
        Buffer[] buffers = new Buffer[data.length];
        int dataType = 32;
        for (int i = 0; i < data.length; ++i) {
            Vector v = data[i];
            ArgumentChecks.ensureNonNullElement("data", i, v);
            int t = RasterFactory.getType(v.getElementType(), v.isUnsigned());
            if (dataType != t) {
                if (i != 0) {
                    throw new RasterFormatException(Resources.format((short)39));
                }
                dataType = t;
            }
            buffers[i] = v.buffer().orElseThrow(UnsupportedOperationException::new);
        }
        this.setData(dataType, buffers);
    }

    public void setInterleavedPixelOffsets(int pixelStride, int[] bandOffsets) {
        ArgumentChecks.ensureStrictlyPositive("pixelStride", pixelStride);
        ArgumentChecks.ensureNonNull("bandOffsets", bandOffsets);
        this.ensureExpectedBandCount(bandOffsets.length, false);
        this.strideFactor = pixelStride;
        this.bandOffsets = (int[])bandOffsets.clone();
    }

    public WritableRaster raster() {
        int i;
        boolean isInterleaved;
        if (this.buffer == null) {
            throw new IllegalStateException(Resources.format((short)53));
        }
        boolean bl = isInterleaved = this.buffer.getNumBanks() == 1;
        if (this.bandOffsets == null) {
            this.strideFactor = isInterleaved ? this.getNumBands() : 1;
        }
        int ls = Math.multiplyExact(this.scanlineStride, this.strideFactor);
        int ps = this.pixelStride * this.strideFactor;
        int[] offsets = new int[this.getNumBands()];
        Arrays.fill(offsets, Math.toIntExact(Math.addExact(Math.multiplyExact(this.offsetX, ps), Math.multiplyExact(this.offsetY, ls))));
        if (this.bandOffsets != null) {
            for (i = 0; i < offsets.length; ++i) {
                offsets[i] = Math.addExact(offsets[i], this.bandOffsets[i]);
            }
        } else if (isInterleaved) {
            for (i = 1; i < offsets.length; ++i) {
                offsets[i] = Math.addExact(offsets[i], i);
            }
        }
        Point location = new Point(this.imageX, this.imageY);
        return RasterFactory.createRaster(this.buffer, this.width, this.height, ps, ls, this.bankIndices, offsets, location);
    }

    public RenderedImage image() {
        WritableRaster raster = this.raster();
        ColorModel colors = ColorModelFactory.createColorModel(this.bands, this.visibleBand, this.buffer.getDataType(), ColorModelFactory.GRAYSCALE);
        return new BufferedImage(colors, raster, false, null);
    }
}

