/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.math.RoundingMode;
import java.text.Format;
import java.text.NumberFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.sis.coverage.grid.GridDerivation;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.coverage.grid.IncompleteGridGeometryException;
import org.apache.sis.coverage.grid.PixelTranslation;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.TemporalAccessor;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.TableAppender;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.apache.sis.xml.NilObject;
import org.apache.sis.xml.NilReason;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GridGeometry
implements Serializable {
    private static final long serialVersionUID = -954786616001606624L;
    public static final int CRS = 1;
    public static final int ENVELOPE = 2;
    public static final int EXTENT = 4;
    public static final int GRID_TO_CRS = 8;
    public static final int RESOLUTION = 16;
    public static final int GEOGRAPHIC_EXTENT = 32;
    public static final int TEMPORAL_EXTENT = 64;
    protected final GridExtent extent;
    protected final ImmutableEnvelope envelope;
    protected final MathTransform gridToCRS;
    private final MathTransform cornerToCRS;
    protected final double[] resolution;
    private final long nonLinears;
    private volatile transient GeographicBoundingBox geographicBBox;
    private volatile transient Instant[] timeRange;
    public static final GridGeometry UNDEFINED = new GridGeometry();

    private GridGeometry() {
        this.extent = null;
        this.gridToCRS = null;
        this.cornerToCRS = null;
        this.envelope = null;
        this.resolution = null;
        this.nonLinears = 0L;
    }

    protected GridGeometry(GridGeometry other) {
        this.extent = other.extent;
        this.gridToCRS = other.gridToCRS;
        this.cornerToCRS = other.cornerToCRS;
        this.envelope = other.envelope;
        this.resolution = other.resolution;
        this.nonLinears = other.nonLinears;
    }

    GridGeometry(GridGeometry other, GridExtent extent, MathTransform toOther) throws TransformException {
        int dimension = other.getDimension();
        this.extent = extent;
        GridGeometry.ensureDimensionMatches(dimension, extent);
        if (toOther == null || toOther.isIdentity()) {
            this.gridToCRS = other.gridToCRS;
            this.cornerToCRS = other.cornerToCRS;
            this.resolution = other.resolution;
            this.nonLinears = other.nonLinears;
        } else {
            MathTransform centerShift = MathTransforms.concatenate(MathTransforms.uniformTranslation(dimension, 0.5), toOther, MathTransforms.uniformTranslation(dimension, -0.5));
            this.cornerToCRS = MathTransforms.concatenate(toOther, other.cornerToCRS);
            this.gridToCRS = MathTransforms.concatenate(centerShift, other.gridToCRS);
            this.resolution = GridGeometry.resolution(this.gridToCRS, extent);
            this.nonLinears = GridGeometry.findNonLinearTargets(this.gridToCRS);
        }
        ImmutableEnvelope envelope = other.envelope;
        ImmutableEnvelope computed = this.computeEnvelope(this.gridToCRS, GridGeometry.getCoordinateReferenceSystem(envelope), envelope);
        if (computed == null || !computed.equals(envelope)) {
            envelope = computed;
        }
        this.envelope = envelope;
        if (envelope == null && this.gridToCRS == null) {
            ArgumentChecks.ensureNonNull("extent", extent);
        }
    }

    public GridGeometry(GridExtent extent, PixelInCell anchor, MathTransform gridToCRS, CoordinateReferenceSystem crs) {
        if (gridToCRS != null) {
            GridGeometry.ensureDimensionMatches(gridToCRS.getSourceDimensions(), extent);
            ArgumentChecks.ensureDimensionMatches("crs", gridToCRS.getTargetDimensions(), crs);
        } else if (crs == null) {
            ArgumentChecks.ensureNonNull("extent", extent);
        }
        try {
            this.extent = extent;
            this.gridToCRS = PixelTranslation.translate(gridToCRS, anchor, PixelInCell.CELL_CENTER);
            this.cornerToCRS = PixelTranslation.translate(gridToCRS, anchor, PixelInCell.CELL_CORNER);
            this.envelope = this.computeEnvelope(gridToCRS, crs, null);
            this.resolution = GridGeometry.resolution(gridToCRS, extent);
            this.nonLinears = GridGeometry.findNonLinearTargets(gridToCRS);
        }
        catch (TransformException e) {
            throw new IllegalGridGeometryException(e, "gridToCRS");
        }
    }

    private ImmutableEnvelope computeEnvelope(MathTransform specified, CoordinateReferenceSystem crs, Envelope limits) throws TransformException {
        GeneralEnvelope env;
        if (this.extent != null && this.cornerToCRS != null) {
            env = this.extent.toCRS(this.cornerToCRS, specified, limits);
            env.setCoordinateReferenceSystem(crs);
            if (limits != null) {
                env.intersect(limits);
            }
        } else if (crs != null) {
            env = new GeneralEnvelope(crs);
            env.setToNaN();
        } else {
            return null;
        }
        return new ImmutableEnvelope(env);
    }

    public GridGeometry(PixelInCell anchor, MathTransform gridToCRS, Envelope envelope, GridRoundingMode rounding) {
        if (gridToCRS == null) {
            ArgumentChecks.ensureNonNull("envelope", envelope);
        } else {
            ArgumentChecks.ensureDimensionMatches("envelope", gridToCRS.getTargetDimensions(), envelope);
        }
        ArgumentChecks.ensureNonNull("rounding", (Object)rounding);
        this.gridToCRS = PixelTranslation.translate(gridToCRS, anchor, PixelInCell.CELL_CENTER);
        this.cornerToCRS = PixelTranslation.translate(gridToCRS, anchor, PixelInCell.CELL_CORNER);
        Matrix scales = MathTransforms.getMatrix(gridToCRS);
        int numToIgnore = 1;
        if (envelope != null && this.cornerToCRS != null) {
            GeneralEnvelope env;
            try {
                env = Envelopes.transform(this.cornerToCRS.inverse(), envelope);
                this.extent = new GridExtent(env, rounding, null, null, null);
                env = this.extent.toCRS(this.cornerToCRS, gridToCRS, envelope);
            }
            catch (TransformException e) {
                throw new IllegalGridGeometryException(e, "gridToCRS");
            }
            env.setCoordinateReferenceSystem(envelope.getCoordinateReferenceSystem());
            this.envelope = new ImmutableEnvelope(env);
            if (scales == null) {
                try {
                    scales = gridToCRS.derivative((DirectPosition)new DirectPositionView.Double(this.extent.getPointOfInterest()));
                    numToIgnore = 0;
                }
                catch (TransformException e) {
                    GridGeometry.recoverableException((Exception)((Object)e));
                }
            }
        } else {
            this.extent = null;
            this.envelope = ImmutableEnvelope.castOrCopy(envelope);
        }
        this.resolution = scales != null ? GridGeometry.resolution(scales, numToIgnore) : null;
        this.nonLinears = GridGeometry.findNonLinearTargets(gridToCRS);
    }

    private static void ensureDimensionMatches(int expected, GridExtent extent) throws MismatchedDimensionException {
        int dimension;
        if (extent != null && (dimension = extent.getDimension()) != expected) {
            throw new MismatchedDimensionException(Errors.format((short)81, "extent", expected, dimension));
        }
    }

    static void recoverableException(Exception exception) {
        Logging.recoverableException(Logging.getLogger("org.apache.sis.raster"), GridGeometry.class, "<init>", exception);
    }

    public GridGeometry(GridExtent extent, Envelope envelope) {
        this.extent = extent;
        this.nonLinears = 0L;
        boolean nilEnvelope = true;
        ImmutableEnvelope env = ImmutableEnvelope.castOrCopy(envelope);
        if (env == null || (nilEnvelope = env.isAllNaN()) && env.getCoordinateReferenceSystem() == null) {
            ArgumentChecks.ensureNonNull("extent", extent);
            this.envelope = null;
        } else {
            this.envelope = env;
            if (extent != null && !nilEnvelope) {
                MatrixSIS affine = extent.cornerToCRS(env);
                this.cornerToCRS = MathTransforms.linear(affine);
                int srcDim = this.cornerToCRS.getSourceDimensions();
                int tgtDim = this.cornerToCRS.getTargetDimensions();
                this.resolution = new double[tgtDim];
                for (int j = 0; j < tgtDim; ++j) {
                    DoubleDouble scale = (DoubleDouble)affine.getNumber(j, j);
                    DoubleDouble offset = (DoubleDouble)affine.getNumber(j, srcDim);
                    this.resolution[j] = scale.doubleValue();
                    scale.multiply(0.5);
                    offset.add(scale);
                    affine.setNumber(j, srcDim, offset);
                }
                this.gridToCRS = MathTransforms.linear(affine);
                return;
            }
        }
        this.gridToCRS = null;
        this.cornerToCRS = null;
        this.resolution = null;
    }

    private GridGeometry(GridGeometry other, int[] dimensions) throws FactoryException {
        int j;
        int i;
        ImmutableEnvelope env;
        this.extent = other.extent != null ? other.extent.reduce(dimensions) : null;
        int n = dimensions.length;
        if (other.gridToCRS != null) {
            int[] sources = dimensions;
            TransformSeparator sep = new TransformSeparator(other.gridToCRS);
            sep.addSourceDimensions(sources);
            this.gridToCRS = sep.separate();
            dimensions = sep.getTargetDimensions();
            assert (dimensions.length == n) : Arrays.toString(dimensions);
            if (!ArraysExt.isSorted(dimensions, true)) {
                throw new IllegalGridGeometryException(Resources.format((short)33, "dimensions"));
            }
            sep = new TransformSeparator(other.cornerToCRS);
            sep.addSourceDimensions(sources);
            sep.addTargetDimensions(dimensions);
            this.cornerToCRS = sep.separate();
            assert (Arrays.equals(sep.getSourceDimensions(), dimensions)) : Arrays.toString(dimensions);
        } else {
            this.gridToCRS = null;
            this.cornerToCRS = null;
        }
        if ((env = other.envelope) != null) {
            CoordinateReferenceSystem crs = env.getCoordinateReferenceSystem();
            crs = org.apache.sis.referencing.CRS.reduce(crs, dimensions);
            double[] min = new double[n];
            double[] max = new double[n];
            for (i = 0; i < n; ++i) {
                j = dimensions[i];
                min[i] = env.getLower(j);
                max[i] = env.getUpper(j);
            }
            this.envelope = new ImmutableEnvelope(min, max, crs);
        } else {
            this.envelope = null;
        }
        long nonLinears = 0L;
        double[] resolution = other.resolution;
        if (resolution != null) {
            resolution = new double[n];
        }
        for (i = 0; i < n; ++i) {
            j = dimensions[i];
            if (resolution != null) {
                resolution[i] = other.resolution[j];
            }
            nonLinears |= (other.nonLinears >>> j & 1L) << i;
        }
        this.resolution = resolution;
        this.nonLinears = nonLinears;
    }

    public final int getDimension() {
        if (this.extent != null) {
            return this.extent.getDimension();
        }
        if (this.gridToCRS != null) {
            return this.gridToCRS.getSourceDimensions();
        }
        return this.envelope.getDimension();
    }

    private int getTargetDimension() {
        if (this.envelope != null) {
            return this.envelope.getDimension();
        }
        if (this.gridToCRS != null) {
            return this.gridToCRS.getTargetDimensions();
        }
        return this.extent.getDimension();
    }

    public GridExtent getExtent() {
        if (this.extent != null) {
            return this.extent;
        }
        throw this.incomplete(4, (short)52);
    }

    public MathTransform getGridToCRS(PixelInCell anchor) {
        MathTransform mt = PixelInCell.CELL_CENTER.equals((Object)anchor) ? this.gridToCRS : (PixelInCell.CELL_CORNER.equals((Object)anchor) ? this.cornerToCRS : PixelTranslation.translate(this.gridToCRS, PixelInCell.CELL_CENTER, anchor));
        if (mt != null) {
            return mt;
        }
        throw this.incomplete(8, (short)54);
    }

    private static CoordinateReferenceSystem getCoordinateReferenceSystem(Envelope envelope) {
        return envelope != null ? envelope.getCoordinateReferenceSystem() : null;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        CoordinateReferenceSystem crs = GridGeometry.getCoordinateReferenceSystem(this.envelope);
        if (crs != null) {
            return crs;
        }
        throw this.incomplete(1, (short)51);
    }

    public Envelope getEnvelope() {
        if (this.envelope != null && !this.envelope.isAllNaN()) {
            return this.envelope;
        }
        throw this.incomplete(2, this.extent == null ? (short)52 : 54);
    }

    public Optional<GeographicBoundingBox> getGeographicExtent() {
        return Optional.ofNullable(this.geographicBBox());
    }

    private GeographicBoundingBox geographicBBox() {
        GeographicBoundingBox bbox = this.geographicBBox;
        if (bbox == null && GridGeometry.getCoordinateReferenceSystem(this.envelope) != null && !this.envelope.isAllNaN()) {
            try {
                DefaultGeographicBoundingBox db = ReferencingServices.getInstance().setBounds(this.envelope, null, null);
                db.transitionTo(ModifiableMetadata.State.EDITABLE);
                bbox = db;
            }
            catch (TransformException e) {
                bbox = NilReason.INAPPLICABLE.createNilObject(GeographicBoundingBox.class);
            }
            this.geographicBBox = bbox;
        }
        return bbox instanceof NilObject ? null : bbox;
    }

    public Instant[] getTemporalExtent() {
        Instant[] times = this.timeRange();
        if (times.length != 0) {
            times = (Instant[])times.clone();
        }
        return times;
    }

    private Instant[] timeRange() {
        Instant[] times = this.timeRange;
        if (times == null) {
            TemporalAccessor t = TemporalAccessor.of(GridGeometry.getCoordinateReferenceSystem(this.envelope), 0);
            times = t != null ? t.getTimeRange(this.envelope) : new Instant[]{};
            this.timeRange = times;
        }
        return times;
    }

    public double[] getResolution(boolean allowEstimates) {
        if (this.resolution != null) {
            double[] res = (double[])this.resolution.clone();
            if (!allowEstimates) {
                int i;
                for (long nonLinearDimensions = this.nonLinears; nonLinearDimensions != 0L; nonLinearDimensions &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL) {
                    i = Long.numberOfTrailingZeros(nonLinearDimensions);
                    res[i] = Double.NaN;
                }
            }
            return res;
        }
        throw this.incomplete(16, this.gridToCRS == null ? (short)54 : 52);
    }

    static double[] resolution(MathTransform gridToCRS, GridExtent domain) {
        Matrix matrix = MathTransforms.getMatrix(gridToCRS);
        if (matrix != null) {
            return GridGeometry.resolution(matrix, 1);
        }
        if (domain != null && gridToCRS != null) {
            try {
                return GridGeometry.resolution(gridToCRS.derivative((DirectPosition)new DirectPositionView.Double(domain.getPointOfInterest())), 0);
            }
            catch (TransformException e) {
                GridGeometry.recoverableException((Exception)((Object)e));
            }
        }
        return null;
    }

    private static double[] resolution(Matrix gridToCRS, int numToIgnore) {
        double[] resolution = new double[gridToCRS.getNumRow() - numToIgnore];
        double[] buffer = new double[gridToCRS.getNumCol() - numToIgnore];
        for (int j = 0; j < resolution.length; ++j) {
            for (int i = 0; i < buffer.length; ++i) {
                buffer[i] = gridToCRS.getElement(j, i);
            }
            resolution[j] = MathFunctions.magnitude(buffer);
        }
        return resolution;
    }

    public boolean isConversionLinear(int ... targets) {
        int dimension = this.getTargetDimension();
        long mask = 0L;
        for (int d : targets) {
            ArgumentChecks.ensureValidIndex(dimension, d);
            if (d >= 64) continue;
            mask |= 1L << d;
        }
        return (this.nonLinears & mask) == 0L;
    }

    private static long findNonLinearTargets(MathTransform gridToCRS) {
        long nonLinearDimensions = 0L;
        for (MathTransform step : MathTransforms.getSteps(gridToCRS)) {
            long mask;
            Matrix mat = MathTransforms.getMatrix(step);
            if (mat != null) {
                mask = nonLinearDimensions;
                nonLinearDimensions = 0L;
                while (mask != 0L) {
                    int i = Long.numberOfTrailingZeros(mask);
                    int j = mat.getNumRow() - 1;
                    while (--j >= 0) {
                        if (mat.getElement(j, i) == 0.0) continue;
                        if (j >= 64) {
                            throw GridGeometry.excessiveDimension(gridToCRS);
                        }
                        nonLinearDimensions |= 1L << j;
                    }
                    mask &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL;
                }
                continue;
            }
            if (step instanceof PassThroughTransform) {
                mask = 0L;
                int dimIncrease = step.getTargetDimensions() - step.getSourceDimensions();
                int maxBits = 64 - Math.max(dimIncrease, 0);
                for (int i : ((PassThroughTransform)step).getModifiedCoordinates()) {
                    if (i >= maxBits) {
                        throw GridGeometry.excessiveDimension(gridToCRS);
                    }
                    mask |= 1L << i;
                }
                if (dimIncrease != 0) {
                    mask = (Long.highestOneBit(mask) << dimIncrease + 1) - Long.lowestOneBit(mask);
                }
                nonLinearDimensions |= mask;
                continue;
            }
            int dimension = gridToCRS.getTargetDimensions();
            if (dimension > 64) {
                throw GridGeometry.excessiveDimension(gridToCRS);
            }
            return dimension >= 64 ? -1L : (1L << dimension) - 1L;
        }
        return nonLinearDimensions;
    }

    private static ArithmeticException excessiveDimension(MathTransform gridToCRS) {
        return new ArithmeticException(Errors.format((short)37, gridToCRS.getTargetDimensions()));
    }

    private IncompleteGridGeometryException incomplete(int bitmask, short errorKey) {
        assert (this.getClass() != GridGeometry.class || !this.isDefined(bitmask));
        return new IncompleteGridGeometryException(Resources.format(errorKey));
    }

    final MathTransform requireGridToCRS(boolean center) throws IncompleteGridGeometryException {
        MathTransform mt;
        if (this.extent == null) {
            throw this.incomplete(4, (short)52);
        }
        MathTransform mathTransform = mt = center ? this.gridToCRS : this.cornerToCRS;
        if (mt == null) {
            throw this.incomplete(8, (short)54);
        }
        return mt;
    }

    public boolean isDefined(int bitmask) {
        if ((bitmask & 0xFFFFFF80) != 0) {
            throw new IllegalArgumentException(Errors.format((short)45, "bitmask", bitmask));
        }
        return !((bitmask & 1) != 0 && null == GridGeometry.getCoordinateReferenceSystem(this.envelope) || (bitmask & 2) != 0 && (null == this.envelope || this.envelope.isAllNaN()) || (bitmask & 4) != 0 && null == this.extent || (bitmask & 8) != 0 && null == this.gridToCRS || (bitmask & 0x10) != 0 && null == this.resolution || (bitmask & 0x20) != 0 && null == this.geographicBBox() || (bitmask & 0x40) != 0 && this.timeRange().length == 0);
    }

    public GridDerivation derive() {
        return new GridDerivation(this);
    }

    public GridGeometry reduce(int ... dimensions) {
        if ((dimensions = GridExtent.verifyDimensions(dimensions, this.getDimension())) != null) {
            try {
                return new GridGeometry(this, dimensions);
            }
            catch (FactoryException e) {
                throw new IllegalGridGeometryException(e, "dimensions");
            }
        }
        return this;
    }

    public int hashCode() {
        int code = -1527952352;
        if (this.gridToCRS != null) {
            code += this.gridToCRS.hashCode();
        }
        if (this.extent != null) {
            code += this.extent.hashCode();
        }
        return code;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            GridGeometry that = (GridGeometry)object;
            return Objects.equals(this.extent, that.extent) && Objects.equals(this.gridToCRS, that.gridToCRS) && Objects.equals(this.envelope, that.envelope);
        }
        return false;
    }

    static int defaultFlags() {
        return 127;
    }

    public String toString() {
        return this.toTree(Locale.getDefault(), GridGeometry.defaultFlags()).toString();
    }

    public TreeTable toTree(Locale locale, int bitmask) {
        ArgumentChecks.ensureNonNull("locale", locale);
        DefaultTreeTable tree = new DefaultTreeTable(TableColumn.VALUE_AS_TEXT);
        TreeTable.Node root = tree.getRoot();
        root.setValue(TableColumn.VALUE_AS_TEXT, Classes.getShortClassName(this));
        this.formatTo(locale, Vocabulary.getResources(locale), bitmask, root);
        return tree;
    }

    final void formatTo(Locale locale, Vocabulary vocabulary, int bitmask, TreeTable.Node root) {
        if ((bitmask & 0xFFFFFF80) != 0) {
            throw new IllegalArgumentException(Errors.format((short)45, "bitmask", bitmask));
        }
        try {
            new Formatter(locale, vocabulary, bitmask, root).format();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private final class Formatter {
        private final int bitmask;
        private final StringBuilder buffer;
        private final TreeTable.Node root;
        private TreeTable.Node section;
        private final Vocabulary vocabulary;
        private final Locale locale;
        private final CoordinateReferenceSystem crs;
        private final CoordinateSystem cs;

        Formatter(Locale locale, Vocabulary vocabulary, int bitmask, TreeTable.Node out) {
            this.root = out;
            this.bitmask = bitmask;
            this.buffer = new StringBuilder(256);
            this.locale = locale;
            this.vocabulary = vocabulary;
            this.crs = GridGeometry.getCoordinateReferenceSystem(GridGeometry.this.envelope);
            this.cs = this.crs != null ? this.crs.getCoordinateSystem() : null;
        }

        final void format() throws IOException {
            Matrix matrix;
            int i;
            Format nf;
            if (this.section(4, (short)152, true, false)) {
                GridGeometry.this.extent.appendTo(this.buffer, this.vocabulary);
                this.writeNodes();
            }
            if (this.section(32, (short)172, false, false) || this.section(64, (short)175, false, false)) {
                TableAppender table = new TableAppender(this.buffer, "  ");
                nf = new AngleFormat("DD\u00b0MM\u2032SS\u2033", this.locale);
                GeographicBoundingBox bbox = GridGeometry.this.geographicBBox();
                Instant[] times = GridGeometry.this.timeRange();
                this.vocabulary.appendLabel((short)174, table);
                table.setCellAlignment((byte)1);
                if (bbox != null) {
                    ((AngleFormat)nf).setRoundingMode(RoundingMode.CEILING);
                    table.nextColumn();
                    table.append(nf.format(new Latitude(bbox.getNorthBoundLatitude())));
                    table.nextColumn();
                    table.append(nf.format(new Longitude(bbox.getEastBoundLongitude())));
                }
                if (times.length >= 2) {
                    table.nextColumn();
                    table.append(times[1].toString());
                }
                table.nextLine();
                table.setCellAlignment((byte)-1);
                this.vocabulary.appendLabel((short)173, table);
                table.setCellAlignment((byte)1);
                if (bbox != null) {
                    ((AngleFormat)nf).setRoundingMode(RoundingMode.FLOOR);
                    table.nextColumn();
                    table.append(nf.format(new Latitude(bbox.getSouthBoundLatitude())));
                    table.nextColumn();
                    table.append(nf.format(new Longitude(bbox.getWestBoundLongitude())));
                }
                if (times.length >= 1) {
                    table.nextColumn();
                    table.append(times[0].toString());
                }
                table.flush();
                this.writeNodes();
            }
            if (this.section(2, (short)151, true, false)) {
                boolean appendResolution = (this.bitmask & 0x10) != 0 && GridGeometry.this.resolution != null;
                TableAppender table = new TableAppender(this.buffer, "");
                int dimension = GridGeometry.this.envelope.getDimension();
                NumberFormat nf2 = NumberFormat.getNumberInstance(this.locale);
                for (i = 0; i < dimension; ++i) {
                    double lower = GridGeometry.this.envelope.getLower(i);
                    double upper = GridGeometry.this.envelope.getUpper(i);
                    double delta = GridGeometry.this.resolution != null ? GridGeometry.this.resolution[i] : Double.NaN;
                    nf2.setMinimumFractionDigits(Numerics.fractionDigitsForDelta(delta));
                    nf2.setMaximumFractionDigits(Numerics.suggestFractionDigits(lower, upper));
                    CoordinateSystemAxis axis = this.cs != null ? this.cs.getAxis(i) : null;
                    String name = axis != null ? axis.getName().getCode() : this.vocabulary.getString((short)148, i);
                    table.append(name).append(": ").nextColumn();
                    table.setCellAlignment((byte)1);
                    table.append(nf2.format(lower)).nextColumn();
                    table.setCellAlignment((byte)-1);
                    table.append(" \u2026 ").append(nf2.format(upper));
                    if (appendResolution) {
                        boolean isLinear = i < 64 && (GridGeometry.this.nonLinears & 1L << i) == 0L;
                        table.nextColumn();
                        table.append("  \u2206");
                        if (axis != null) {
                            table.append(axis.getAbbreviation());
                        }
                        table.nextColumn();
                        table.append(' ').append(isLinear ? (char)'=' : '\u2248').append(' ');
                        this.appendResolution(table, nf2, delta, i);
                    }
                    table.nextLine();
                }
                table.flush();
                this.writeNodes();
            } else if (this.section(16, (short)153, true, false)) {
                String separator = "";
                nf = NumberFormat.getNumberInstance(this.locale);
                for (int i2 = 0; i2 < GridGeometry.this.resolution.length; ++i2) {
                    this.appendResolution(this.buffer.append(separator), (NumberFormat)nf, GridGeometry.this.resolution[i2], i2);
                    separator = " \u00d7 ";
                }
                this.writeNode();
            }
            if (this.section(1, (short)132, true, false)) {
                Identifier id = IdentifiedObjects.getIdentifier((IdentifiedObject)this.crs, null);
                if (id != null) {
                    this.buffer.append(IdentifiedObjects.toString(id)).append(" \u2014 ");
                }
                this.buffer.append(this.crs.getName());
                this.writeNode();
            }
            if (this.section(8, (short)150, true, (matrix = MathTransforms.getMatrix(GridGeometry.this.gridToCRS)) != null)) {
                if (matrix != null) {
                    this.writeNode(Matrices.toString(matrix));
                } else {
                    long nonLinearDimensions;
                    this.buffer.append(GridGeometry.this.gridToCRS.getSourceDimensions()).append("D \u2192 ").append(GridGeometry.this.gridToCRS.getTargetDimensions()).append("D ");
                    String separator = Resources.forLocale(this.locale).getString((short)45, Long.bitCount(nonLinearDimensions));
                    for (nonLinearDimensions = GridGeometry.this.nonLinears; nonLinearDimensions != 0L; nonLinearDimensions &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL) {
                        i = Long.numberOfTrailingZeros(nonLinearDimensions);
                        this.buffer.append(separator).append(' ').append(this.cs != null ? this.cs.getAxis(i).getName().getCode() : String.valueOf(i));
                        separator = ",";
                    }
                    this.writeNode();
                }
            }
        }

        private boolean section(int property, short title, boolean mandatory, boolean cellCenter) {
            if ((this.bitmask & property) != 0) {
                String text = this.vocabulary.getString(title);
                if (cellCenter) {
                    text = this.buffer.append((CharSequence)text).append(" (").append(this.vocabulary.getString((short)155).toLowerCase(this.locale)).append(')').toString();
                    this.buffer.setLength(0);
                }
                this.section = this.root.newChild();
                this.section.setValue(TableColumn.VALUE_AS_TEXT, text);
                if (GridGeometry.this.isDefined(property)) {
                    return true;
                }
                if (mandatory) {
                    this.writeNode(this.vocabulary.getString((short)154));
                }
            }
            return false;
        }

        private void writeNode(CharSequence line) {
            String text = line.toString().trim();
            if (!text.isEmpty()) {
                this.section.newChild().setValue(TableColumn.VALUE_AS_TEXT, text);
            }
        }

        private void writeNode() {
            this.writeNode(this.buffer);
            this.buffer.setLength(0);
        }

        private void writeNodes() {
            for (CharSequence line : CharSequences.splitOnEOL(this.buffer)) {
                this.writeNode(line);
            }
            this.buffer.setLength(0);
        }

        private void appendResolution(Appendable out, NumberFormat nf, double res, int dim) throws IOException {
            if (Double.isNaN(res)) {
                out.append('?');
            } else {
                nf.setMaximumFractionDigits(Numerics.suggestFractionDigits(res) / 2);
                out.append(nf.format(res));
            }
            if (this.cs != null) {
                String unit = String.valueOf(this.cs.getAxis(dim).getUnit());
                if (unit.isEmpty() || Character.isLetterOrDigit(unit.codePointAt(0))) {
                    out.append(' ');
                }
                out.append(unit);
            }
        }
    }
}

