/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.sis.coverage.SubspaceNotSpecifiedException;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.GridCoordinatesView;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.io.TableAppender;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GridExtent
implements Serializable {
    private static final long serialVersionUID = -4717353677844056017L;
    private static final Map<AxisDirection, DimensionNameType> AXIS_DIRECTIONS;
    private static final DimensionNameType[] DEFAULT_TYPES;
    private static final WeakValueHashMap<DimensionNameType[], DimensionNameType[]> POOL;
    private final DimensionNameType[] types;
    private final long[] coordinates;

    private static long[] allocate(int dimension) throws IllegalArgumentException {
        if (dimension >= Short.MAX_VALUE) {
            throw new IllegalArgumentException(Errors.format((short)37, dimension));
        }
        return new long[dimension << 1];
    }

    private void validateCoordinates() throws IllegalArgumentException {
        int dimension = this.coordinates.length >>> 1;
        for (int i = 0; i < dimension; ++i) {
            long lower = this.coordinates[i];
            long upper = this.coordinates[i + dimension];
            if (lower <= upper) continue;
            throw new IllegalArgumentException(Resources.format((short)32, this.getAxisIdentification(i, i), lower, upper));
        }
    }

    private static DimensionNameType[] validateAxisTypes(DimensionNameType[] types) throws IllegalArgumentException {
        if (types == null) {
            return null;
        }
        if (Arrays.equals(DEFAULT_TYPES, types)) {
            return DEFAULT_TYPES;
        }
        DimensionNameType[] shared = POOL.get(types);
        if (shared == null) {
            types = (DimensionNameType[])types.clone();
            for (int i = 1; i < types.length; ++i) {
                DimensionNameType t = types[i];
                if (t == null) continue;
                int j = i;
                while (--j >= 0) {
                    if (!t.equals((Object)types[j])) continue;
                    throw new IllegalArgumentException(Errors.format((short)24, t));
                }
            }
            shared = POOL.putIfAbsent(types, types);
            if (shared == null) {
                return types;
            }
        }
        return shared;
    }

    private GridExtent(int dimension, DimensionNameType[] axisTypes) {
        this.coordinates = GridExtent.allocate(dimension);
        this.types = GridExtent.validateAxisTypes(axisTypes);
    }

    public GridExtent(long width, long height) {
        ArgumentChecks.ensureStrictlyPositive("width", width);
        ArgumentChecks.ensureStrictlyPositive("height", height);
        this.coordinates = new long[4];
        this.coordinates[2] = width - 1L;
        this.coordinates[3] = height - 1L;
        this.types = DEFAULT_TYPES;
    }

    public GridExtent(DimensionNameType[] axisTypes, long[] low, long[] high, boolean isHighIncluded) {
        ArgumentChecks.ensureNonNull("high", high);
        int dimension = high.length;
        if (low != null && low.length != dimension) {
            throw new IllegalArgumentException(Errors.format((short)80, low.length, dimension));
        }
        if (axisTypes != null && axisTypes.length != dimension) {
            throw new IllegalArgumentException(Errors.format((short)77));
        }
        this.coordinates = GridExtent.allocate(dimension);
        if (low != null) {
            System.arraycopy(low, 0, this.coordinates, 0, dimension);
        }
        System.arraycopy(high, 0, this.coordinates, dimension, dimension);
        if (!isHighIncluded) {
            for (int i = dimension; i < this.coordinates.length; ++i) {
                this.coordinates[i] = Math.decrementExact(this.coordinates[i]);
            }
        }
        this.types = GridExtent.validateAxisTypes(axisTypes);
        this.validateCoordinates();
    }

    GridExtent(AbstractEnvelope envelope, GridRoundingMode rounding, int[] margin, GridExtent enclosing, int[] modifiedDimensions) {
        int dimension = envelope.getDimension();
        this.coordinates = enclosing != null ? (long[])enclosing.coordinates.clone() : GridExtent.allocate(dimension);
        for (int i = 0; i < dimension; ++i) {
            long upper;
            long lower;
            boolean isMaxValid;
            double min = envelope.getLower(i);
            double max = envelope.getUpper(i);
            boolean isMinValid = min >= -9.223372036854776E18;
            boolean bl = isMaxValid = max <= 9.223372036854776E18;
            if (min > max || enclosing == null && !(isMinValid & isMaxValid)) {
                throw new IllegalArgumentException(Resources.format((short)32, this.getAxisIdentification(i, i), min, max));
            }
            if (!isMinValid) {
                min = -9.223372036854776E18;
            }
            if (!isMaxValid) {
                max = 9.223372036854776E18;
            }
            switch (rounding) {
                default: {
                    throw new AssertionError((Object)rounding);
                }
                case ENCLOSING: {
                    lower = (long)Math.floor(min);
                    upper = (long)Math.ceil(max);
                    if (lower == upper) break;
                    --upper;
                    break;
                }
                case NEAREST: {
                    double span;
                    long extent;
                    long error;
                    lower = Math.round(min);
                    upper = Math.round(max);
                    if (lower != upper) {
                        --upper;
                    }
                    if ((error = upper - lower + 1L) < 0L || (extent = Math.round(span = envelope.getSpan(i))) == 0L || Math.abs(error -= extent) != 1L) break;
                    double dmin = Math.abs(min - Math.rint(min));
                    double dmax = Math.abs(max - Math.rint(max));
                    boolean adjustMax = dmax >= dmin;
                    double d = Math.abs(span - (double)extent);
                    double d2 = adjustMax ? dmax : dmin;
                    if (!(d < d2)) break;
                    if (adjustMax) {
                        upper = Math.subtractExact(upper, error);
                        break;
                    }
                    lower = Math.addExact(lower, error);
                }
            }
            if (margin != null && i < margin.length) {
                int m = margin[i];
                if (enclosing != null && m > 0) {
                    if (lower < (lower -= (long)m)) {
                        lower = Long.MIN_VALUE;
                    }
                    if (upper > (upper += (long)m)) {
                        upper = Long.MAX_VALUE;
                    }
                } else {
                    lower = Math.subtractExact(lower, (long)m);
                    upper = Math.addExact(upper, (long)m);
                }
            }
            if (lower > upper) {
                upper += lower - upper >>> 1;
                lower = upper;
            }
            int m = this.getDimension();
            if (enclosing != null) {
                int lo = modifiedDimensions != null ? modifiedDimensions[i] : i;
                int hi = lo + m;
                long validMin = this.coordinates[lo];
                long validMax = this.coordinates[hi];
                if (lower > validMin) {
                    this.coordinates[lo] = lower;
                }
                if (upper < validMax) {
                    this.coordinates[hi] = upper;
                }
                if (lower <= validMax && upper >= validMin) continue;
                throw new DisjointExtentException(enclosing.getAxisIdentification(lo, i), validMin, validMax, lower, upper);
            }
            this.coordinates[i] = lower;
            this.coordinates[i + m] = upper;
        }
        if (enclosing != null) {
            this.types = enclosing.types;
        } else {
            DimensionNameType[] axisTypes = null;
            CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
            if (crs != null) {
                CoordinateSystem cs = crs.getCoordinateSystem();
                for (int i = 0; i < dimension; ++i) {
                    DimensionNameType type = AXIS_DIRECTIONS.get(AxisDirections.absolute(cs.getAxis(i).getDirection()));
                    if (type == null) continue;
                    if (axisTypes == null) {
                        axisTypes = new DimensionNameType[dimension];
                    }
                    axisTypes[i] = type;
                }
            }
            this.types = GridExtent.validateAxisTypes(axisTypes);
        }
    }

    private GridExtent(GridExtent extent) {
        this.types = extent.types;
        this.coordinates = (long[])extent.coordinates.clone();
    }

    public final int getDimension() {
        return this.coordinates.length >>> 1;
    }

    public boolean startsAtZero() {
        int i = this.getDimension();
        while (--i >= 0) {
            if (this.coordinates[i] == 0L) continue;
            return false;
        }
        return true;
    }

    GridCoordinatesView getLow() {
        return new GridCoordinatesView(this.coordinates, 0);
    }

    GridCoordinatesView getHigh() {
        return new GridCoordinatesView(this.coordinates, this.getDimension());
    }

    public long getLow(int index) {
        ArgumentChecks.ensureValidIndex(this.getDimension(), index);
        return this.coordinates[index];
    }

    public long getHigh(int index) {
        int dimension = this.getDimension();
        ArgumentChecks.ensureValidIndex(dimension, index);
        return this.coordinates[index + dimension];
    }

    public long getSize(int index) {
        int dimension = this.getDimension();
        ArgumentChecks.ensureValidIndex(dimension, index);
        return Math.incrementExact(Math.subtractExact(this.coordinates[dimension + index], this.coordinates[index]));
    }

    public double getSize(int index, boolean minusOne) {
        int dimension = this.getDimension();
        ArgumentChecks.ensureValidIndex(dimension, index);
        long size = this.coordinates[dimension + index] - this.coordinates[index];
        if (!minusOne && ++size == 0L) {
            return 1.8446744073709552E19;
        }
        return Numerics.toUnsignedDouble(size);
    }

    public double[] getPointOfInterest() {
        int dimension = this.getDimension();
        double[] center = new double[dimension];
        for (int i = 0; i < dimension; ++i) {
            center[i] = ((double)this.coordinates[i] + (double)this.coordinates[i + dimension] + 1.0) * 0.5;
        }
        return center;
    }

    public int[] getSubspaceDimensions(int s) {
        ArgumentChecks.ensurePositive("s", s);
        int m = this.getDimension();
        if (s > m) {
            throw new RuntimeException(Resources.format((short)29, s));
        }
        int[] selected = new int[s];
        int count = 0;
        for (int i = 0; i < m; ++i) {
            long low = this.coordinates[i];
            long high = this.coordinates[i + m];
            if (low == high) continue;
            if (count < s) {
                selected[count++] = i;
                continue;
            }
            throw new SubspaceNotSpecifiedException(Resources.format((short)44, s, this.getAxisIdentification(i, i), Numerics.toUnsignedDouble(high - low)));
        }
        int missing = s - count;
        if (missing != 0) {
            System.arraycopy(selected, 0, selected, missing, count);
            count = 0;
            int i = 0;
            while (true) {
                if (this.coordinates[i] == this.coordinates[i + m]) {
                    selected[count++] = i;
                    if (count == missing) break;
                }
                ++i;
            }
            Arrays.sort(selected);
        }
        return selected;
    }

    public Optional<DimensionNameType> getAxisType(int index) {
        ArgumentChecks.ensureValidIndex(this.getDimension(), index);
        return Optional.ofNullable(this.types != null ? this.types[index] : null);
    }

    final Object getAxisIdentification(int index, int indexShown) {
        DimensionNameType type;
        if (this.types != null && (type = this.types[index]) != null) {
            return indexShown + " (" + Types.getCodeTitle(type) + ')';
        }
        return indexShown;
    }

    final GeneralEnvelope toCRS(MathTransform cornerToCRS, MathTransform gridToCRS, Envelope fallback) throws TransformException {
        int dimension = this.getDimension();
        GeneralEnvelope envelope = new GeneralEnvelope(dimension);
        for (int i = 0; i < dimension; ++i) {
            envelope.setRange(i, this.coordinates[i], (double)this.coordinates[i + dimension] + 1.0);
        }
        if ((envelope = Envelopes.transform(cornerToCRS, (Envelope)envelope)).isEmpty()) {
            try {
                boolean isCenter = gridToCRS != cornerToCRS;
                TransformSeparator separator = null;
                for (int srcDim = 0; srcDim < dimension; ++srcDim) {
                    if (this.coordinates[srcDim + dimension] != 0L || this.coordinates[srcDim] != 0L) continue;
                    if (separator == null) {
                        separator = new TransformSeparator(gridToCRS);
                    }
                    separator.addSourceDimensionRange(srcDim, srcDim + 1);
                    Matrix component = MathTransforms.getMatrix(separator.separate());
                    if (component != null) {
                        int[] targets = separator.getTargetDimensions();
                        for (int j = 0; j < targets.length; ++j) {
                            int tgtDim = targets[j];
                            double lower = envelope.getLower(tgtDim);
                            double upper = envelope.getUpper(tgtDim);
                            double value = component.getElement(j, component.getNumCol() - 1);
                            if (isCenter) {
                                double span = upper - value;
                                if (Double.isNaN(span) && Double.isNaN(span = value - lower)) {
                                    span = 0.0;
                                }
                                if (Double.isNaN(lower)) {
                                    lower = value - span;
                                }
                                if (Double.isNaN(upper)) {
                                    upper = value + span;
                                }
                            } else if (Double.isNaN(lower)) {
                                lower = value;
                            }
                            envelope.setRange(tgtDim, lower, upper);
                        }
                    }
                    separator.clear();
                }
                if (fallback != null) {
                    int tgtDim = envelope.getDimension();
                    while (--tgtDim >= 0) {
                        boolean modified = false;
                        double lower = envelope.getLower(tgtDim);
                        double upper = envelope.getUpper(tgtDim);
                        if (Double.isNaN(lower)) {
                            lower = fallback.getMinimum(tgtDim);
                            modified = true;
                        }
                        if (Double.isNaN(upper)) {
                            upper = fallback.getMaximum(tgtDim);
                            modified = true;
                        }
                        if (!modified || lower > upper) continue;
                        envelope.setRange(tgtDim, lower, upper);
                    }
                }
            }
            catch (FactoryException e) {
                GridGeometry.recoverableException((Exception)((Object)e));
            }
        }
        return envelope;
    }

    public GridExtent insert(int offset, DimensionNameType axisType, long low, long high, boolean isHighIncluded) {
        int dimension = this.getDimension();
        ArgumentChecks.ensureBetween("offset", 0, dimension, offset);
        if (!isHighIncluded) {
            high = Math.decrementExact(high);
        }
        int newDim = dimension + 1;
        DimensionNameType[] axisTypes = null;
        if (this.types != null || axisType != null) {
            axisTypes = this.types != null ? ArraysExt.insert(this.types, offset, 1) : new DimensionNameType[newDim];
            axisTypes[offset] = axisType;
        }
        GridExtent ex = new GridExtent(newDim, axisTypes);
        System.arraycopy(this.coordinates, 0, ex.coordinates, 0, offset);
        System.arraycopy(this.coordinates, offset, ex.coordinates, offset + 1, dimension - offset);
        System.arraycopy(this.coordinates, dimension, ex.coordinates, newDim, offset);
        System.arraycopy(this.coordinates, dimension + offset, ex.coordinates, newDim + offset + 1, dimension - offset);
        ex.coordinates[offset] = low;
        ex.coordinates[offset + newDim] = high;
        ex.validateCoordinates();
        return ex;
    }

    static int[] verifyDimensions(int[] dimensions, int limit) {
        ArgumentChecks.ensureNonNull("dimensions", dimensions);
        int n = dimensions.length;
        ArgumentChecks.ensureSizeBetween("dimensions", 1, limit, n);
        dimensions = (int[])dimensions.clone();
        if (!ArraysExt.isSorted(dimensions, true)) {
            throw new IllegalArgumentException(Resources.format((short)46));
        }
        int d = dimensions[0];
        if (d >= 0 && (d = dimensions[n - 1]) < limit) {
            return (int[])(n != limit ? dimensions : null);
        }
        throw new IndexOutOfBoundsException(Errors.format((short)71, d));
    }

    public GridExtent expand(long ... margins) {
        ArgumentChecks.ensureNonNull("margins", margins);
        int m = this.getDimension();
        int length = Math.min(m, margins.length);
        GridExtent resize = new GridExtent(this);
        long[] c = resize.coordinates;
        for (int i = 0; i < length; ++i) {
            long margin = margins[i];
            c[i] = Math.subtractExact(c[i], margin);
            c[i + m] = Math.addExact(c[i + m], margin);
        }
        return Arrays.equals(c, this.coordinates) ? this : resize;
    }

    public GridExtent resize(long ... sizes) {
        ArgumentChecks.ensureNonNull("sizes", sizes);
        int m = this.getDimension();
        int length = Math.min(m, sizes.length);
        GridExtent resize = new GridExtent(this);
        long[] c = resize.coordinates;
        for (int i = 0; i < length; ++i) {
            long size = sizes[i];
            if (size <= 0L) {
                throw new IllegalArgumentException(Errors.format((short)165, Strings.toIndexed("sizes", i), size));
            }
            long lower = c[i];
            long upper = c[i + m];
            long current = Math.incrementExact(Math.subtractExact(upper, lower));
            if (Math.abs(lower) <= Math.abs(upper)) {
                lower = Numerics.multiplyDivide(lower, size, current);
                upper = Math.addExact(lower, size - 1L);
            } else {
                upper = Numerics.multiplyDivide(upper, size, current);
                lower = Math.subtractExact(upper, size - 1L);
            }
            c[i] = lower;
            c[i + m] = upper;
        }
        return Arrays.equals(c, this.coordinates) ? this : resize;
    }

    public GridExtent reduce(int ... dimensions) {
        int sd = this.getDimension();
        if ((dimensions = GridExtent.verifyDimensions(dimensions, sd)) == null) {
            return this;
        }
        int td = dimensions.length;
        DimensionNameType[] tt = null;
        if (this.types != null) {
            tt = new DimensionNameType[td];
            for (int i = 0; i < td; ++i) {
                tt[i] = this.types[dimensions[i]];
            }
        }
        GridExtent sub = new GridExtent(td, tt);
        for (int i = 0; i < td; ++i) {
            int j = dimensions[i];
            sub.coordinates[i] = this.coordinates[j];
            sub.coordinates[i + td] = this.coordinates[j + sd];
        }
        return sub;
    }

    public GridExtent subsample(int ... periods) {
        ArgumentChecks.ensureNonNull("periods", periods);
        int m = this.getDimension();
        ArgumentChecks.ensureDimensionMatches("periods", m, periods);
        GridExtent sub = new GridExtent(this);
        for (int i = 0; i < m; ++i) {
            int s = periods[i];
            if (s > 1) {
                int j = i + m;
                long low = this.coordinates[i];
                long size = this.coordinates[j] - low + 1L;
                if (size == 0L) {
                    throw new ArithmeticException(Errors.format((short)188, 64));
                }
                long r = Long.divideUnsigned(size, s);
                if (r * (long)s == size) {
                    --r;
                }
                sub.coordinates[i] = low /= (long)s;
                sub.coordinates[j] = low + r;
                continue;
            }
            if (s > 0) continue;
            throw new IllegalArgumentException(Errors.format((short)165, Strings.toIndexed("periods", i), s));
        }
        return Arrays.equals(this.coordinates, sub.coordinates) ? this : sub;
    }

    final GridExtent sliceByRatio(DirectPosition slicePoint, double sliceRatio, int[] dimensionsToKeep) {
        int i = slicePoint.getDimension();
        while (--i >= 0) {
            slicePoint.setOrdinate(i, sliceRatio * this.getSize(i, true) + (double)this.getLow(i));
        }
        for (i = 0; i < dimensionsToKeep.length; ++i) {
            slicePoint.setOrdinate(dimensionsToKeep[i], Double.NaN);
        }
        return this.slice(slicePoint, null);
    }

    final GridExtent slice(DirectPosition slicePoint, int[] modifiedDimensions) {
        GridExtent slice = new GridExtent(this);
        int n = slicePoint.getDimension();
        int m = this.getDimension();
        for (int k = 0; k < n; ++k) {
            double p = slicePoint.getOrdinate(k);
            if (Double.isNaN(p)) continue;
            long c = Math.round(p);
            int i = modifiedDimensions != null ? modifiedDimensions[k] : k;
            long low = this.coordinates[i];
            long high = this.coordinates[i + m];
            if (c >= low && c <= high) {
                slice.coordinates[i + m] = slice.coordinates[i] = c;
                continue;
            }
            StringBuilder b = new StringBuilder();
            for (int j = 0; j < n; ++j) {
                if (j != 0) {
                    b.append(", ");
                }
                if (Double.isNaN(p = slicePoint.getOrdinate(j))) {
                    b.append("NaN");
                    continue;
                }
                b.append(Math.round(p));
            }
            throw new RuntimeException(Resources.format((short)28, this.getAxisIdentification(i, k), low, high, b.toString()));
        }
        return Arrays.equals(this.coordinates, slice.coordinates) ? this : slice;
    }

    final MatrixSIS cornerToCRS(Envelope env) {
        int srcDim = this.getDimension();
        int tgtDim = env.getDimension();
        MatrixSIS affine = Matrices.create(tgtDim + 1, srcDim + 1, ExtendedPrecisionMatrix.ZERO);
        DoubleDouble scale = new DoubleDouble();
        DoubleDouble offset = new DoubleDouble();
        for (int j = 0; j < tgtDim; ++j) {
            if (j < srcDim) {
                offset.set(this.coordinates[j]);
                scale.set(this.coordinates[j + srcDim]);
                scale.subtract(offset);
                scale.add(1.0);
                scale.inverseDivideGuessError(env.getSpan(j));
                if (!offset.isZero()) {
                    offset.multiply(scale);
                    offset.negate();
                }
                offset.addGuessError(env.getMinimum(j));
                affine.setNumber(j, srcDim, offset);
            } else {
                scale.value = Double.NaN;
                scale.error = Double.NaN;
            }
            affine.setNumber(j, j, scale);
        }
        affine.setElement(tgtDim, srcDim, 1.0);
        return affine;
    }

    public int hashCode() {
        return Arrays.hashCode(this.coordinates) + Arrays.hashCode(this.types) ^ 0xD838F82F;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == GridExtent.class) {
            GridExtent other = (GridExtent)object;
            return Arrays.equals(this.coordinates, other.coordinates) && Arrays.equals(this.types, other.types);
        }
        return false;
    }

    public String toString() {
        StringBuilder out = new StringBuilder(256);
        try {
            this.appendTo(out, Vocabulary.getResources((Locale)null));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return out.toString();
    }

    final void appendTo(Appendable out, Vocabulary vocabulary) throws IOException {
        TableAppender table = new TableAppender(out, "");
        int dimension = this.getDimension();
        for (int i = 0; i < dimension; ++i) {
            String name;
            if (this.types == null || (name = Types.getCodeTitle(this.types[i])) == null) {
                name = vocabulary.getString((short)148, i);
            }
            long lower = this.coordinates[i];
            long upper = this.coordinates[i + dimension];
            table.setCellAlignment((byte)-1);
            table.append(name).append(": ").nextColumn();
            table.append('[').nextColumn();
            table.setCellAlignment((byte)1);
            table.append(Long.toString(lower)).append(" \u2026 ").nextColumn();
            table.append(Long.toString(upper)).append("] ").nextColumn();
            table.append('(').append(vocabulary.getString((short)149, Long.toUnsignedString(upper - lower + 1L))).append(')').nextLine();
        }
        table.flush();
    }

    static {
        HashMap<AxisDirection, DimensionNameType> dir = new HashMap<AxisDirection, DimensionNameType>(6);
        dir.put(AxisDirection.COLUMN_POSITIVE, DimensionNameType.COLUMN);
        dir.put(AxisDirection.ROW_POSITIVE, DimensionNameType.ROW);
        dir.put(AxisDirection.UP, DimensionNameType.VERTICAL);
        dir.put(AxisDirection.FUTURE, DimensionNameType.TIME);
        AXIS_DIRECTIONS = dir;
        DEFAULT_TYPES = new DimensionNameType[]{DimensionNameType.COLUMN, DimensionNameType.ROW};
        POOL = new WeakValueHashMap(DimensionNameType[].class);
    }
}

