/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Locale;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.WraparoundAdjustment;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GridDerivation {
    protected final GridGeometry base;
    private GridRoundingMode rounding;
    private int[] margin;
    private GridExtent baseExtent;
    private GridExtent scaledExtent;
    private MathTransform toBase;
    private int[] modifiedDimensions;
    private double[] scales;
    private String subGridSetter;

    protected GridDerivation(GridGeometry base) {
        ArgumentChecks.ensureNonNull("base", base);
        this.base = base;
        this.baseExtent = base.extent;
        this.rounding = GridRoundingMode.NEAREST;
    }

    private void ensureSubgridNotSet() {
        if (this.subGridSetter != null) {
            throw new IllegalStateException(Resources.format((short)25, this.subGridSetter));
        }
    }

    public GridDerivation rounding(GridRoundingMode mode) {
        ArgumentChecks.ensureNonNull("mode", (Object)mode);
        this.ensureSubgridNotSet();
        this.rounding = mode;
        return this;
    }

    public GridDerivation margin(int ... cellCounts) {
        ArgumentChecks.ensureNonNull("cellCounts", cellCounts);
        this.ensureSubgridNotSet();
        int[] margin = null;
        int i = cellCounts.length;
        while (--i >= 0) {
            int n = cellCounts[i];
            ArgumentChecks.ensurePositive("cellCounts", n);
            if (margin == null) {
                margin = new int[i + 1];
            }
            margin[i] = n;
        }
        this.margin = margin;
        return this;
    }

    public GridDerivation resize(GridExtent extent, double ... scales) {
        int actual;
        ArgumentChecks.ensureNonNull("scales", scales);
        this.ensureSubgridNotSet();
        this.subGridSetter = "resize";
        int n = this.base.getDimension();
        if (extent != null && (actual = extent.getDimension()) != n) {
            throw new IllegalArgumentException(Errors.format((short)81, "extent", n, actual));
        }
        actual = scales.length;
        scales = Arrays.copyOf(scales, n);
        if (actual < n) {
            Arrays.fill(scales, actual, n, 1.0);
        }
        this.toBase = MathTransforms.scale(scales);
        this.scales = scales;
        if (extent == null && this.baseExtent != null) {
            try {
                MathTransform mt = this.toBase.inverse();
                GeneralEnvelope indices = this.baseExtent.toCRS(mt, mt, null);
                extent = new GridExtent(indices, this.rounding, this.margin, null, null);
            }
            catch (TransformException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.scaledExtent = extent;
        return this;
    }

    public GridDerivation subgrid(GridGeometry gridOfInterest) {
        ArgumentChecks.ensureNonNull("gridOfInterest", gridOfInterest);
        this.ensureSubgridNotSet();
        this.subGridSetter = "subgrid";
        if (!this.base.equals(gridOfInterest)) {
            MathTransform mapCenters;
            GridExtent domain = gridOfInterest.getExtent();
            try {
                CoordinateOperation crsChange = Envelopes.findOperation(gridOfInterest.envelope, this.base.envelope);
                MathTransform mapCorners = GridDerivation.path(gridOfInterest, crsChange, this.base, PixelInCell.CELL_CORNER);
                mapCenters = GridDerivation.path(gridOfInterest, crsChange, this.base, PixelInCell.CELL_CENTER);
                this.clipExtent(domain.toCRS(mapCorners, mapCenters, null));
            }
            catch (TransformException | FactoryException e) {
                throw new IllegalGridGeometryException(e, "gridOfInterest");
            }
            if (this.baseExtent != this.base.extent && this.baseExtent.equals(gridOfInterest.extent)) {
                this.baseExtent = gridOfInterest.extent;
            }
            this.scales = GridGeometry.resolution(mapCenters, domain);
            this.subsample(this.getSubsamplings());
        }
        return this;
    }

    private static MathTransform path(GridGeometry source, CoordinateOperation crsChange, GridGeometry target, PixelInCell anchor) throws NoninvertibleTransformException {
        MathTransform step1 = source.getGridToCRS(anchor);
        MathTransform step2 = target.getGridToCRS(anchor);
        if (crsChange != null) {
            step1 = MathTransforms.concatenate(step1, crsChange.getMathTransform());
        }
        if (step1.equals(step2)) {
            return MathTransforms.identity(step1.getSourceDimensions());
        }
        return MathTransforms.concatenate(step1, step2.inverse());
    }

    public GridDerivation subgrid(Envelope areaOfInterest, double ... resolution) {
        this.ensureSubgridNotSet();
        MathTransform cornerToCRS = this.base.requireGridToCRS(false);
        this.subGridSetter = "subgrid";
        try {
            CoordinateReferenceSystem crs;
            MathTransform baseToAOI = null;
            if (areaOfInterest != null && (crs = areaOfInterest.getCoordinateReferenceSystem()) != null) {
                CoordinateOperation op = Envelopes.findOperation(this.base.envelope, areaOfInterest);
                if (op == null) {
                    op = CRS.findOperation(this.base.getCoordinateReferenceSystem(), crs, null);
                }
                baseToAOI = op.getMathTransform();
                cornerToCRS = MathTransforms.concatenate(cornerToCRS, baseToAOI);
            }
            int dimension = cornerToCRS.getTargetDimensions();
            ArgumentChecks.ensureDimensionMatches("areaOfInterest", dimension, areaOfInterest);
            cornerToCRS = this.dropUnusedDimensions(cornerToCRS, dimension);
            dimension = this.baseExtent.getDimension();
            GeneralEnvelope indices = null;
            if (areaOfInterest != null) {
                indices = new WraparoundAdjustment(this.base.envelope, baseToAOI, cornerToCRS.inverse()).shift(areaOfInterest);
                this.clipExtent(indices);
            }
            if (indices == null || indices.getDimension() != dimension) {
                indices = new GeneralEnvelope(dimension);
            }
            for (int i = 0; i < dimension; ++i) {
                indices.setRange(i, this.baseExtent.getLow(i), (double)this.baseExtent.getHigh(i) + 1.0);
            }
            if (resolution != null && resolution.length != 0) {
                int i;
                double s;
                int k;
                resolution = ArraysExt.resize(resolution, cornerToCRS.getTargetDimensions());
                Matrix m = cornerToCRS.derivative((DirectPosition)new DirectPositionView.Double(this.getPointOfInterest()));
                double[] subsampling = Matrices.inverse(m).multiply(resolution);
                int[] modifiedDimensions = this.modifiedDimensions;
                boolean modified = false;
                for (k = 0; k < subsampling.length; ++k) {
                    s = Math.abs(subsampling[k]);
                    if (s > 1.0) {
                        i = modifiedDimensions != null ? modifiedDimensions[k] : k;
                        int accuracy = Math.max(0, Math.getExponent(indices.getSpan(i))) + 1;
                        s = Math.scalb(Math.rint(Math.scalb(s, accuracy)), -accuracy);
                        indices.setRange(i, indices.getLower(i) / s, indices.getUpper(i) / s);
                        modified = true;
                    }
                    subsampling[k] = s;
                }
                if (modified) {
                    this.scaledExtent = new GridExtent(indices, this.rounding, null, null, modifiedDimensions);
                    if (this.baseExtent.equals(this.scaledExtent)) {
                        this.scaledExtent = this.baseExtent;
                    }
                    m = Matrices.createIdentity(dimension + 1);
                    for (k = 0; k < subsampling.length; ++k) {
                        s = subsampling[k];
                        if (!(s > 1.0)) continue;
                        i = modifiedDimensions != null ? modifiedDimensions[k] : k;
                        m.setElement(i, i, s);
                        m.setElement(i, dimension, (double)this.baseExtent.getLow(i) - (double)this.scaledExtent.getLow(i) * s);
                    }
                    this.toBase = MathTransforms.linear(m);
                    this.scales = subsampling;
                }
            }
        }
        catch (TransformException | FactoryException e) {
            throw new IllegalGridGeometryException(e, "areaOfInterest");
        }
        this.modifiedDimensions = null;
        return this;
    }

    private MathTransform dropUnusedDimensions(MathTransform cornerToCRS, int dimension) throws FactoryException, TransformException {
        if (dimension < cornerToCRS.getSourceDimensions()) {
            TransformSeparator sep = new TransformSeparator(cornerToCRS);
            cornerToCRS = sep.separate();
            this.modifiedDimensions = sep.getSourceDimensions();
            if (this.modifiedDimensions.length != dimension) {
                throw new TransformException(Resources.format((short)24));
            }
        }
        return cornerToCRS;
    }

    private double[] getPointOfInterest() {
        double[] pointOfInterest = this.baseExtent.getPointOfInterest();
        if (this.modifiedDimensions == null) {
            return pointOfInterest;
        }
        double[] filtered = new double[this.modifiedDimensions.length];
        for (int i = 0; i < filtered.length; ++i) {
            filtered[i] = pointOfInterest[this.modifiedDimensions[i]];
        }
        return filtered;
    }

    private void clipExtent(GeneralEnvelope indices) {
        GridExtent sub = new GridExtent(indices, this.rounding, this.margin, this.baseExtent, this.modifiedDimensions);
        if (!sub.equals(this.baseExtent)) {
            this.baseExtent = sub;
        }
    }

    public GridDerivation subsample(int ... subsamplings) {
        ArgumentChecks.ensureNonNull("subsamplings", subsamplings);
        if (this.toBase != null) {
            throw new IllegalStateException(Errors.format((short)164, "subsamplings"));
        }
        GridExtent extent = this.baseExtent != null ? this.baseExtent : this.base.getExtent();
        MatrixSIS affine = null;
        int dimension = extent.getDimension();
        int i = Math.min(dimension, subsamplings.length);
        while (--i >= 0) {
            int s = subsamplings[i];
            if (s == 1) continue;
            if (affine == null) {
                affine = Matrices.createIdentity(dimension + 1);
                this.scaledExtent = extent.subsample(subsamplings);
            }
            double sd = s;
            affine.setElement(i, i, sd);
            affine.setElement(i, dimension, (double)extent.getLow(i) - (double)this.scaledExtent.getLow(i) * sd);
        }
        if (affine != null) {
            this.toBase = MathTransforms.linear(affine);
            if (this.scales == null) {
                this.scales = new double[dimension];
                for (i = 0; i < dimension; ++i) {
                    this.scales[i] = affine.getElement(i, i);
                }
            }
        }
        return this;
    }

    public GridDerivation slice(DirectPosition slicePoint) {
        ArgumentChecks.ensureNonNull("slicePoint", slicePoint);
        MathTransform gridToCRS = this.base.requireGridToCRS(true);
        this.subGridSetter = "slice";
        try {
            MathTransform baseToPOI;
            CoordinateReferenceSystem sliceCRS;
            if (this.toBase != null) {
                gridToCRS = MathTransforms.concatenate(this.toBase, gridToCRS);
            }
            if ((sliceCRS = slicePoint.getCoordinateReferenceSystem()) == null) {
                baseToPOI = null;
            } else {
                CoordinateReferenceSystem gridCRS = this.base.getCoordinateReferenceSystem();
                baseToPOI = CRS.findOperation(gridCRS, sliceCRS, null).getMathTransform();
                gridToCRS = MathTransforms.concatenate(gridToCRS, baseToPOI);
            }
            int dimension = gridToCRS.getTargetDimensions();
            ArgumentChecks.ensureDimensionMatches("slicePoint", dimension, slicePoint);
            gridToCRS = this.dropUnusedDimensions(gridToCRS, dimension);
            DirectPosition gridPoint = new WraparoundAdjustment(this.base.envelope, baseToPOI, gridToCRS.inverse()).shift(slicePoint);
            if (this.scaledExtent != null) {
                this.scaledExtent = this.scaledExtent.slice(gridPoint, this.modifiedDimensions);
            }
            if (this.toBase != null) {
                gridPoint = this.toBase.transform(gridPoint, gridPoint);
            }
            this.baseExtent = this.baseExtent.slice(gridPoint, this.modifiedDimensions);
        }
        catch (FactoryException e) {
            throw new IllegalGridGeometryException(Resources.format((short)24), e);
        }
        catch (TransformException e) {
            throw new IllegalGridGeometryException(e, "slicePoint");
        }
        this.modifiedDimensions = null;
        return this;
    }

    public GridDerivation sliceByRatio(double sliceRatio, int ... dimensionsToKeep) {
        ArgumentChecks.ensureBetween("sliceRatio", 0.0, 1.0, sliceRatio);
        ArgumentChecks.ensureNonNull("dimensionsToKeep", dimensionsToKeep);
        this.subGridSetter = "sliceByRatio";
        GridExtent extent = this.baseExtent != null ? this.baseExtent : this.base.getExtent();
        GeneralDirectPosition slicePoint = new GeneralDirectPosition(extent.getDimension());
        this.baseExtent = extent.sliceByRatio(slicePoint, sliceRatio, dimensionsToKeep);
        if (this.scaledExtent != null) {
            this.scaledExtent = this.scaledExtent.sliceByRatio(slicePoint, sliceRatio, dimensionsToKeep);
        }
        return this;
    }

    public GridGeometry build() {
        GridExtent extent;
        GridExtent gridExtent = extent = this.scaledExtent != null ? this.scaledExtent : this.baseExtent;
        if (this.toBase != null || extent != this.base.extent) {
            try {
                return new GridGeometry(this.base, extent, this.toBase);
            }
            catch (TransformException e) {
                throw new IllegalGridGeometryException(e, "envelope");
            }
        }
        return this.base;
    }

    public GridExtent getIntersection() {
        return this.baseExtent != null ? this.baseExtent : this.base.getExtent();
    }

    public int[] getSubsamplings() {
        int[] subsamplings;
        if (this.scales == null) {
            subsamplings = new int[this.getIntersection().getDimension()];
            Arrays.fill(subsamplings, 1);
        } else {
            subsamplings = new int[this.scales.length];
            for (int i = 0; i < subsamplings.length; ++i) {
                int s;
                switch (this.rounding) {
                    default: {
                        throw new AssertionError((Object)this.rounding);
                    }
                    case NEAREST: {
                        s = (int)Math.min(Math.round(this.scales[i]), Integer.MAX_VALUE);
                        break;
                    }
                    case ENCLOSING: {
                        s = (int)Math.nextUp(this.scales[i]);
                    }
                }
                subsamplings[i] = Math.max(1, s);
            }
        }
        return subsamplings;
    }

    public double getGlobalScale() {
        if (this.scales != null) {
            double sum = 0.0;
            int count = 0;
            for (double value : this.scales) {
                if (!Double.isFinite(value)) continue;
                sum += value;
                ++count;
            }
            if (count != 0) {
                return sum / (double)count;
            }
        }
        return 1.0;
    }

    private TreeTable toTree(Locale locale) {
        Object section;
        TableColumn<CharSequence> column = TableColumn.VALUE_AS_TEXT;
        DefaultTreeTable tree = new DefaultTreeTable(column);
        TreeTable.Node root = tree.getRoot();
        root.setValue(column, Classes.getShortClassName(this));
        StringBuilder buffer = new StringBuilder(256);
        if (this.baseExtent != null) {
            section = root.newChild();
            section.setValue(column, "Intersection");
            try {
                this.getIntersection().appendTo(buffer, Vocabulary.getResources(locale));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            CharSequence[] charSequenceArray = CharSequences.splitOnEOL(buffer);
            int n = charSequenceArray.length;
            for (int i = 0; i < n; ++i) {
                CharSequence line = charSequenceArray[i];
                String text = line.toString().trim();
                if (text.isEmpty()) continue;
                section.newChild().setValue(column, text);
            }
        }
        if (this.scales != null) {
            buffer.setLength(0);
            buffer.append('{');
            for (Object s : (Object)this.getSubsamplings()) {
                if (buffer.length() > 1) {
                    buffer.append(", ");
                }
                buffer.append((int)s);
            }
            section = root.newChild();
            section.setValue(column, "Subsamplings");
            section.newChild().setValue(column, buffer.append('}').toString());
            buffer.setLength(0);
            section.newChild().setValue(column, buffer.append("Global \u2248 ").append((float)this.getGlobalScale()).toString());
        }
        return tree;
    }

    public String toString() {
        return this.toTree(null).toString();
    }
}

