/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.io.BufferedReader;
import java.io.Console;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.sis.console.CommandRunner;
import org.apache.sis.internal.referencing.Fallback;
import org.apache.sis.internal.system.DataDirectory;
import org.apache.sis.internal.util.X364;
import org.apache.sis.setup.InstallationResources;
import org.apache.sis.util.resources.Errors;

@Fallback
public class ResourcesDownloader
extends InstallationResources {
    private static final String DOWNLOAD_URL = "http://repo1.maven.org/maven2/org/apache/sis/non-free/sis-epsg/1.0/sis-epsg-1.0.jar";
    private static final int DATABASE_SIZE = 20;
    private final Console console;
    private final Locale locale;
    private final boolean colors;
    private InstallationResources provider;
    private final Path directory;
    private final Map<String, Boolean> answers = new HashMap<String, Boolean>();
    private Boolean accepted;

    public ResourcesDownloader() {
        CommandRunner command = CommandRunner.instance;
        if (command != null) {
            this.locale = command.locale;
            this.colors = command.colors;
        } else {
            this.locale = Locale.getDefault();
            this.colors = false;
        }
        this.console = System.console();
        this.directory = DataDirectory.DATABASES.getDirectory();
    }

    @Override
    public Set<String> getAuthorities() {
        return this.console != null && this.directory != null ? Collections.singleton("EPSG") : Collections.emptySet();
    }

    private static InstallationResources download() throws IOException {
        for (InstallationResources c : ServiceLoader.load(InstallationResources.class, new URLClassLoader(new URL[]{new URL(DOWNLOAD_URL)}))) {
            if (c.getClass().isAnnotationPresent(Fallback.class) || !c.getAuthorities().contains("EPSG")) continue;
            return c;
        }
        throw new FileNotFoundException();
    }

    private synchronized InstallationResources provider(String authority, boolean requireAgreement) throws IOException {
        String resetColor;
        String actionColor;
        String linkOff;
        String linkColor;
        String textColor;
        if (!"EPSG".equals(authority)) {
            throw new IllegalArgumentException(Errors.format((short)45, "authority", authority));
        }
        ResourceBundle resources = ResourceBundle.getBundle("org.apache.sis.console.Messages", this.locale);
        if (this.answers.isEmpty()) {
            for (String r : resources.getString("yes").split("\\|")) {
                this.answers.put(r, Boolean.TRUE);
            }
            for (String r : resources.getString("no").split("\\|")) {
                this.answers.put(r, Boolean.FALSE);
            }
        }
        if (this.colors) {
            textColor = X364.FOREGROUND_YELLOW.sequence();
            linkColor = X364.UNDERLINE.sequence();
            linkOff = X364.NO_UNDERLINE.sequence();
            actionColor = X364.FOREGROUND_GREEN.sequence();
            resetColor = X364.FOREGROUND_DEFAULT.sequence();
        } else {
            resetColor = "";
            actionColor = "";
            linkOff = "";
            linkColor = "";
            textColor = "";
        }
        if (this.provider == null) {
            if (this.console == null) {
                throw new IllegalStateException();
            }
            this.console.format(resources.getString("install"), textColor, 20, linkColor, this.directory, linkOff, resetColor);
            if (!this.accept(resources.getString("download"), textColor, resetColor)) {
                this.console.format("%n", new Object[0]);
                throw new AccessDeniedException(null);
            }
            this.console.format(resources.getString("downloading"), actionColor, resetColor);
            this.provider = ResourcesDownloader.download();
        }
        if (requireAgreement && this.accepted == null) {
            String license = this.getLicense(authority, this.locale, "text/plain");
            if (license == null) {
                this.accepted = Boolean.TRUE;
            } else {
                this.console.format("%n", new Object[0]).writer().write(license);
                this.console.format("%n", new Object[0]);
                this.accepted = this.accept(resources.getString("accept"), textColor, resetColor);
                if (this.accepted.booleanValue()) {
                    this.console.format(resources.getString("installing"), actionColor, resetColor);
                }
            }
        }
        if (this.accepted != null && !this.accepted.booleanValue()) {
            throw new AccessDeniedException(null);
        }
        return this.provider;
    }

    private boolean accept(String prompt, Object ... arguments) {
        Boolean answer;
        while ((answer = this.answers.get(this.console.readLine(prompt, arguments).toLowerCase(this.locale))) == null) {
        }
        return answer;
    }

    @Override
    public String getLicense(String authority, Locale locale, String mimeType) throws IOException {
        return this.provider(authority, false).getLicense(authority, locale, mimeType);
    }

    @Override
    public String[] getResourceNames(String authority) throws IOException {
        return this.provider(authority, true).getResourceNames(authority);
    }

    @Override
    public Object getResource(String authority, int index) throws IOException {
        return this.provider(authority, true).getResource(authority, index);
    }

    @Override
    public BufferedReader openScript(String authority, int resource) throws IOException {
        return this.provider(authority, true).openScript(authority, resource);
    }
}

