/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.internal.storage.gpx.StoreProvider;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.DataStores;

enum OutputFormat {
    TEXT(null),
    WKT(null),
    XML(null),
    GPX(StoreProvider.class);

    private final Class<? extends DataStoreProvider> providerClass;

    private OutputFormat(Class<? extends DataStoreProvider> provider) {
        this.providerClass = provider;
    }

    final DataStoreProvider provider() throws InvalidOptionException {
        if (this.providerClass != null) {
            for (DataStoreProvider provider : DataStores.providers()) {
                if (!this.providerClass.isInstance(provider)) continue;
                return provider;
            }
        }
        return null;
    }
}

