/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.ResourceBundle;
import org.apache.sis.console.FormattedOutputCommand;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.MetadataCommand;
import org.apache.sis.console.Option;
import org.apache.sis.console.OutputFormat;
import org.apache.sis.internal.util.X364;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

final class IdentifierCommand
extends FormattedOutputCommand {
    private static EnumSet<Option> options() {
        EnumSet<Option> options = MetadataCommand.options();
        options.remove((Object)Option.TIMEZONE);
        options.remove((Object)Option.FORMAT);
        return options;
    }

    IdentifierCommand(int commandIndex, String ... args) throws InvalidOptionException {
        super(commandIndex, args, IdentifierCommand.options(), OutputFormat.TEXT);
    }

    @Override
    public int run() throws Exception {
        Object metadata = this.readMetadataOrCRS();
        if (this.hasUnexpectedFileCount) {
            return 3;
        }
        if (metadata != null) {
            ArrayList<Row> rows;
            if (metadata instanceof DefaultMetadata) {
                rows = new ArrayList();
                Identifier id = ((DefaultMetadata)metadata).getMetadataIdentifier();
                if (id instanceof DefaultIdentifier) {
                    Object desc = ((DefaultIdentifier)id).getDescription();
                    if (desc != null && !this.files.isEmpty()) {
                        desc = (CharSequence)this.files.get(0);
                    }
                    rows.add(new Row(State.VALID, IdentifiedObjects.toString(id), (CharSequence)desc));
                }
                for (ReferenceSystem rs : ((Metadata)metadata).getReferenceSystemInfo()) {
                    rows.add(IdentifierCommand.create(rs));
                }
            } else {
                rows = Collections.singletonList(IdentifierCommand.create((ReferenceSystem)metadata));
            }
            this.print(rows);
        }
        return 0;
    }

    static Row create(ReferenceSystem rs) throws FactoryException {
        State state;
        Object c;
        Object identifier = IdentifiedObjects.lookupURN((IdentifiedObject)rs, null);
        if (identifier == null) {
            for (Identifier id : rs.getIdentifiers()) {
                c = IdentifiedObjects.toURN(rs.getClass(), id);
                if (c != null) {
                    identifier = c;
                    break;
                }
                if (identifier != null) continue;
                identifier = IdentifiedObjects.toString(id);
            }
            if (identifier == null) {
                return null;
            }
        }
        try {
            CoordinateReferenceSystem def = CRS.forCode(identifier);
            c = ComparisonMode.equalityLevel(def, rs);
            if (c == null) {
                state = State.MISMATCH;
            } else {
                switch (c) {
                    case ALLOW_VARIANT: {
                        state = State.AXIS_ORDER;
                        break;
                    }
                    case APPROXIMATE: {
                        state = State.APPROXIMATE;
                        rs = def;
                        break;
                    }
                    default: {
                        state = State.VALID;
                        rs = def;
                    }
                }
            }
        }
        catch (NoSuchAuthorityCodeException e) {
            state = State.UNKNOWN;
        }
        return new Row(state, (String)identifier, rs.getName().getCode());
    }

    private void print(Iterable<Row> rows) throws IOException {
        int width = 0;
        for (Row row : rows) {
            if (row == null) continue;
            width = Math.max(width, row.identifier.length());
        }
        width += 4;
        EnumSet<State> states = EnumSet.noneOf(State.class);
        for (Row row : rows) {
            boolean warning;
            if (row == null) continue;
            states.add(row.state);
            boolean bl = warning = this.colors && row.state.text.startsWith("!");
            if (warning) {
                this.out.print(X364.FOREGROUND_RED.sequence());
            }
            this.out.print(row.state.text);
            this.out.print(' ');
            this.out.print(row.identifier);
            if (warning) {
                this.out.print(X364.FOREGROUND_DEFAULT.sequence());
            }
            if (this.colors) {
                this.out.print(X364.FOREGROUND_GRAY.sequence());
            }
            this.out.print(CharSequences.spaces(width - row.identifier.length()));
            this.out.print("| ");
            this.out.println(row.description);
            if (!this.colors) continue;
            this.out.print(X364.FOREGROUND_DEFAULT.sequence());
        }
        states.remove((Object)State.VALID);
        if (!states.isEmpty()) {
            this.out.println();
            Vocabulary.getResources(this.locale).appendLabel((short)58, this.out);
            this.out.println();
            ResourceBundle resourceBundle = ResourceBundle.getBundle("org.apache.sis.console.IdentifierState", this.locale);
            for (State state : states) {
                boolean warning;
                boolean bl = warning = this.colors && state.text.startsWith("!");
                if (warning) {
                    this.out.print(X364.FOREGROUND_RED.sequence());
                }
                this.out.print(state.text);
                if (warning) {
                    this.out.print(X364.FOREGROUND_DEFAULT.sequence());
                }
                this.out.print(' ');
                this.out.println(resourceBundle.getString(state.name()));
            }
        }
        this.out.flush();
    }

    private static class Row {
        final State state;
        final String identifier;
        final CharSequence description;

        Row(State state, String identifier, CharSequence description) {
            this.state = state;
            this.identifier = identifier;
            this.description = description;
        }
    }

    private static enum State {
        VALID("   "),
        APPROXIMATE("~  "),
        AXIS_ORDER("!  "),
        MISMATCH("!! "),
        UNKNOWN("?  ");

        final String text;

        private State(String p) {
            this.text = p;
        }
    }
}

