/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.io.Console;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.EnumSet;
import java.util.Locale;
import java.util.function.Predicate;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.sis.console.CommandRunner;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.Option;
import org.apache.sis.console.OutputFormat;
import org.apache.sis.internal.storage.CodeType;
import org.apache.sis.internal.storage.gpx.Store;
import org.apache.sis.io.wkt.Colors;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.measure.Range;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.referencing.CRS;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.DataStores;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Version;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.collection.TreeTableFormat;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.MarshallerPool;
import org.opengis.metadata.Metadata;
import org.opengis.util.FactoryException;

abstract class FormattedOutputCommand
extends CommandRunner {
    private final OutputFormat outputFormat;
    Convention convention;
    private Version version;
    private final DataStoreProvider provider;
    boolean hasUnexpectedFileCount;

    FormattedOutputCommand(int commandIndex, String[] arguments, EnumSet<Option> validOptions, OutputFormat ... supportedFormats) throws InvalidOptionException {
        super(commandIndex, arguments, validOptions);
        boolean isVersionSupported = true;
        String format = (String)this.options.get((Object)Option.FORMAT);
        if (format == null) {
            this.outputFormat = supportedFormats[0];
            this.convention = Convention.WKT2_SIMPLIFIED;
        } else if (format.equalsIgnoreCase("WKT1")) {
            this.outputFormat = OutputFormat.WKT;
            this.convention = Convention.WKT1;
        } else if (format.equalsIgnoreCase("WKT2")) {
            this.outputFormat = OutputFormat.WKT;
            this.convention = Convention.WKT2;
        } else {
            int s = format.indexOf(45);
            String fmtEnum = format;
            if (s > 0) {
                fmtEnum = format.substring(0, s);
                this.version = new Version(format.substring(s + 1).trim());
            }
            fmtEnum = fmtEnum.toUpperCase(Locale.US);
            try {
                this.outputFormat = OutputFormat.valueOf(fmtEnum);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidOptionException(Errors.format((short)56, "format", format), e, "format");
            }
        }
        if (!ArraysExt.contains((Object[])supportedFormats, (Object)this.outputFormat)) {
            throw new InvalidOptionException(Errors.format((short)62, this.commandName, (Object)this.outputFormat), "format");
        }
        this.provider = this.outputFormat.provider();
        switch (this.outputFormat) {
            case WKT: {
                if (this.convention != null) break;
                if (this.version == null || this.version.equals(Version.valueOf(2))) {
                    this.convention = Convention.WKT2;
                    break;
                }
                this.convention = Convention.WKT1;
                isVersionSupported = this.version.equals(Version.valueOf(1));
                break;
            }
            default: {
                if (this.version == null || !(isVersionSupported = this.provider != null)) break;
                Range<Version> supportedVersions = this.provider.getSupportedVersions();
                boolean bl = isVersionSupported = supportedVersions != null && supportedVersions.contains(this.version);
            }
        }
        if (!isVersionSupported) {
            throw new InvalidOptionException(Errors.format((short)159, this.outputFormat.name(), this.version), "format");
        }
    }

    final Object readMetadataOrCRS() throws DataStoreException, FactoryException {
        if (this.useStandardInput()) {
            try (DataStore store = DataStores.open(System.in);){
                Metadata metadata = store.getMetadata();
                return metadata;
            }
        }
        if (this.hasUnexpectedFileCount(1, 1)) {
            this.hasUnexpectedFileCount = true;
            return null;
        }
        String file = (String)this.files.get(0);
        if (CodeType.guess((String)file).isCRS) {
            return CRS.forCode(file);
        }
        try (DataStore store = DataStores.open(file);){
            Metadata metadata = store.getMetadata();
            return metadata;
        }
    }

    final void format(Object object) throws DataStoreException, JAXBException, IOException {
        switch (this.outputFormat) {
            case TEXT: {
                TreeTable tree = MetadataStandard.ISO_19115.asTreeTable(object, object instanceof Metadata ? Metadata.class : null, ValueExistencePolicy.COMPACT);
                TreeTableFormat tf = new TreeTableFormat(this.locale, this.timezone);
                tf.setColumns(TableColumn.NAME, TableColumn.VALUE);
                tf.setNodeFilter(this.getNodeFilter());
                tf.format(tree, (Appendable)this.out);
                break;
            }
            case WKT: {
                WKTFormat f = new WKTFormat(this.locale, this.timezone);
                if (this.convention != null) {
                    f.setConvention(this.convention);
                }
                if (this.colors) {
                    f.setColors(Colors.DEFAULT);
                }
                f.format(object, (Appendable)this.out);
                this.out.println();
                break;
            }
            case XML: {
                MarshallerPool pool = new MarshallerPool(null);
                Marshaller marshaller = pool.acquireMarshaller();
                marshaller.setProperty("org.apache.sis.xml.locale", (Object)this.locale);
                marshaller.setProperty("org.apache.sis.xml.timezone", (Object)this.timezone);
                if (this.isConsole()) {
                    marshaller.marshal(object, (Writer)this.out);
                    break;
                }
                this.out.flush();
                marshaller.setProperty("jaxb.encoding", (Object)this.encoding.name());
                marshaller.marshal(object, (OutputStream)System.out);
                System.out.flush();
                break;
            }
            default: {
                StorageConnector connector = new StorageConnector(this.out);
                connector.setOption(OptionKey.TIMEZONE, this.timezone);
                connector.setOption(OptionKey.LOCALE, this.locale);
                connector.setOption(OptionKey.ENCODING, this.encoding);
                try (DataStore store = this.provider.open(connector);){
                    Store fs = (Store)store;
                    if (this.version != null) {
                        fs.setVersion(this.version);
                    }
                    fs.write(object instanceof Metadata ? (Metadata)object : null, null);
                    break;
                }
            }
        }
        this.out.flush();
    }

    Predicate<TreeTable.Node> getNodeFilter() {
        return null;
    }

    private boolean isConsole() {
        if (this.outputBuffer != null) {
            return true;
        }
        Console console = System.console();
        return console != null && console.writer() == this.out;
    }
}

