/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.Affine;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

abstract class AbstractLinearTransform
extends AbstractMathTransform
implements LinearTransform,
Matrix,
Serializable {
    private static final long serialVersionUID = -4649708313541868599L;
    volatile LinearTransform inverse;

    AbstractLinearTransform() {
    }

    @Override
    public boolean isAffine() {
        return Matrices.isAffine(this);
    }

    public final Matrix clone() {
        return Matrices.copy(this);
    }

    @Override
    public final Matrix getMatrix() {
        return this;
    }

    public int getNumRow() {
        return this.getTargetDimensions() + 1;
    }

    public int getNumCol() {
        return this.getSourceDimensions() + 1;
    }

    @Override
    protected final MathTransform tryConcatenate(boolean bl, MathTransform mathTransform, MathTransformFactory mathTransformFactory) throws FactoryException {
        if (mathTransform instanceof LinearTransform) {
            return super.tryConcatenate(bl, mathTransform, mathTransformFactory);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinearTransform inverse() throws NoninvertibleTransformException {
        LinearTransform linearTransform = this.inverse;
        if (linearTransform == null) {
            AbstractLinearTransform abstractLinearTransform = this;
            synchronized (abstractLinearTransform) {
                linearTransform = this.inverse;
                if (linearTransform == null) {
                    if (this.isIdentity()) {
                        linearTransform = this;
                    } else {
                        linearTransform = MathTransforms.linear(Matrices.inverse(this));
                        if (linearTransform instanceof AbstractLinearTransform) {
                            ((AbstractLinearTransform)linearTransform).inverse = this;
                        }
                    }
                    this.inverse = linearTransform;
                }
            }
        }
        return linearTransform;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Affine.getProvider(this.getSourceDimensions(), this.getTargetDimensions(), this.isAffine()).getParameters();
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return Affine.parameters(this);
    }

    public final void setElement(int n, int n2, double d) {
        throw new UnsupportedOperationException(this.isAffine() ? Resources.format((short)68) : Errors.format((short)153, AbstractLinearTransform.class));
    }

    @Override
    public void deltaTransform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        double[] dArray3 = null;
        int n7 = n5 = this.getSourceDimensions();
        int n8 = n4 = this.getTargetDimensions();
        if (dArray == dArray2) {
            switch (IterationStrategy.suggest(n, n5, n2, n4, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * n5;
                    n7 = -n7;
                    n2 += (n3 - 1) * n4;
                    n8 = -n8;
                    break;
                }
                default: {
                    dArray = Arrays.copyOfRange(dArray, n, n + n3 * n5);
                    n = 0;
                    break;
                }
                case BUFFER_TARGET: {
                    dArray3 = dArray2;
                    dArray2 = new double[n3 * n8];
                    n6 = n2;
                    n2 = 0;
                }
            }
        }
        double[] dArray4 = new double[n4];
        while (--n3 >= 0) {
            for (int i = 0; i < n4; ++i) {
                double d = 0.0;
                for (int j = 0; j < n5; ++j) {
                    double d2 = this.getElement(i, j);
                    if (d2 == 0.0) continue;
                    d += dArray[n + j] * d2;
                }
                dArray4[i] = d;
            }
            System.arraycopy(dArray4, 0, dArray2, n2, n4);
            n += n7;
            n2 += n8;
        }
        if (dArray3 != null) {
            System.arraycopy(dArray2, 0, dArray3, n6, dArray2.length);
        }
    }

    protected abstract boolean equalsSameClass(Object var1);

    @Override
    public final boolean equals(Object object, ComparisonMode comparisonMode) {
        Matrix matrix;
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        boolean bl = comparisonMode.isApproximate();
        if (!bl && this.getClass() == object.getClass()) {
            if (!this.equalsSameClass(object)) {
                return false;
            }
        } else {
            if (comparisonMode == ComparisonMode.STRICT) {
                return false;
            }
            if (object instanceof LinearTransform) {
                matrix = ((LinearTransform)object).getMatrix();
            } else if (object instanceof Matrix) {
                matrix = (Matrix)object;
            } else {
                return false;
            }
            if (!Matrices.equals(this, matrix, comparisonMode)) {
                return false;
            }
        }
        if (object instanceof AbstractLinearTransform && this.inverse == ((AbstractLinearTransform)object).inverse) {
            return true;
        }
        matrix = null;
        Matrix matrix2 = null;
        try {
            matrix = this.inverse().getMatrix();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        try {
            if (object instanceof LinearTransform) {
                matrix2 = ((LinearTransform)object).inverse().getMatrix();
            } else if (object instanceof Matrix) {
                matrix2 = Matrices.inverse((Matrix)object);
            }
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return Matrices.equals(matrix, matrix2, bl ? 1.0E-13 : 0.0, bl);
    }

    @Override
    public String toString() {
        return Matrices.toString(this);
    }
}

