/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.LazySet;
import org.apache.sis.internal.referencing.MergedProperties;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.SpecializedOperationFactory;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.AbstractSingleOperation;
import org.apache.sis.referencing.operation.CRSPair;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.CoordinateOperationFinder;
import org.apache.sis.referencing.operation.DefaultConcatenatedOperation;
import org.apache.sis.referencing.operation.DefaultConicProjection;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.referencing.operation.DefaultCylindricalProjection;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.DefaultPlanarProjection;
import org.apache.sis.referencing.operation.DefaultProjection;
import org.apache.sis.referencing.operation.DefaultTransformation;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.iso.AbstractFactory;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.PlanarProjection;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

public class DefaultCoordinateOperationFactory
extends AbstractFactory
implements CoordinateOperationFactory {
    static final boolean USE_EPSG_FACTORY = true;
    private final Map<String, ?> defaultProperties;
    private volatile CRSFactory crsFactory;
    private volatile CSFactory csFactory;
    private volatile MathTransformFactory mtFactory;
    private volatile SpecializedOperationFactory[] specializedFactories;
    private final WeakHashSet<IdentifiedObject> pool;
    final Cache<CRSPair, CoordinateOperation> cache;

    public DefaultCoordinateOperationFactory() {
        this(null, null);
    }

    public DefaultCoordinateOperationFactory(Map<String, ?> map, MathTransformFactory mathTransformFactory) {
        if (map == null || map.isEmpty()) {
            map = Collections.emptyMap();
        } else {
            String string = null;
            Object object = null;
            map = new HashMap(map);
            try {
                string = "crsFactory";
                object = map.remove("crsFactory");
                this.crsFactory = (CRSFactory)object;
                string = "csFactory";
                object = map.remove("csFactory");
                this.csFactory = (CSFactory)object;
                string = "mtFactory";
                object = map.remove("mtFactory");
                this.mtFactory = (MathTransformFactory)object;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(Errors.getResources(map).getString((short)58, string, Classes.getClass(object)));
            }
            map.remove("datumFactory");
            map = CollectionsExt.compact(map);
        }
        this.defaultProperties = map;
        if (mathTransformFactory != null) {
            this.mtFactory = mathTransformFactory;
        }
        this.pool = new WeakHashSet<IdentifiedObject>(IdentifiedObject.class);
        this.cache = new Cache(12, 50L, true);
    }

    protected Map<String, ?> complete(Map<String, ?> map) {
        ArgumentChecks.ensureNonNull("properties", map);
        return new MergedProperties(map, this.defaultProperties);
    }

    final CRSFactory getCRSFactory() {
        CRSFactory cRSFactory = this.crsFactory;
        if (cRSFactory == null) {
            this.crsFactory = cRSFactory = DefaultFactories.forBuildin(CRSFactory.class);
        }
        return cRSFactory;
    }

    final CSFactory getCSFactory() {
        CSFactory cSFactory = this.csFactory;
        if (cSFactory == null) {
            this.csFactory = cSFactory = DefaultFactories.forBuildin(CSFactory.class);
        }
        return cSFactory;
    }

    final MathTransformFactory getMathTransformFactory() {
        MathTransformFactory mathTransformFactory = this.mtFactory;
        if (mathTransformFactory == null) {
            this.mtFactory = mathTransformFactory = DefaultFactories.forBuildin(MathTransformFactory.class);
        }
        return mathTransformFactory;
    }

    final DefaultMathTransformFactory getDefaultMathTransformFactory() {
        MathTransformFactory mathTransformFactory = this.getMathTransformFactory();
        if (mathTransformFactory instanceof DefaultMathTransformFactory) {
            return (DefaultMathTransformFactory)mathTransformFactory;
        }
        return DefaultFactories.forBuildin(MathTransformFactory.class, DefaultMathTransformFactory.class);
    }

    final SpecializedOperationFactory[] getSpecializedFactories() {
        SpecializedOperationFactory[] specializedOperationFactoryArray = this.specializedFactories;
        if (specializedOperationFactoryArray == null) {
            LazySet<SpecializedOperationFactory> lazySet = new LazySet<SpecializedOperationFactory>(ServiceLoader.load(SpecializedOperationFactory.class).iterator());
            specializedOperationFactoryArray = lazySet.toArray(new SpecializedOperationFactory[lazySet.size()]);
            this.specializedFactories = specializedOperationFactoryArray;
        }
        return specializedOperationFactoryArray;
    }

    public OperationMethod getOperationMethod(String string) throws FactoryException {
        string = CharSequences.trimWhitespaces(string);
        ArgumentChecks.ensureNonEmpty("name", string);
        MathTransformFactory mathTransformFactory = this.getMathTransformFactory();
        if (mathTransformFactory instanceof DefaultMathTransformFactory) {
            return ((DefaultMathTransformFactory)mathTransformFactory).getOperationMethod(string);
        }
        OperationMethod operationMethod = CoordinateOperations.getOperationMethod(mathTransformFactory.getAvailableMethods(SingleOperation.class), string);
        if (operationMethod != null) {
            return operationMethod;
        }
        throw new NoSuchIdentifierException(Resources.forProperties(this.defaultProperties).getString((short)50, string), string);
    }

    public OperationMethod createOperationMethod(Map<String, ?> map, Integer n, Integer n2, ParameterDescriptorGroup parameterDescriptorGroup) throws FactoryException {
        DefaultOperationMethod defaultOperationMethod;
        try {
            defaultOperationMethod = new DefaultOperationMethod(map, n, n2, parameterDescriptorGroup);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException.getLocalizedMessage(), illegalArgumentException);
        }
        return this.pool.unique(defaultOperationMethod);
    }

    public Conversion createDefiningConversion(Map<String, ?> map, OperationMethod operationMethod, ParameterValueGroup parameterValueGroup) throws FactoryException {
        DefaultConversion defaultConversion;
        try {
            defaultConversion = new DefaultConversion(map, operationMethod, null, parameterValueGroup);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException.getLocalizedMessage(), illegalArgumentException);
        }
        return defaultConversion;
    }

    private static boolean isConversion(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        int n;
        List<SingleCRS> list = CRS.getSingleComponents(coordinateReferenceSystem);
        int n2 = list.size();
        Datum[] datumArray = new Datum[n2];
        for (n = 0; n < n2; ++n) {
            datumArray[n] = list.get(n).getDatum();
        }
        list = CRS.getSingleComponents(coordinateReferenceSystem2);
        n = list.size();
        block1: while (--n >= 0) {
            Datum datum = list.get(n).getDatum();
            int n3 = n2;
            while (--n3 >= 0) {
                if (!Utilities.equalsIgnoreMetadata(datum, datumArray[n3])) continue;
                System.arraycopy(datumArray, n3 + 1, datumArray, n3, --n2 - n3);
                continue block1;
            }
            return false;
        }
        return true;
    }

    public SingleOperation createSingleOperation(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, CoordinateReferenceSystem coordinateReferenceSystem3, OperationMethod operationMethod, MathTransform mathTransform) throws FactoryException {
        Serializable serializable;
        Object object;
        ArgumentChecks.ensureNonNull("sourceCRS", coordinateReferenceSystem);
        ArgumentChecks.ensureNonNull("targetCRS", coordinateReferenceSystem2);
        ArgumentChecks.ensureNonNull("method", operationMethod);
        if (mathTransform == null) {
            object = Containers.property(map, "parameters", ParameterValueGroup.class);
            if (object == null) {
                throw new NullArgumentException(Errors.format((short)113, "transform"));
            }
            mathTransform = this.getMathTransformFactory().createBaseToDerived(coordinateReferenceSystem, (ParameterValueGroup)object, coordinateReferenceSystem2.getCoordinateSystem());
        }
        if ((object = Containers.property(map, "operationType", Class.class)) == null) {
            object = SingleOperation.class;
        }
        if (operationMethod instanceof DefaultOperationMethod && (serializable = ((DefaultOperationMethod)operationMethod).getOperationType()) != null) {
            if (((Class)object).isAssignableFrom((Class<?>)serializable)) {
                object = serializable;
            } else if (!((Class)serializable).isAssignableFrom((Class<?>)object)) {
                throw new IllegalArgumentException(Errors.format((short)63, "operationType"));
            }
        }
        if (object == SingleOperation.class) {
            object = DefaultCoordinateOperationFactory.isConversion(coordinateReferenceSystem, coordinateReferenceSystem2) ? (coordinateReferenceSystem3 == null && coordinateReferenceSystem instanceof GeographicCRS && coordinateReferenceSystem2 instanceof ProjectedCRS ? Projection.class : Conversion.class) : Transformation.class;
        }
        if (Transformation.class.isAssignableFrom((Class<?>)object)) {
            serializable = new DefaultTransformation(map, coordinateReferenceSystem, coordinateReferenceSystem2, coordinateReferenceSystem3, operationMethod, mathTransform);
        } else if (Projection.class.isAssignableFrom((Class<?>)object)) {
            ArgumentChecks.ensureCanCast("sourceCRS", GeographicCRS.class, coordinateReferenceSystem);
            ArgumentChecks.ensureCanCast("targetCRS", ProjectedCRS.class, coordinateReferenceSystem2);
            if (coordinateReferenceSystem3 != null) {
                throw new IllegalArgumentException(Errors.format((short)40, "interpolationCRS", object));
            }
            GeographicCRS geographicCRS = (GeographicCRS)coordinateReferenceSystem;
            ProjectedCRS projectedCRS = (ProjectedCRS)coordinateReferenceSystem2;
            serializable = CylindricalProjection.class.isAssignableFrom((Class<?>)object) ? new DefaultCylindricalProjection(map, geographicCRS, projectedCRS, operationMethod, mathTransform) : (ConicProjection.class.isAssignableFrom((Class<?>)object) ? new DefaultConicProjection(map, geographicCRS, projectedCRS, operationMethod, mathTransform) : (PlanarProjection.class.isAssignableFrom((Class<?>)object) ? new DefaultPlanarProjection(map, geographicCRS, projectedCRS, operationMethod, mathTransform) : new DefaultProjection(map, geographicCRS, projectedCRS, operationMethod, mathTransform)));
        } else {
            serializable = Conversion.class.isAssignableFrom((Class<?>)object) ? new DefaultConversion(map, coordinateReferenceSystem, coordinateReferenceSystem2, coordinateReferenceSystem3, operationMethod, mathTransform) : new AbstractSingleOperation(map, coordinateReferenceSystem, coordinateReferenceSystem2, coordinateReferenceSystem3, operationMethod, mathTransform);
        }
        if (!((Class)object).isInstance(serializable)) {
            throw new FactoryException(Resources.format((short)4, object, ((AbstractIdentifiedObject)serializable).getName()));
        }
        return (SingleOperation)this.pool.unique(serializable);
    }

    public CoordinateOperation createConcatenatedOperation(Map<String, ?> map, CoordinateOperation ... coordinateOperationArray) throws FactoryException {
        DefaultConcatenatedOperation defaultConcatenatedOperation;
        if (coordinateOperationArray != null && coordinateOperationArray.length == 1) {
            return coordinateOperationArray[0];
        }
        try {
            defaultConcatenatedOperation = new DefaultConcatenatedOperation(map, coordinateOperationArray, this.getMathTransformFactory());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidGeodeticParameterException(illegalArgumentException.getLocalizedMessage(), illegalArgumentException);
        }
        List list = defaultConcatenatedOperation.getOperations();
        if (list.size() != 1) {
            return this.pool.unique(defaultConcatenatedOperation);
        }
        CoordinateOperation coordinateOperation = (CoordinateOperation)list.get(0);
        assert (defaultConcatenatedOperation.getMathTransform().equals(coordinateOperation.getMathTransform())) : defaultConcatenatedOperation;
        if (!(Objects.equals(coordinateOperation.getSourceCRS(), defaultConcatenatedOperation.getSourceCRS()) && Objects.equals(coordinateOperation.getTargetCRS(), defaultConcatenatedOperation.getTargetCRS()) || !(coordinateOperation instanceof SingleOperation))) {
            HashMap hashMap = new HashMap(IdentifiedObjects.getProperties((IdentifiedObject)coordinateOperation, "identifiers"));
            hashMap.put("parameters", ((SingleOperation)coordinateOperation).getParameterValues());
            if (coordinateOperation instanceof AbstractIdentifiedObject) {
                hashMap.put("operationType", ((AbstractIdentifiedObject)coordinateOperation).getInterface());
            }
            hashMap.putAll(map);
            return this.createSingleOperation(hashMap, defaultConcatenatedOperation.getSourceCRS(), defaultConcatenatedOperation.getTargetCRS(), AbstractCoordinateOperation.getInterpolationCRS(defaultConcatenatedOperation), ((SingleOperation)coordinateOperation).getMethod(), coordinateOperation.getMathTransform());
        }
        return coordinateOperation;
    }

    public CoordinateOperation createOperation(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws OperationNotFoundException, FactoryException {
        return this.createOperation(coordinateReferenceSystem, coordinateReferenceSystem2, (CoordinateOperationContext)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoordinateOperation createOperation(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, CoordinateOperationContext coordinateOperationContext) throws OperationNotFoundException, FactoryException {
        Cache.Handler<CoordinateOperation> handler;
        CoordinateOperation coordinateOperation;
        CRSPair cRSPair;
        if (coordinateOperationContext == null) {
            cRSPair = new CRSPair(coordinateReferenceSystem, coordinateReferenceSystem2);
            coordinateOperation = this.cache.peek(cRSPair);
            if (coordinateOperation != null) {
                return coordinateOperation;
            }
            handler = this.cache.lock(cRSPair);
        } else {
            handler = null;
            coordinateOperation = null;
        }
        try {
            if (handler == null || (coordinateOperation = (CoordinateOperation)handler.peek()) == null) {
                cRSPair = CRS.getAuthorityFactory("EPSG");
                coordinateOperation = this.createOperationFinder(cRSPair instanceof CoordinateOperationAuthorityFactory ? (CoordinateOperationAuthorityFactory)cRSPair : null, coordinateOperationContext).createOperation(coordinateReferenceSystem, coordinateReferenceSystem2);
            }
        }
        finally {
            if (handler != null) {
                handler.putAndUnlock(coordinateOperation);
            }
        }
        return coordinateOperation;
    }

    public List<CoordinateOperation> createOperations(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, CoordinateOperationContext coordinateOperationContext) throws OperationNotFoundException, FactoryException {
        CRSAuthorityFactory cRSAuthorityFactory = CRS.getAuthorityFactory("EPSG");
        return this.createOperationFinder(cRSAuthorityFactory instanceof CoordinateOperationAuthorityFactory ? (CoordinateOperationAuthorityFactory)cRSAuthorityFactory : null, coordinateOperationContext).createOperations(coordinateReferenceSystem, coordinateReferenceSystem2);
    }

    protected CoordinateOperationFinder createOperationFinder(CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory, CoordinateOperationContext coordinateOperationContext) throws FactoryException {
        return new CoordinateOperationFinder(coordinateOperationAuthorityFactory, this, coordinateOperationContext);
    }

    @Deprecated
    public CoordinateOperation createOperation(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, OperationMethod operationMethod) throws FactoryException {
        ArgumentChecks.ensureNonNull("method", operationMethod);
        return this.createOperation(coordinateReferenceSystem, coordinateReferenceSystem2, (CoordinateOperationContext)null);
    }
}

