/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.Collections;
import java.util.Map;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.cs.AxisFilter;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.util.Utilities;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.Projection;
import org.opengis.util.FactoryException;

final class EllipsoidalHeightSeparator
implements AxisFilter {
    private final GeodeticDatum datum;
    private boolean vertical;

    EllipsoidalHeightSeparator(GeodeticDatum geodeticDatum) {
        this.datum = geodeticDatum;
    }

    @Override
    public boolean accept(CoordinateSystemAxis coordinateSystemAxis) {
        return AxisDirections.isVertical(coordinateSystemAxis.getDirection()) == this.vertical;
    }

    private static CRSFactory factory() {
        return DefaultFactories.forBuildin(CRSFactory.class);
    }

    private static Map<String, ?> properties(SingleCRS singleCRS) {
        return Collections.singletonMap("name", singleCRS.getName());
    }

    SingleCRS separate(SingleCRS singleCRS, boolean bl) throws FactoryException {
        this.vertical = bl;
        CoordinateSystem coordinateSystem = CoordinateSystems.replaceAxes(singleCRS.getCoordinateSystem(), this);
        if (bl) {
            VerticalCRS verticalCRS = CommonCRS.Vertical.ELLIPSOIDAL.crs();
            if (!Utilities.equalsIgnoreMetadata(verticalCRS.getCoordinateSystem(), coordinateSystem)) {
                verticalCRS = EllipsoidalHeightSeparator.factory().createVerticalCRS(EllipsoidalHeightSeparator.properties((SingleCRS)verticalCRS), verticalCRS.getDatum(), (VerticalCS)coordinateSystem);
            }
            return verticalCRS;
        }
        if (singleCRS instanceof GeographicCRS) {
            CommonCRS commonCRS;
            CommonCRS commonCRS2 = CommonCRS.WGS84;
            if (Utilities.equalsIgnoreMetadata(commonCRS2.geographic().getCoordinateSystem(), coordinateSystem)) {
                CommonCRS commonCRS3 = CommonCRS.forDatum(this.datum);
                if (commonCRS3 != null) {
                    return commonCRS3.geographic();
                }
            } else if (Utilities.equalsIgnoreMetadata(commonCRS2.normalizedGeographic().getCoordinateSystem(), coordinateSystem) && (commonCRS = CommonCRS.forDatum(this.datum)) != null) {
                return commonCRS.normalizedGeographic();
            }
            return EllipsoidalHeightSeparator.factory().createGeographicCRS(EllipsoidalHeightSeparator.properties(singleCRS), this.datum, (EllipsoidalCS)coordinateSystem);
        }
        if (singleCRS instanceof ProjectedCRS) {
            GeographicCRS geographicCRS = ((ProjectedCRS)singleCRS).getBaseCRS();
            if (ReferencingUtilities.getDimension((CoordinateReferenceSystem)geographicCRS) != 2) {
                geographicCRS = (GeographicCRS)this.separate((SingleCRS)geographicCRS, false);
            }
            Projection projection = ((ProjectedCRS)singleCRS).getConversionFromBase();
            return EllipsoidalHeightSeparator.factory().createProjectedCRS(EllipsoidalHeightSeparator.properties(singleCRS), geographicCRS, (Conversion)projection, (CartesianCS)coordinateSystem);
        }
        throw new IllegalArgumentException();
    }
}

