/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.Closeable;
import java.io.Console;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import javax.measure.Unit;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.X364;
import org.apache.sis.io.TableAppender;
import org.apache.sis.io.TabularFormat;
import org.apache.sis.io.wkt.Colors;
import org.apache.sis.measure.Range;
import org.apache.sis.parameter.ParameterTableRow;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.GenericName;

public class ParameterFormat
extends TabularFormat<Object> {
    private static final long serialVersionUID = -1345231739800152411L;
    private static final AtomicReference<ParameterFormat> INSTANCE = new AtomicReference();
    private static final String SEPARATOR = " \u2502 ";
    private final Locale displayLocale;
    private ContentLevel contentLevel = ContentLevel.BRIEF;
    private Set<String> preferredCodespaces;
    private Colors colors;

    public ParameterFormat() {
        super(Locale.getDefault(Locale.Category.FORMAT), TimeZone.getDefault());
        this.displayLocale = Locale.getDefault(Locale.Category.DISPLAY);
        this.columnSeparator = SEPARATOR;
    }

    public ParameterFormat(Locale locale, TimeZone timeZone) {
        super(locale, timeZone);
        this.displayLocale = locale != null ? locale : Locale.ROOT;
        this.columnSeparator = SEPARATOR;
    }

    @Override
    public final Class<Object> getValueType() {
        return Object.class;
    }

    @Override
    public Locale getLocale(Locale.Category category) {
        return category == Locale.Category.DISPLAY ? this.displayLocale : super.getLocale(category);
    }

    public ContentLevel getContentLevel() {
        return this.contentLevel;
    }

    public void setContentLevel(ContentLevel contentLevel) {
        ArgumentChecks.ensureNonNull("level", (Object)contentLevel);
        this.contentLevel = contentLevel;
    }

    public String[] getPreferredCodespaces() {
        Set<String> set = this.preferredCodespaces;
        return set != null ? set.toArray(new String[set.size()]) : null;
    }

    public void setPreferredCodespaces(String ... stringArray) {
        Set<String> set = null;
        if (stringArray != null) {
            set = CollectionsExt.immutableSet(true, stringArray);
        }
        this.preferredCodespaces = set;
    }

    private boolean isPreferredCodespace(String string) {
        Set<String> set = this.preferredCodespaces;
        return set == null || set.contains(string);
    }

    public Colors getColors() {
        return this.colors;
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    private void nextColumn(TableAppender tableAppender) {
        tableAppender.append(this.beforeFill);
        tableAppender.nextColumn(this.fillCharacter);
    }

    @Override
    public void format(Object object, Appendable appendable) throws IOException {
        Object object2;
        ReferenceIdentifier referenceIdentifier;
        ParameterDescriptorGroup parameterDescriptorGroup;
        ParameterValueGroup parameterValueGroup;
        boolean bl;
        ArgumentChecks.ensureNonNull("object", object);
        ArgumentChecks.ensureNonNull("toAppendTo", appendable);
        boolean bl2 = bl = this.contentLevel == ContentLevel.NAME_SUMMARY;
        if (object instanceof ParameterValueGroup) {
            parameterValueGroup = (ParameterValueGroup)object;
            parameterDescriptorGroup = parameterValueGroup.getDescriptor();
            referenceIdentifier = parameterDescriptorGroup.getName();
        } else if (object instanceof ParameterDescriptorGroup) {
            parameterDescriptorGroup = (ParameterDescriptorGroup)object;
            parameterValueGroup = null;
            referenceIdentifier = parameterDescriptorGroup.getName();
        } else if (object instanceof OperationMethod) {
            object2 = (OperationMethod)object;
            parameterDescriptorGroup = object2.getParameters();
            parameterValueGroup = null;
            referenceIdentifier = object2.getName();
        } else {
            if (bl && object instanceof IdentifiedObject[]) {
                this.formatSummary((IdentifiedObject[])object, appendable);
                return;
            }
            throw new IllegalArgumentException(Errors.getResources(this.displayLocale).getString((short)163, object.getClass()));
        }
        if (bl) {
            object2 = parameterDescriptorGroup.descriptors();
            this.formatSummary(object2.toArray(new IdentifiedObject[object2.size()]), appendable);
        } else {
            this.format(referenceIdentifier.getCode(), parameterDescriptorGroup, parameterValueGroup, appendable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void format(String string, ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup, Appendable appendable) throws IOException {
        String string2;
        Object object;
        int n;
        int n2;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        boolean bl = this.contentLevel == ContentLevel.BRIEF;
        boolean bl2 = !bl || parameterValueGroup == null;
        boolean bl3 = this.colors != null;
        String string3 = this.lineSeparator;
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        ParameterTableRow parameterTableRow = new ParameterTableRow((IdentifiedObject)parameterDescriptorGroup, this.displayLocale, this.preferredCodespaces, linkedHashMap, bl);
        String string4 = parameterTableRow.getCodeSpace();
        int n3 = 0;
        List list = parameterValueGroup != null ? parameterValueGroup.values() : parameterDescriptorGroup.descriptors();
        LinkedHashMap<Object, ParameterTableRow> linkedHashMap2 = new LinkedHashMap<Object, ParameterTableRow>(Containers.hashMapCapacity(list.size()));
        ArrayList arrayList = null;
        for (Object e : list) {
            void object6;
            GeneralParameterValue generalParameterValue;
            if (parameterValueGroup != null) {
                generalParameterValue = (GeneralParameterValue)e;
                object5 = generalParameterValue.getDescriptor();
            } else {
                generalParameterValue = null;
                object5 = (GeneralParameterDescriptor)e;
            }
            if (object5 instanceof ParameterDescriptorGroup) {
                if (arrayList == null) {
                    arrayList = new ArrayList(4);
                }
                arrayList.add(e);
                continue;
            }
            object4 = null;
            object3 = null;
            if (generalParameterValue instanceof ParameterValue) {
                ParameterValue n7 = (ParameterValue)generalParameterValue;
                object4 = n7.getValue();
                object3 = n7.getUnit();
            } else if (object5 instanceof ParameterDescriptor) {
                ParameterDescriptor parameterDescriptor = (ParameterDescriptor)object5;
                object4 = parameterDescriptor.getDefaultValue();
                object3 = parameterDescriptor.getUnit();
            }
            ParameterTableRow parameterTableRow2 = (ParameterTableRow)linkedHashMap2.get(object5);
            if (parameterTableRow2 == null) {
                ParameterTableRow parameterTableRow3 = new ParameterTableRow((IdentifiedObject)object5, this.displayLocale, this.preferredCodespaces, linkedHashMap, bl);
                linkedHashMap2.put(object5, parameterTableRow3);
                if (parameterTableRow3.codespaceWidth > n3) {
                    n3 = parameterTableRow3.codespaceWidth;
                }
            }
            object6.addValue(object4, (Unit<?>)object3);
        }
        int n4 = 0;
        int n5 = 0;
        boolean bl4 = string4 == null;
        object5 = new StringBuffer();
        object4 = new FieldPosition(-1);
        for (Map.Entry entry : linkedHashMap2.entrySet()) {
            Range<?> range;
            object2 = (GeneralParameterDescriptor)entry.getKey();
            if (!(object2 instanceof ParameterDescriptor)) continue;
            ParameterTableRow parameterTableRow4 = (ParameterTableRow)entry.getValue();
            if (!bl4 && !string4.equals(((ParameterTableRow)entry.getValue()).getCodeSpace())) {
                bl4 = true;
            }
            if ((range = Parameters.getValueDomain((ParameterDescriptor)object2)) != null && (n2 = parameterTableRow4.setValueDomain(range, this.getFormat(Range.class), (StringBuffer)object5)) > n5) {
                n5 = n2;
            }
            parameterTableRow4.expandSingleton();
            n2 = parameterTableRow4.units.size();
            for (n = 0; n < n2; ++n) {
                object = parameterTableRow4.units.get(n);
                if (object == null) continue;
                if (this.getFormat(Unit.class).format(object, (StringBuffer)object5, (FieldPosition)object4).length() != 0 && Character.isLetterOrDigit(((StringBuffer)object5).codePointAt(0))) {
                    ((StringBuffer)object5).insert(0, ' ');
                }
                string2 = ((StringBuffer)object5).toString();
                parameterTableRow4.units.set(n, string2);
                ((StringBuffer)object5).setLength(0);
                int n6 = string2.length();
                if (n6 <= n4) continue;
                n4 = n6;
            }
        }
        object3 = Vocabulary.getResources(this.displayLocale);
        parameterTableRow.writeIdentifiers(appendable, true, this.colors, false, string3);
        appendable.append(string3);
        int n7 = bl ? 9472 : 9552;
        object2 = bl || !this.columnSeparator.equals(SEPARATOR) ? new TableAppender(appendable, this.columnSeparator) : new TableAppender(appendable);
        ((TableAppender)object2).setMultiLinesCells(true);
        ((TableAppender)object2).nextLine((char)n7);
        int n8 = 0;
        int n9 = 0;
        while (true) {
            block48: {
                n2 = 0;
                switch (n9) {
                    case 0: {
                        n = 72;
                        break;
                    }
                    case 1: {
                        n = 105;
                        break;
                    }
                    case 2: {
                        if (bl2) {
                            n = 77;
                            break;
                        }
                        break block48;
                    }
                    case 3: {
                        n = 112;
                        break;
                    }
                    case 4: {
                        n = parameterValueGroup == null ? 28 : 111;
                        n2 = 1;
                        break;
                    }
                    default: {
                        throw new AssertionError(n9);
                    }
                }
                if (bl3) {
                    ((TableAppender)object2).append(X364.BOLD.sequence());
                }
                ((TableAppender)object2).append(((IndexedResourceBundle)object3).getString((short)n));
                if (bl3) {
                    ((TableAppender)object2).append(X364.NORMAL.sequence());
                }
                if (!bl4 && n9 == 0) {
                    ((TableAppender)object2).append(" (").append(string4).append(')');
                }
                if (n2 != 0) break;
                this.nextColumn((TableAppender)object2);
                ++n8;
            }
            ++n9;
        }
        ((TableAppender)object2).nextLine();
        n9 = n7;
        for (Map.Entry entry : linkedHashMap2.entrySet()) {
            if (n9 != 0) {
                ((TableAppender)object2).nextLine('\u2500');
            }
            n9 = bl ? 0 : 9472;
            object = (ParameterTableRow)entry.getValue();
            ((ParameterTableRow)object).codespaceWidth = n3;
            ((ParameterTableRow)object).writeIdentifiers((Appendable)object2, bl4, null, bl3, string3);
            this.nextColumn((TableAppender)object2);
            string2 = (GeneralParameterDescriptor)entry.getKey();
            if (string2 instanceof ParameterDescriptor) {
                String string5;
                int n10;
                ParameterDescriptor parameterDescriptor = (ParameterDescriptor)string2;
                Class clazz = parameterDescriptor.getValueClass();
                if (clazz != null) {
                    ((TableAppender)object2).append(this.getFormat(Class.class).format(clazz, (StringBuffer)object5, (FieldPosition)object4).toString());
                }
                this.nextColumn((TableAppender)object2);
                ((StringBuffer)object5).setLength(0);
                if (bl2) {
                    int n11 = parameterDescriptor.getMinimumOccurs();
                    n10 = parameterDescriptor.getMaximumOccurs();
                    if (n10 == 1) {
                        ((TableAppender)object2).append(((IndexedResourceBundle)object3).getString(n11 == 0 ? (short)82 : 66));
                    } else {
                        Format format = this.getFormat(Integer.class);
                        ((TableAppender)object2).append(format.format(n11, (StringBuffer)object5, (FieldPosition)object4).toString()).append(" \u2026 ");
                        ((StringBuffer)object5).setLength(0);
                        if (n10 == Integer.MAX_VALUE) {
                            ((TableAppender)object2).append('\u221e');
                        } else {
                            ((TableAppender)object2).append(format.format(n10, (StringBuffer)object5, (FieldPosition)object4).toString());
                            ((StringBuffer)object5).setLength(0);
                        }
                    }
                    this.nextColumn((TableAppender)object2);
                }
                if ((string5 = ((ParameterTableRow)object).valueDomain) != null) {
                    ((TableAppender)object2).append(CharSequences.spaces(n5 - ((ParameterTableRow)object).valueDomainAlignment)).append(string5);
                }
                this.nextColumn((TableAppender)object2);
                n10 = Number.class.isAssignableFrom(clazz) ? 1 : -1;
                ((TableAppender)object2).setCellAlignment((byte)n10);
                int n12 = ((ParameterTableRow)object).values.size();
                for (int i = 0; i < n12; ++i) {
                    int n13;
                    Object object6;
                    Object object7 = ((ParameterTableRow)object).values.get(i);
                    if (object7 == null) continue;
                    if (i != 0) {
                        object6 = ((IndexedResourceBundle)object3).getString((short)36);
                        ((TableAppender)object2).nextLine();
                        ((TableAppender)object2).setCellAlignment((byte)0);
                        for (n13 = 0; n13 < n8; ++n13) {
                            ((TableAppender)object2).append((CharSequence)object6);
                            this.nextColumn((TableAppender)object2);
                        }
                        ((TableAppender)object2).setCellAlignment((byte)n10);
                    }
                    if ((object6 = this.getFormat(object7.getClass())) != null) {
                        if (object6 instanceof NumberFormat && object7 instanceof Number) {
                            ParameterFormat.configure((NumberFormat)object6, Math.abs(((Number)object7).doubleValue()));
                        }
                        object7 = ((Format)object6).format(object7, (StringBuffer)object5, (FieldPosition)object4);
                    }
                    ((TableAppender)object2).append(object7.toString());
                    ((StringBuffer)object5).setLength(0);
                    n13 = n4;
                    String string6 = (String)((ParameterTableRow)object).units.get(i);
                    if (string6 != null) {
                        ((TableAppender)object2).append(string6);
                        n13 -= string6.length();
                    }
                    ((TableAppender)object2).append(CharSequences.spaces(n13));
                }
            }
            ((TableAppender)object2).nextLine();
            ((TableAppender)object2).setCellAlignment((byte)-1);
        }
        ((TableAppender)object2).nextLine((char)n7);
        ((TableAppender)object2).flush();
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            ParameterTableRow.writeFootnoteNumber(appendable, (Integer)entry.getValue());
            appendable.append(' ').append((CharSequence)entry.getKey()).append(string3);
        }
        if (arrayList != null) {
            for (Map.Entry entry : arrayList) {
                if (entry instanceof ParameterValueGroup) {
                    object = (ParameterValueGroup)entry;
                    string2 = object.getDescriptor();
                } else {
                    object = null;
                    string2 = (ParameterDescriptorGroup)entry;
                }
                appendable.append(string3);
                this.format(string + '/' + string2.getName().getCode(), (ParameterDescriptorGroup)string2, (ParameterValueGroup)object, appendable);
            }
        }
    }

    private static void configure(NumberFormat numberFormat, double d) {
        int n;
        if (numberFormat.getMaximumFractionDigits() <= 9 && (n = d < 10.0 ? 9 : (d < 1000.0 ? 6 : 3)) >= numberFormat.getMinimumFractionDigits()) {
            numberFormat.setMaximumFractionDigits(n);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void formatSummary(IdentifiedObject[] identifiedObjectArray, Appendable appendable) throws IOException {
        Object object;
        Vocabulary vocabulary = Vocabulary.getResources(this.displayLocale);
        boolean bl = false;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        linkedHashMap.put(null, 0);
        if (this.preferredCodespaces != null) {
            for (String string : this.preferredCodespaces) {
                linkedHashMap.put(string, linkedHashMap.size());
            }
        }
        for (IdentifiedObject object2 : identifiedObjectArray) {
            Object object3;
            Object object4;
            String[] stringArray = new String[linkedHashMap.size()];
            Set set = object2.getIdentifiers();
            if (set != null) {
                object = null;
                object4 = set.iterator();
                while (object4.hasNext()) {
                    object3 = (ReferenceIdentifier)object4.next();
                    if (object3 == null) continue;
                    if (this.isPreferredCodespace(object3.getCodeSpace())) {
                        object = object3;
                        break;
                    }
                    if (object != null) continue;
                    object = object3;
                }
                if (object != null) {
                    stringArray[0] = IdentifiedObjects.toString((Identifier)object);
                    bl = true;
                }
            }
            if ((object = object2.getName()) != null && this.isPreferredCodespace((String)(object4 = object.getCodeSpace()))) {
                stringArray = ParameterFormat.putIfAbsent(vocabulary, stringArray, linkedHashMap, (String)object4, object.getCode());
                object = null;
            }
            if ((object4 = object2.getAlias()) != null) {
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    String string;
                    GenericName genericName = (GenericName)object3.next();
                    if (genericName == null || !this.isPreferredCodespace(string = NameToIdentifier.getCodeSpace(genericName, this.displayLocale))) continue;
                    stringArray = ParameterFormat.putIfAbsent(vocabulary, stringArray, linkedHashMap, string, genericName.tip().toInternationalString().toString(this.displayLocale));
                    object = null;
                }
            }
            if (object != null) {
                stringArray = ParameterFormat.putIfAbsent(vocabulary, stringArray, linkedHashMap, object.getCodeSpace(), object.getCode());
            }
            arrayList.add(stringArray);
        }
        boolean bl2 = this.colors != null;
        TableAppender tableAppender = new TableAppender(appendable, this.columnSeparator);
        tableAppender.setMultiLinesCells(true);
        tableAppender.appendHorizontalSeparator();
        for (String string : linkedHashMap.keySet()) {
            void var10_21;
            if (string == null) {
                if (!bl) continue;
                String string2 = vocabulary.getString((short)47);
            }
            if (bl2) {
                void var10_19;
                String string3 = X364.BOLD.sequence() + (String)var10_19 + X364.NORMAL.sequence();
            }
            tableAppender.append((CharSequence)var10_21);
            this.nextColumn(tableAppender);
        }
        tableAppender.appendHorizontalSeparator();
        int n = linkedHashMap.size();
        for (String[] stringArray : arrayList) {
            int n2;
            int n3 = n2 = bl ? 0 : 1;
            while (n2 < n) {
                if (n2 < stringArray.length && (object = stringArray[n2]) != null) {
                    tableAppender.append((CharSequence)object);
                }
                this.nextColumn(tableAppender);
                ++n2;
            }
            tableAppender.nextLine();
        }
        tableAppender.appendHorizontalSeparator();
        tableAppender.flush();
    }

    private static String[] putIfAbsent(Vocabulary vocabulary, String[] stringArray, Map<String, Integer> map, String string, String string2) {
        int n;
        Integer n2;
        if (string == null) {
            string = vocabulary.getString((short)108);
        }
        if ((n2 = map.get(string)) != null) {
            n = n2;
        } else {
            n = map.size();
            map.put(string, n);
        }
        if (n >= stringArray.length) {
            stringArray = Arrays.copyOf(stringArray, n + 1);
        }
        if (stringArray[n] == null) {
            stringArray[n] = string2;
        }
        return stringArray;
    }

    private static ParameterFormat getSharedInstance(Colors colors) {
        ParameterFormat parameterFormat = INSTANCE.getAndSet(null);
        if (parameterFormat == null) {
            parameterFormat = new ParameterFormat();
        }
        parameterFormat.setColors(colors);
        return parameterFormat;
    }

    static String sharedFormat(Object object) {
        ParameterFormat parameterFormat = ParameterFormat.getSharedInstance(null);
        String string = parameterFormat.format(object);
        INSTANCE.set(parameterFormat);
        return string;
    }

    static void print(Object object) {
        Console console = System.console();
        Closeable closeable = console != null ? console.writer() : System.out;
        ParameterFormat parameterFormat = ParameterFormat.getSharedInstance(Colors.NAMING);
        try {
            parameterFormat.format(object, (Appendable)((Object)closeable));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        INSTANCE.set(parameterFormat);
    }

    @Override
    public Object parse(CharSequence charSequence, ParsePosition parsePosition) throws ParseException {
        throw new ParseException(Errors.getResources(this.displayLocale).getString((short)162, "parse"), parsePosition.getIndex());
    }

    @Override
    public ParameterFormat clone() {
        ParameterFormat parameterFormat = (ParameterFormat)super.clone();
        parameterFormat.colors = parameterFormat.colors.clone();
        return parameterFormat;
    }

    public static enum ContentLevel {
        DETAILED,
        BRIEF,
        NAME_SUMMARY;

    }
}

