/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import java.util.Collection;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.NonMarshalledAuthority;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.apache.sis.xml.IdentifierMap;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Series;
import org.opengis.metadata.identification.BrowseGraphic;
import org.opengis.util.InternationalString;

@TitleProperty(name="title")
@XmlType(name="CI_Citation_Type", propOrder={"title", "alternateTitles", "dates", "edition", "editionDate", "identifiers", "citedResponsibleParties", "presentationForms", "series", "otherCitationDetails", "collectiveTitle", "ISBN", "ISSN", "onlineResource", "graphic"})
@XmlRootElement(name="CI_Citation")
public class DefaultCitation
extends ISOMetadata
implements Citation {
    private static final long serialVersionUID = 3490090845236158848L;
    private InternationalString title;
    private Collection<InternationalString> alternateTitles;
    private Collection<CitationDate> dates;
    private InternationalString edition;
    private long editionDate = Long.MIN_VALUE;
    private Collection<ResponsibleParty> citedResponsibleParties;
    private Collection<PresentationForm> presentationForms;
    private Series series;
    private InternationalString otherCitationDetails;
    @Deprecated
    private InternationalString collectiveTitle;
    private Collection<OnlineResource> onlineResources;
    private Collection<BrowseGraphic> graphics;

    public DefaultCitation() {
    }

    public DefaultCitation(CharSequence charSequence) {
        this.title = Types.toInternationalString(charSequence);
    }

    public DefaultCitation(Citation citation) {
        super(citation);
        if (citation != null) {
            Object object;
            this.title = citation.getTitle();
            this.alternateTitles = this.copyCollection(citation.getAlternateTitles(), InternationalString.class);
            this.dates = this.copyCollection(citation.getDates(), CitationDate.class);
            this.edition = citation.getEdition();
            this.editionDate = MetadataUtilities.toMilliseconds(citation.getEditionDate());
            this.identifiers = this.copyCollection(citation.getIdentifiers(), Identifier.class);
            this.citedResponsibleParties = this.copyCollection(citation.getCitedResponsibleParties(), ResponsibleParty.class);
            this.presentationForms = this.copyCollection(citation.getPresentationForms(), PresentationForm.class);
            this.series = citation.getSeries();
            this.otherCitationDetails = citation.getOtherCitationDetails();
            this.collectiveTitle = citation.getCollectiveTitle();
            if (citation instanceof DefaultCitation) {
                object = (DefaultCitation)citation;
                this.onlineResources = this.copyCollection(((DefaultCitation)object).getOnlineResources(), OnlineResource.class);
                this.graphics = this.copyCollection(((DefaultCitation)object).getGraphics(), BrowseGraphic.class);
            }
            object = citation.getISBN();
            String string = citation.getISSN();
            if (object != null || string != null) {
                IdentifierMap identifierMap = super.getIdentifierMap();
                if (object != null) {
                    identifierMap.putSpecialized(Citations.ISBN, object);
                }
                if (string != null) {
                    identifierMap.putSpecialized(Citations.ISSN, string);
                }
            }
        }
    }

    public static DefaultCitation castOrCopy(Citation citation) {
        if (citation == null || citation instanceof DefaultCitation) {
            return (DefaultCitation)citation;
        }
        return new DefaultCitation(citation);
    }

    @Override
    @XmlElement(name="title", required=true)
    public InternationalString getTitle() {
        return this.title;
    }

    public void setTitle(InternationalString internationalString) {
        this.checkWritePermission(this.title);
        this.title = internationalString;
    }

    @XmlElement(name="alternateTitle")
    public Collection<InternationalString> getAlternateTitles() {
        this.alternateTitles = this.nonNullCollection(this.alternateTitles, InternationalString.class);
        return this.alternateTitles;
    }

    public void setAlternateTitles(Collection<? extends InternationalString> collection) {
        this.alternateTitles = this.writeCollection(collection, this.alternateTitles, InternationalString.class);
    }

    @XmlElement(name="date")
    public Collection<CitationDate> getDates() {
        this.dates = this.nonNullCollection(this.dates, CitationDate.class);
        return this.dates;
    }

    public void setDates(Collection<? extends CitationDate> collection) {
        this.dates = this.writeCollection(collection, this.dates, CitationDate.class);
    }

    @Override
    @XmlElement(name="edition")
    public InternationalString getEdition() {
        return this.edition;
    }

    public void setEdition(InternationalString internationalString) {
        this.checkWritePermission(this.edition);
        this.edition = internationalString;
    }

    @Override
    @XmlElement(name="editionDate")
    public Date getEditionDate() {
        return MetadataUtilities.toDate(this.editionDate);
    }

    public void setEditionDate(Date date) {
        this.checkWritePermission(MetadataUtilities.toDate(this.editionDate));
        this.editionDate = MetadataUtilities.toMilliseconds(date);
    }

    @Override
    @XmlElement(name="identifier")
    public Collection<Identifier> getIdentifiers() {
        return NonMarshalledAuthority.filterOnMarshalling(super.getIdentifiers());
    }

    public void setIdentifiers(Collection<? extends Identifier> collection) {
        collection = NonMarshalledAuthority.setMarshallables(this.identifiers, collection);
        this.identifiers = this.writeCollection(collection, this.identifiers, Identifier.class);
    }

    @XmlElement(name="citedResponsibleParty")
    public Collection<ResponsibleParty> getCitedResponsibleParties() {
        this.citedResponsibleParties = this.nonNullCollection(this.citedResponsibleParties, ResponsibleParty.class);
        return this.citedResponsibleParties;
    }

    public void setCitedResponsibleParties(Collection<? extends ResponsibleParty> collection) {
        this.citedResponsibleParties = this.writeCollection(collection, this.citedResponsibleParties, ResponsibleParty.class);
    }

    @Override
    @XmlElement(name="presentationForm")
    public Collection<PresentationForm> getPresentationForms() {
        this.presentationForms = this.nonNullCollection(this.presentationForms, PresentationForm.class);
        return this.presentationForms;
    }

    public void setPresentationForms(Collection<? extends PresentationForm> collection) {
        this.presentationForms = this.writeCollection(collection, this.presentationForms, PresentationForm.class);
    }

    @Override
    @XmlElement(name="series")
    public Series getSeries() {
        return this.series;
    }

    public void setSeries(Series series) {
        this.checkWritePermission(this.series);
        this.series = series;
    }

    @Override
    @XmlElement(name="otherCitationDetails")
    public InternationalString getOtherCitationDetails() {
        return this.otherCitationDetails;
    }

    public void setOtherCitationDetails(InternationalString internationalString) {
        this.checkWritePermission();
        this.otherCitationDetails = internationalString;
    }

    @Override
    @Deprecated
    @XmlElement(name="collectiveTitle", namespace="http://www.isotc211.org/2005/gmd")
    public InternationalString getCollectiveTitle() {
        return FilterByVersion.LEGACY_METADATA.accept() ? this.collectiveTitle : null;
    }

    @Deprecated
    public void setCollectiveTitle(InternationalString internationalString) {
        this.checkWritePermission(this.collectiveTitle);
        this.collectiveTitle = internationalString;
    }

    private String getIdentifier(Citation citation) {
        return Containers.isNullOrEmpty(this.identifiers) ? null : (String)this.getIdentifierMap().get(citation);
    }

    @Override
    @XmlElement(name="ISBN")
    public String getISBN() {
        return this.getIdentifier(Citations.ISBN);
    }

    public void setISBN(String string) {
        this.checkWritePermission(this.getIdentifier(Citations.ISBN));
        if (string != null || !Containers.isNullOrEmpty(this.identifiers)) {
            this.getIdentifierMap().putSpecialized(Citations.ISBN, string);
        }
    }

    @Override
    @XmlElement(name="ISSN")
    public String getISSN() {
        return this.getIdentifier(Citations.ISSN);
    }

    public void setISSN(String string) {
        this.checkWritePermission(this.getIdentifier(Citations.ISSN));
        if (string != null || !Containers.isNullOrEmpty(this.identifiers)) {
            this.getIdentifierMap().putSpecialized(Citations.ISSN, string);
        }
    }

    @UML(identifier="onlineResource", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<OnlineResource> getOnlineResources() {
        this.onlineResources = this.nonNullCollection(this.onlineResources, OnlineResource.class);
        return this.onlineResources;
    }

    public void setOnlineResources(Collection<? extends OnlineResource> collection) {
        this.onlineResources = this.writeCollection(collection, this.onlineResources, OnlineResource.class);
    }

    @UML(identifier="graphic", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<BrowseGraphic> getGraphics() {
        this.graphics = this.nonNullCollection(this.graphics, BrowseGraphic.class);
        return this.graphics;
    }

    public void setGraphics(Collection<? extends BrowseGraphic> collection) {
        this.graphics = this.writeCollection(collection, this.graphics, BrowseGraphic.class);
    }

    @XmlElement(name="onlineResource")
    private Collection<OnlineResource> getOnlineResource() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getOnlineResources() : null;
    }

    @XmlElement(name="graphic")
    private Collection<BrowseGraphic> getGraphic() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getGraphics() : null;
    }
}

