/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.sis.internal.util.AbstractMapEntry;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.PropertyMap;
import org.apache.sis.metadata.TypeValuePolicy;
import org.apache.sis.metadata.ValueExistencePolicy;

final class ValueMap
extends PropertyMap<Object> {
    final Object metadata;
    final ValueExistencePolicy valuePolicy;

    ValueMap(Object object, PropertyAccessor propertyAccessor, KeyNamePolicy keyNamePolicy, ValueExistencePolicy valueExistencePolicy) {
        super(propertyAccessor, keyNamePolicy);
        this.metadata = object;
        this.valuePolicy = valueExistencePolicy;
    }

    @Override
    public boolean isEmpty() {
        return this.accessor.count(this.metadata, this.valuePolicy, 0) == 0;
    }

    @Override
    public int size() {
        return this.accessor.count(this.metadata, this.valuePolicy, 1);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public Object get(Object object) {
        Object object2;
        if (object instanceof String && !this.valuePolicy.isSkipped(object2 = this.accessor.get(this.accessor.indexOf((String)object, false), this.metadata))) {
            return object2;
        }
        return null;
    }

    @Override
    public Object put(String string, Object object) {
        Object object2 = this.accessor.set(this.accessor.indexOf(string, true), this.metadata, object, 1);
        return this.valuePolicy.isSkipped(object2) ? null : object2;
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            this.accessor.set(this.accessor.indexOf(entry.getKey(), true), this.metadata, entry.getValue(), 0);
        }
    }

    @Override
    public Object remove(Object object) throws UnsupportedOperationException {
        Object object2;
        if (object instanceof String && !this.valuePolicy.isSkipped(object2 = this.accessor.set(this.accessor.indexOf((String)object, false), this.metadata, null, 1))) {
            return object2;
        }
        return null;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new Entries();
        }
        return this.entrySet;
    }

    @Override
    final Iterator<Map.Entry<String, Object>> iterator() {
        return new Iter();
    }

    private final class Entries
    extends PropertyMap.Entries {
        Entries() {
            super(ValueMap.this);
        }

        @Override
        public boolean contains(Object object) {
            int n;
            Map.Entry entry;
            Object k;
            if (object instanceof Map.Entry && (k = (entry = (Map.Entry)object).getKey()) instanceof String && (n = ValueMap.this.accessor.indexOf((String)k, false)) >= 0) {
                return new Property(n).equals(entry);
            }
            return false;
        }
    }

    private final class Iter
    implements Iterator<Map.Entry<String, Object>> {
        private Property current;
        private Property next;

        Iter() {
            this.move(0);
        }

        private void move(int n) {
            int n2 = ValueMap.this.accessor.count();
            while (n < n2) {
                if (!ValueMap.this.valuePolicy.isSkipped(ValueMap.this.accessor.get(n, ValueMap.this.metadata))) {
                    this.next = new Property(n);
                    return;
                }
                ++n;
            }
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Map.Entry<String, Object> next() {
            if (this.next != null) {
                this.current = this.next;
                this.move(this.next.index + 1);
                return this.current;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.current.setValue((Object)null);
            this.current = null;
        }
    }

    final class Property
    extends AbstractMapEntry<String, Object> {
        final int index;

        Property(int n) {
            this.index = n;
        }

        @Override
        public String getKey() {
            return ValueMap.this.accessor.name(this.index, ValueMap.this.keyPolicy);
        }

        public Class<?> getValueType() {
            return ValueMap.this.accessor.type(this.index, TypeValuePolicy.PROPERTY_TYPE);
        }

        @Override
        public Object getValue() {
            Object object = ValueMap.this.accessor.get(this.index, ValueMap.this.metadata);
            return ValueMap.this.valuePolicy.isSkipped(object) ? null : object;
        }

        @Override
        public Object setValue(Object object) {
            return ValueMap.this.accessor.set(this.index, ValueMap.this.metadata, object, 1);
        }
    }
}

