/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.lan;

import java.util.Locale;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlValue;
import org.apache.sis.internal.jaxb.Context;

final class LocalisedCharacterString {
    private static final String PREFIX = "#locale-";
    Locale locale;
    @XmlValue
    String text;

    LocalisedCharacterString() {
    }

    LocalisedCharacterString(Locale locale, String string) {
        this.locale = locale;
        this.text = string;
    }

    @XmlAttribute(name="locale", required=true)
    public String getLocale() {
        if (this.locale == null) {
            return null;
        }
        Context context = Context.current();
        return PREFIX.concat(Context.converter(context).toLanguageCode(context, this.locale));
    }

    public void setLocale(String string) {
        if (string != null) {
            Context context = Context.current();
            this.locale = Context.converter(context).toLocale(context, string.substring(string.indexOf(45) + 1));
        } else {
            this.locale = null;
        }
    }

    public int hashCode() {
        return Objects.hash(this.locale, this.text);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LocalisedCharacterString)) {
            return false;
        }
        LocalisedCharacterString localisedCharacterString = (LocalisedCharacterString)object;
        return Objects.equals(this.locale, localisedCharacterString.locale) && Objects.equals(this.text, localisedCharacterString.text);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80).append(this.getClass().getSimpleName()).append('[').append(this.getLocale());
        if (this.text != null) {
            stringBuilder.append(", \u201c").append(this.text).append('\u201d');
        }
        return stringBuilder.append(']').toString();
    }
}

