/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.j2d;

import java.awt.Shape;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sis.internal.referencing.j2d.ShapeUtilities;
import org.apache.sis.util.StringBuilders;

public final class ShapeProperties {
    private final Shape geometry;
    private boolean isPolygon;

    public ShapeProperties(Shape shape) {
        this.geometry = shape;
    }

    private static double[] addPoint(double[] dArray, double[] dArray2, int n) {
        if (n >= dArray2.length) {
            dArray2 = Arrays.copyOf(dArray2, n * 2);
        }
        System.arraycopy(dArray, 0, dArray2, n, 2);
        return dArray2;
    }

    private static float[] addPoint(float[] fArray, float[] fArray2, int n) {
        if (n >= fArray2.length) {
            fArray2 = Arrays.copyOf(fArray2, n * 2);
        }
        System.arraycopy(fArray, 0, fArray2, n, 2);
        return fArray2;
    }

    private List<?> coordinates(double d) {
        PathIterator pathIterator = this.geometry.getPathIterator(null, d);
        this.isPolygon = true;
        if (ShapeUtilities.isFloat((Object)this.geometry)) {
            return this.coordinatesAsFloats(pathIterator);
        }
        return this.coordinatesAsDoubles(pathIterator);
    }

    private List<double[]> coordinatesAsDoubles(PathIterator pathIterator) {
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        double[] dArray = new double[10];
        double[] dArray2 = new double[6];
        int n = 0;
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray2)) {
                case 0: {
                    if (n > 2) {
                        this.isPolygon = false;
                        arrayList.add(Arrays.copyOf(dArray, n));
                    }
                    System.arraycopy(dArray2, 0, dArray, 0, 2);
                    n = 2;
                    break;
                }
                case 1: {
                    dArray = ShapeProperties.addPoint(dArray2, dArray, n);
                    n += 2;
                    break;
                }
                case 4: {
                    if (n > 2) {
                        if (dArray[0] != dArray[n - 2] || dArray[1] != dArray[n - 1]) {
                            dArray = ShapeProperties.addPoint(dArray, dArray, n);
                            n += 2;
                        }
                        arrayList.add(Arrays.copyOf(dArray, n));
                    }
                    n = 0;
                    break;
                }
                default: {
                    throw new IllegalPathStateException();
                }
            }
            pathIterator.next();
        }
        if (n > 2) {
            this.isPolygon = false;
            arrayList.add(Arrays.copyOf(dArray, n));
        }
        return arrayList;
    }

    private List<float[]> coordinatesAsFloats(PathIterator pathIterator) {
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        float[] fArray = new float[10];
        float[] fArray2 = new float[6];
        int n = 0;
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray2)) {
                case 0: {
                    if (n > 2) {
                        this.isPolygon = false;
                        arrayList.add(Arrays.copyOf(fArray, n));
                    }
                    System.arraycopy(fArray2, 0, fArray, 0, 2);
                    n = 2;
                    break;
                }
                case 1: {
                    fArray = ShapeProperties.addPoint(fArray2, fArray, n);
                    n += 2;
                    break;
                }
                case 4: {
                    if (n > 2) {
                        if (fArray[0] != fArray[n - 2] || fArray[1] != fArray[n - 1]) {
                            fArray = ShapeProperties.addPoint(fArray, fArray, n);
                            n += 2;
                        }
                        arrayList.add(Arrays.copyOf(fArray, n));
                    }
                    n = 0;
                    break;
                }
                default: {
                    throw new IllegalPathStateException();
                }
            }
            pathIterator.next();
        }
        if (n > 2) {
            this.isPolygon = false;
            arrayList.add(Arrays.copyOf(fArray, n));
        }
        return arrayList;
    }

    public String toWKT(double d) {
        boolean bl;
        List<?> list = this.coordinates(d);
        switch (list.size()) {
            case 0: {
                return "POLYGON EMPTY";
            }
            case 1: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        StringBuilder stringBuilder = new StringBuilder(80);
        if (bl) {
            stringBuilder.append("MULTI");
        }
        stringBuilder.append(this.isPolygon ? "POLYGON" : "LINESTRING").append(' ');
        if (bl) {
            stringBuilder.append('(');
        }
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append('(');
            if (this.isPolygon) {
                stringBuilder.append('(');
            }
            int n = Array.getLength(obj);
            for (int j = 0; j < n; ++j) {
                if (j != 0) {
                    if ((j & 1) == 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(' ');
                }
                if (obj instanceof double[]) {
                    stringBuilder.append(((double[])obj)[j]);
                } else {
                    stringBuilder.append(((float[])obj)[j]);
                }
                StringBuilders.trimFractionalPart(stringBuilder);
            }
            if (this.isPolygon) {
                stringBuilder.append(')');
            }
            stringBuilder.append(')');
        }
        if (bl) {
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }
}

