/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.math.Vector;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.Classes;
import org.apache.sis.util.UnsupportedImplementationException;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public abstract class Geometries<G> {
    public final GeometryLibrary library;
    public final Class<G> rootClass;
    public final Class<?> pointClass;
    public final Class<? extends G> polylineClass;
    public final Class<? extends G> polygonClass;
    private static Geometries<?> implementation;
    private final Geometries<?> fallback;

    Geometries(GeometryLibrary geometryLibrary, Class<G> clazz, Class<?> clazz2, Class<? extends G> clazz3, Class<? extends G> clazz4) {
        this.library = geometryLibrary;
        this.rootClass = clazz;
        this.pointClass = clazz2;
        this.polylineClass = clazz3;
        this.polygonClass = clazz4;
        this.fallback = implementation;
    }

    private static void register(String string) {
        String string2 = Geometries.class.getName();
        string2 = string2.substring(0, string2.lastIndexOf(46) + 1).concat(string);
        try {
            implementation = (Geometries)Class.forName(string2).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (LinkageError | ReflectiveOperationException throwable) {
            LogRecord logRecord = Resources.forLocale(null).getLogRecord(Level.CONFIG, (short)19, string, throwable.toString());
            logRecord.setLoggerName("org.apache.sis.geometry");
            Logging.log(Geometries.class, "register", logRecord);
        }
    }

    public static Geometries<?> implementation(GeometryLibrary geometryLibrary) {
        if (geometryLibrary == null) {
            return implementation;
        }
        Geometries<?> geometries = implementation;
        while (geometries != null) {
            if (geometries.library == geometryLibrary) {
                return geometries;
            }
            geometries = geometries.fallback;
        }
        throw new IllegalArgumentException(Resources.format((short)21, (Object)geometryLibrary));
    }

    public static Geometries<?> implementation(Class<?> clazz) {
        Geometries<?> geometries = implementation;
        while (geometries != null) {
            if (geometries.rootClass.isAssignableFrom(clazz)) {
                return geometries;
            }
            geometries = geometries.fallback;
        }
        return implementation;
    }

    public static boolean isKnownType(Class<?> clazz) {
        Geometries<?> geometries = implementation;
        while (geometries != null) {
            if (geometries.rootClass.isAssignableFrom(clazz)) {
                return true;
            }
            geometries = geometries.fallback;
        }
        return false;
    }

    CoordinateReferenceSystem tryGetCoordinateReferenceSystem(Object object) throws FactoryException {
        return null;
    }

    public static CoordinateReferenceSystem getCoordinateReferenceSystem(Object object) throws FactoryException {
        Geometries<?> geometries = implementation;
        while (geometries != null) {
            CoordinateReferenceSystem coordinateReferenceSystem = geometries.tryGetCoordinateReferenceSystem(object);
            if (coordinateReferenceSystem != null) {
                return coordinateReferenceSystem;
            }
            geometries = geometries.fallback;
        }
        return null;
    }

    abstract double[] tryGetCoordinate(Object var1);

    public static double[] getCoordinate(Object object) {
        Geometries<?> geometries = implementation;
        while (geometries != null) {
            double[] dArray = geometries.tryGetCoordinate(object);
            if (dArray != null) {
                return dArray;
            }
            geometries = geometries.fallback;
        }
        return null;
    }

    abstract GeneralEnvelope tryGetEnvelope(Object var1);

    public static GeneralEnvelope getEnvelope(Object object) {
        Geometries<?> geometries = implementation;
        while (geometries != null) {
            GeneralEnvelope generalEnvelope = geometries.tryGetEnvelope(object);
            if (generalEnvelope != null) {
                return generalEnvelope;
            }
            geometries = geometries.fallback;
        }
        return null;
    }

    abstract Object tryGetCentroid(Object var1);

    public static Object getCentroid(Object object) {
        Geometries<?> geometries = implementation;
        while (geometries != null) {
            Object object2 = geometries.tryGetCentroid(object);
            if (object2 != null) {
                return object2;
            }
            geometries = geometries.fallback;
        }
        return null;
    }

    abstract String tryGetLabel(Object var1);

    public static String toString(Object object) {
        Geometries<?> geometries = implementation;
        while (geometries != null) {
            String string = geometries.tryGetLabel(object);
            if (string != null) {
                GeneralEnvelope generalEnvelope = geometries.tryGetEnvelope(object);
                if (generalEnvelope != null) {
                    String string2 = generalEnvelope.toString();
                    string = string + string2.substring(string2.indexOf(40));
                }
                return string;
            }
            geometries = geometries.fallback;
        }
        return null;
    }

    public static String formatWKT(Object object, double d) {
        Geometries<?> geometries = implementation;
        while (geometries != null) {
            String string = geometries.tryFormatWKT(object, d);
            if (string != null) {
                return string;
            }
            geometries = geometries.fallback;
        }
        return null;
    }

    abstract String tryFormatWKT(Object var1, double var2);

    public abstract Object parseWKT(String var1) throws Exception;

    public abstract Object createPoint(double var1, double var3);

    public abstract G createPolyline(int var1, Vector ... var2);

    abstract G tryMergePolylines(Object var1, Iterator<?> var2);

    public static Object mergePolylines(Iterator<?> iterator) {
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj == null) continue;
            Geometries<?> geometries = implementation;
            while (geometries != null) {
                Object obj2 = geometries.tryMergePolylines(obj, iterator);
                if (obj2 != null) {
                    return obj2;
                }
                geometries = geometries.fallback;
            }
            throw new ClassCastException(Geometries.unsupportedImplementation(obj));
        }
        return null;
    }

    Object tryBuffer(Object object, double d) {
        if (this.rootClass.isInstance(object)) {
            throw new UnsupportedImplementationException(Geometries.unsupported("buffer"));
        }
        return null;
    }

    public static Object buffer(Object object, double d) {
        Geometries<?> geometries = implementation;
        while (geometries != null) {
            Object object2 = geometries.tryBuffer(object, d);
            if (object2 != null) {
                return object2;
            }
            geometries = geometries.fallback;
        }
        return null;
    }

    Object tryTransform(Object object, CoordinateOperation coordinateOperation, CoordinateReferenceSystem coordinateReferenceSystem) throws FactoryException, TransformException {
        if (this.rootClass.isInstance(object)) {
            throw new UnsupportedImplementationException(Geometries.unsupported("transform"));
        }
        return null;
    }

    public static Object transform(Object object, CoordinateOperation coordinateOperation) throws FactoryException, TransformException {
        if (object != null && coordinateOperation != null) {
            Geometries<?> geometries = implementation;
            while (geometries != null) {
                Object object2 = geometries.tryTransform(object, coordinateOperation, null);
                if (object2 != null) {
                    return object2;
                }
                geometries = geometries.fallback;
            }
            if (!coordinateOperation.getMathTransform().isIdentity()) {
                return null;
            }
        }
        return object;
    }

    public static Object transform(Object object, CoordinateReferenceSystem coordinateReferenceSystem) throws FactoryException, TransformException {
        if (object != null && coordinateReferenceSystem != null) {
            Geometries<?> geometries = implementation;
            while (geometries != null) {
                Object object2 = geometries.tryTransform(object, null, coordinateReferenceSystem);
                if (object2 != null) {
                    return object2;
                }
                geometries = geometries.fallback;
            }
            return null;
        }
        return object;
    }

    static String unsupported(String string) {
        return Errors.format((short)162, string);
    }

    static String unsupported(int n) {
        return Resources.format((short)20, n);
    }

    private static String unsupportedImplementation(Object object) {
        return Errors.format((short)163, Classes.getClass(object));
    }

    static {
        Geometries.register("Java2D");
        Geometries.register("JTS");
        Geometries.register("ESRI");
    }
}

