/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature.builder;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.builder.AttributeRole;
import org.apache.sis.feature.builder.CharacteristicTypeBuilder;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.feature.builder.RemoveOnlyList;
import org.apache.sis.internal.feature.AttributeConvention;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.util.AbstractIterator;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.SetOfUnknownSize;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.GenericName;

public final class AttributeTypeBuilder<V>
extends PropertyTypeBuilder {
    private final Class<V> valueClass;
    private V defaultValue;
    private boolean isIdentifier;
    final List<CharacteristicTypeBuilder<?>> characteristics;
    private transient DefaultAttributeType<V> property;

    private AttributeTypeBuilder(AttributeTypeBuilder<?> attributeTypeBuilder, Class<V> clazz) throws UnconvertibleObjectException {
        super(attributeTypeBuilder);
        this.valueClass = clazz;
        this.defaultValue = ObjectConverters.convert(attributeTypeBuilder.defaultValue, clazz);
        this.isIdentifier = attributeTypeBuilder.isIdentifier;
        this.characteristics = attributeTypeBuilder.characteristics;
    }

    AttributeTypeBuilder(FeatureTypeBuilder featureTypeBuilder, Class<V> clazz) {
        super(featureTypeBuilder);
        this.valueClass = clazz;
        this.characteristics = new ArrayList();
    }

    AttributeTypeBuilder(FeatureTypeBuilder featureTypeBuilder, DefaultAttributeType<V> defaultAttributeType) {
        super(featureTypeBuilder);
        this.property = defaultAttributeType;
        this.minimumOccurs = defaultAttributeType.getMinimumOccurs();
        this.maximumOccurs = defaultAttributeType.getMaximumOccurs();
        this.valueClass = defaultAttributeType.getValueClass();
        this.defaultValue = defaultAttributeType.getDefaultValue();
        Map<String, DefaultAttributeType<?>> map = defaultAttributeType.characteristics();
        this.characteristics = new ArrayList(map.size());
        for (DefaultAttributeType<?> defaultAttributeType2 : map.values()) {
            this.characteristics.add(new CharacteristicTypeBuilder(this, defaultAttributeType2));
        }
        this.initialize(defaultAttributeType);
    }

    @Override
    final void clearCache() {
        this.property = null;
        super.clearCache();
    }

    @Override
    final String getDefaultName() {
        return Classes.getShortName(this.valueClass);
    }

    @Override
    public AttributeTypeBuilder<V> setName(GenericName genericName) {
        super.setName(genericName);
        return this;
    }

    @Override
    public AttributeTypeBuilder<V> setName(CharSequence charSequence) {
        super.setName(charSequence);
        return this;
    }

    @Override
    public AttributeTypeBuilder<V> setName(CharSequence ... charSequenceArray) {
        super.setName(charSequenceArray);
        return this;
    }

    @Override
    public AttributeTypeBuilder<V> setMinimumOccurs(int n) {
        super.setMinimumOccurs(n);
        return this;
    }

    @Override
    public AttributeTypeBuilder<V> setMaximumOccurs(int n) {
        super.setMaximumOccurs(n);
        return this;
    }

    public Class<V> getValueClass() {
        return this.valueClass;
    }

    public <N> AttributeTypeBuilder<N> setValueClass(Class<N> clazz) throws UnconvertibleObjectException {
        FeatureTypeBuilder featureTypeBuilder = this.owner();
        this.ensureNonNull("type", clazz);
        if (clazz == this.valueClass) {
            return this;
        }
        AttributeTypeBuilder<N> attributeTypeBuilder = new AttributeTypeBuilder<N>(this, clazz);
        for (CharacteristicTypeBuilder<N> characteristicTypeBuilder : this.characteristics) {
            characteristicTypeBuilder.owner(attributeTypeBuilder);
        }
        featureTypeBuilder.replace(this, attributeTypeBuilder);
        this.dispose();
        return attributeTypeBuilder;
    }

    public V getDefaultValue() {
        return this.defaultValue;
    }

    public AttributeTypeBuilder<V> setDefaultValue(V v) {
        if (!Objects.equals(this.defaultValue, v)) {
            this.defaultValue = v;
            this.clearCache();
        }
        return this;
    }

    public V[] getValidValues() {
        Collection collection = CollectionsExt.nonNull((Collection)this.getCharacteristic(AttributeConvention.VALID_VALUES_CHARACTERISTIC));
        Object[] objectArray = (Object[])Array.newInstance(this.valueClass, collection.size());
        int n = 0;
        for (Object e : collection) {
            objectArray[n++] = e;
        }
        return objectArray;
    }

    @SafeVarargs
    public final AttributeTypeBuilder<V> setValidValues(V ... VArray) {
        return this.setCharacteristic(AttributeConvention.VALID_VALUES_CHARACTERISTIC, Set.class, CollectionsExt.immutableSet(false, VArray));
    }

    public Integer getMaximalLength() {
        return (Integer)this.getCharacteristic((GenericName)AttributeConvention.MAXIMAL_LENGTH_CHARACTERISTIC);
    }

    public AttributeTypeBuilder<V> setMaximalLength(Integer n) {
        return this.setCharacteristic((GenericName)AttributeConvention.MAXIMAL_LENGTH_CHARACTERISTIC, Integer.class, n);
    }

    public CoordinateReferenceSystem getCRS() {
        return (CoordinateReferenceSystem)this.getCharacteristic((GenericName)AttributeConvention.CRS_CHARACTERISTIC);
    }

    public AttributeTypeBuilder<V> setCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        return this.setCharacteristic((GenericName)AttributeConvention.CRS_CHARACTERISTIC, CoordinateReferenceSystem.class, coordinateReferenceSystem);
    }

    private Object getCharacteristic(GenericName genericName) {
        for (CharacteristicTypeBuilder<?> characteristicTypeBuilder : this.characteristics) {
            if (!genericName.equals(characteristicTypeBuilder.getName())) continue;
            return characteristicTypeBuilder.getDefaultValue();
        }
        return null;
    }

    private <C> AttributeTypeBuilder<V> setCharacteristic(GenericName genericName, Class<C> clazz, C c) {
        for (CharacteristicTypeBuilder<?> characteristicTypeBuilder : this.characteristics) {
            if (!genericName.equals(characteristicTypeBuilder.getName())) continue;
            characteristicTypeBuilder.set(c);
            this.clearCache();
            return this;
        }
        this.addCharacteristic(clazz).setDefaultValue(c).setName(genericName);
        return this;
    }

    public CharacteristicTypeBuilder<?> getCharacteristic(String string) {
        return this.forName(this.characteristics, string, true);
    }

    public <C> CharacteristicTypeBuilder<C> addCharacteristic(Class<C> clazz) {
        this.ensureNonNull("type", clazz);
        CharacteristicTypeBuilder<C> characteristicTypeBuilder = new CharacteristicTypeBuilder<C>(this, clazz);
        this.characteristics.add(characteristicTypeBuilder);
        this.clearCache();
        return characteristicTypeBuilder;
    }

    public <C> CharacteristicTypeBuilder<C> addCharacteristic(DefaultAttributeType<C> defaultAttributeType) {
        this.ensureNonNull("template", defaultAttributeType);
        CharacteristicTypeBuilder<C> characteristicTypeBuilder = new CharacteristicTypeBuilder<C>(this, defaultAttributeType);
        this.characteristics.add(characteristicTypeBuilder);
        this.clearCache();
        return characteristicTypeBuilder;
    }

    public List<CharacteristicTypeBuilder<?>> characteristics() {
        return new RemoveOnlyList(this.characteristics);
    }

    public Set<AttributeRole> roles() {
        return new SetOfUnknownSize<AttributeRole>(){

            @Override
            public Iterator<AttributeRole> iterator() {
                return new RoleIter();
            }

            @Override
            public boolean add(AttributeRole attributeRole) {
                return AttributeTypeBuilder.this.addRole(attributeRole);
            }
        };
    }

    public boolean addRole(AttributeRole attributeRole) {
        FeatureTypeBuilder featureTypeBuilder = this.owner();
        this.ensureNonNull("role", (Object)attributeRole);
        switch (attributeRole) {
            case IDENTIFIER_COMPONENT: {
                if (this.isIdentifier) break;
                this.isIdentifier = true;
                ++featureTypeBuilder.identifierCount;
                featureTypeBuilder.clearCache();
                return true;
            }
            case DEFAULT_GEOMETRY: {
                if (featureTypeBuilder.defaultGeometry == this) break;
                if (!Geometries.isKnownType(this.valueClass)) {
                    throw new IllegalStateException(this.errors().getString((short)160, this.valueClass));
                }
                if (featureTypeBuilder.defaultGeometry != null) {
                    throw new IllegalStateException(this.resources().getString((short)15, featureTypeBuilder.getDisplayName(), AttributeConvention.GEOMETRY_PROPERTY));
                }
                featureTypeBuilder.defaultGeometry = this;
                featureTypeBuilder.clearCache();
                return true;
            }
        }
        return false;
    }

    @Override
    boolean isIdentifier() {
        return this.isIdentifier;
    }

    @Override
    public AttributeTypeBuilder<V> setDefinition(CharSequence charSequence) {
        super.setDefinition(charSequence);
        return this;
    }

    @Override
    public AttributeTypeBuilder<V> setDesignation(CharSequence charSequence) {
        super.setDesignation(charSequence);
        return this;
    }

    @Override
    public AttributeTypeBuilder<V> setDescription(CharSequence charSequence) {
        super.setDescription(charSequence);
        return this;
    }

    @Override
    public AttributeTypeBuilder<V> setDeprecated(boolean bl) {
        super.setDeprecated(bl);
        return this;
    }

    @Override
    final void toStringInternal(StringBuilder stringBuilder) {
        stringBuilder.append(" : ").append(Classes.getShortName(this.valueClass));
    }

    @Override
    public void remove() {
        if (this.isIdentifier) {
            this.isIdentifier = false;
            --this.owner().identifierCount;
        }
        super.remove();
    }

    @Override
    public DefaultAttributeType<V> build() {
        if (this.property == null) {
            DefaultAttributeType[] defaultAttributeTypeArray = new DefaultAttributeType[this.characteristics.size()];
            for (int i = 0; i < defaultAttributeTypeArray.length; ++i) {
                defaultAttributeTypeArray[i] = this.characteristics.get(i).build();
            }
            this.property = new DefaultAttributeType<V>(this.identification(), this.valueClass, this.minimumOccurs, this.maximumOccurs, this.defaultValue, defaultAttributeTypeArray);
        }
        return this.property;
    }

    private final class RoleIter
    extends AbstractIterator<AttributeRole> {
        private int index;

        private RoleIter() {
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                switch (this.index) {
                    case 0: {
                        if (AttributeTypeBuilder.this.isIdentifier) {
                            this.next = AttributeRole.IDENTIFIER_COMPONENT;
                            break;
                        }
                        ++this.index;
                    }
                    case 1: {
                        if (AttributeTypeBuilder.this.owner().defaultGeometry == AttributeTypeBuilder.this) {
                            this.next = AttributeRole.DEFAULT_GEOMETRY;
                            break;
                        }
                        ++this.index;
                    }
                    default: {
                        return false;
                    }
                }
                ++this.index;
            }
            return true;
        }

        @Override
        public void remove() {
            switch (this.index) {
                case 1: {
                    AttributeTypeBuilder.this.isIdentifier = false;
                    break;
                }
                case 2: {
                    AttributeTypeBuilder.this.owner().defaultGeometry = null;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }
}

