/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.earthobservation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.internal.referencing.GeodeticObjectBuilder;
import org.apache.sis.internal.referencing.ReferencingFactoryContainer;
import org.apache.sis.internal.referencing.provider.TransverseMercator;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.StandardDateFormat;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.metadata.iso.content.DefaultAttributeGroup;
import org.apache.sis.metadata.iso.content.DefaultBand;
import org.apache.sis.metadata.iso.content.DefaultCoverageDescription;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.content.CoverageContentType;
import org.opengis.metadata.content.TransferFunctionType;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;
import org.opengis.util.NoSuchIdentifierException;

final class LandsatReader
extends MetadataBuilder {
    private static final String[] BAND_NAMES = new String[]{"Coastal Aerosol", "Blue", "Green", "Red", "Near-Infrared", "Short Wavelength Infrared (SWIR) 1", "Short Wavelength Infrared (SWIR) 2", "Panchromatic", "Cirrus", "Thermal Infrared Sensor (TIRS) 1", "Thermal Infrared Sensor (TIRS) 2"};
    private static final short[] WAVELENGTHS = new short[]{433, 482, 562, 655, 865, 1610, 2200, 590, 1375, 10800, 12000};
    static final Pattern CREDIT = Pattern.compile("\\bcourtesy\\h+of\\h+(the)?\\b\\s*", 2);
    static final int DIM = 2;
    private static final String BAND_SUFFIX = "_BAND";
    static final int BAND_GROUPS = 2692437;
    private static final int NUM_GROUPS = 3;
    static final int PANCHROMATIC = 0;
    static final int REFLECTIVE = 2;
    static final int THERMAL = 4;
    private static final int PROJECTED = 0;
    private static final int GEOGRAPHIC = 8;
    private static final String END = "END";
    private String filename;
    private final StoreListeners listeners;
    private String group;
    private Temporal sceneTime;
    private final double[] corners;
    private final int[] gridSizes;
    private final DefaultBand[] bands;
    private CommonCRS datum;
    private short utmZone;
    private ParameterValueGroup projection;
    private final ReferencingFactoryContainer factories;

    LandsatReader(String string, StoreListeners storeListeners) {
        this.filename = string;
        this.listeners = storeListeners;
        this.factories = new ReferencingFactoryContainer();
        this.bands = new DefaultBand[BAND_NAMES.length];
        this.gridSizes = new int[6];
        this.corners = new double[16];
        Arrays.fill(this.corners, Double.NaN);
    }

    void read(BufferedReader bufferedReader) throws IOException, DataStoreException {
        String string;
        this.newCoverage(true);
        while ((string = bufferedReader.readLine()) != null) {
            int n = CharSequences.skipTrailingWhitespaces((CharSequence)string, (int)0, (int)string.length());
            int n2 = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)0, (int)n);
            if (n2 >= n || string.charAt(n2) == '#') continue;
            int n3 = string.indexOf(61, n2);
            if (n3 < 0) {
                if (n - n2 != END.length() || !string.regionMatches(true, n2, END, 0, END.length())) {
                    throw new DataStoreException(this.errors().getString((short)109, (Object)string));
                }
                return;
            }
            String string2 = string.substring(n2, CharSequences.skipTrailingWhitespaces((CharSequence)string, (int)n2, (int)n3)).toUpperCase(Locale.US);
            int n4 = 0;
            int n5 = string2.length();
            while (--n5 >= 0) {
                char c = string2.charAt(n5);
                if (c >= '0' && c <= '9') continue;
                if (c != '_' || !string2.regionMatches(n5 - BAND_SUFFIX.length(), BAND_SUFFIX, 0, BAND_SUFFIX.length())) break;
                try {
                    n4 = Integer.parseInt(string2.substring(++n5));
                    string2 = string2.substring(0, n5);
                }
                catch (NumberFormatException numberFormatException) {
                    this.warning(string2, bufferedReader, numberFormatException);
                }
                break;
            }
            if (n - (n2 = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)(n3 + 1), (int)n)) >= 2 && string.charAt(n2) == '\"' && string.charAt(n - 1) == '\"') {
                n2 = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)(n2 + 1), (int)(--n));
                n = CharSequences.skipTrailingWhitespaces((CharSequence)string, (int)n2, (int)n);
            }
            try {
                this.parseKeyValuePair(string2, n4, string.substring(n2, n));
            }
            catch (IllegalArgumentException | DateTimeException runtimeException) {
                this.warning(string2, bufferedReader, runtimeException);
            }
        }
        this.listeners.warning(this.errors().getString((short)137, (Object)this.getFilename()));
    }

    private Double parseDouble(String string) throws NumberFormatException {
        return this.shared(Double.valueOf(string));
    }

    private void parseCorner(int n, String string) throws NumberFormatException {
        this.corners[n] = Double.parseDouble(string);
    }

    private void parseGridSize(int n, String string) throws NumberFormatException {
        this.gridSizes[n] = Integer.parseUnsignedInt(string);
    }

    private void parseKeyValuePair(String string, int n, String string2) throws IllegalArgumentException, DateTimeException, DataStoreException {
        switch (string) {
            case "GROUP": {
                this.group = string2;
                break;
            }
            case "END_GROUP": {
                this.group = null;
                break;
            }
            case "ORIGIN": {
                Matcher matcher = CREDIT.matcher(string2);
                if (matcher.find()) {
                    this.newParty(MetadataBuilder.PartyType.ORGANISATION);
                    this.addAuthor(string2.substring(matcher.end()));
                }
                this.addCredits(string2);
                break;
            }
            case "REQUEST_ID": {
                this.addAcquisitionRequirement(null, string2);
                break;
            }
            case "LANDSAT_SCENE_ID": {
                this.addTitleOrIdentifier(string2, MetadataBuilder.Scope.ALL);
                break;
            }
            case "FILE_DATE": {
                this.addCitationDate(StandardDateFormat.toDate((TemporalAccessor)OffsetDateTime.parse(string2)), DateType.CREATION, MetadataBuilder.Scope.ALL);
                break;
            }
            case "DATA_TYPE": {
                this.setProcessingLevelCode("Landsat", string2);
                break;
            }
            case "ELEVATION_SOURCE": {
                this.addSource(string2, ScopeCode.MODEL, (CharSequence)Vocabulary.formatInternational((short)146));
                break;
            }
            case "OUTPUT_FORMAT": {
                if ("GeoTIFF".equalsIgnoreCase(string2)) {
                    try {
                        string2 = "GeoTIFF";
                        this.setFormat(string2);
                        break;
                    }
                    catch (MetadataStoreException metadataStoreException) {
                        this.warning(string, null, metadataStoreException);
                    }
                }
                this.addFormatName(string2);
                break;
            }
            case "SPACECRAFT_ID": {
                this.addPlatform(null, string2);
                break;
            }
            case "SENSOR_ID": {
                this.addInstrument(null, string2);
                break;
            }
            case "DATE_ACQUIRED": {
                LocalDate localDate = LocalDate.parse(string2);
                if (this.sceneTime instanceof OffsetTime) {
                    this.sceneTime = localDate.atTime((OffsetTime)this.sceneTime);
                    break;
                }
                if (localDate.equals(this.sceneTime)) break;
                this.flushSceneTime();
                this.sceneTime = localDate;
                break;
            }
            case "SCENE_CENTER_TIME": {
                OffsetTime offsetTime = OffsetTime.parse(string2);
                if (this.sceneTime instanceof LocalDate) {
                    this.sceneTime = ((LocalDate)this.sceneTime).atTime(offsetTime);
                    break;
                }
                this.sceneTime = offsetTime;
                break;
            }
            case "CORNER_UL_LON_PRODUCT": {
                this.parseCorner(8, string2);
                break;
            }
            case "CORNER_UL_LAT_PRODUCT": {
                this.parseCorner(9, string2);
                break;
            }
            case "CORNER_UR_LON_PRODUCT": {
                this.parseCorner(10, string2);
                break;
            }
            case "CORNER_UR_LAT_PRODUCT": {
                this.parseCorner(11, string2);
                break;
            }
            case "CORNER_LL_LON_PRODUCT": {
                this.parseCorner(12, string2);
                break;
            }
            case "CORNER_LL_LAT_PRODUCT": {
                this.parseCorner(13, string2);
                break;
            }
            case "CORNER_LR_LON_PRODUCT": {
                this.parseCorner(14, string2);
                break;
            }
            case "CORNER_LR_LAT_PRODUCT": {
                this.parseCorner(15, string2);
                break;
            }
            case "CORNER_UL_PROJECTION_X_PRODUCT": {
                this.parseCorner(0, string2);
                break;
            }
            case "CORNER_UL_PROJECTION_Y_PRODUCT": {
                this.parseCorner(1, string2);
                break;
            }
            case "CORNER_UR_PROJECTION_X_PRODUCT": {
                this.parseCorner(2, string2);
                break;
            }
            case "CORNER_UR_PROJECTION_Y_PRODUCT": {
                this.parseCorner(3, string2);
                break;
            }
            case "CORNER_LL_PROJECTION_X_PRODUCT": {
                this.parseCorner(4, string2);
                break;
            }
            case "CORNER_LL_PROJECTION_Y_PRODUCT": {
                this.parseCorner(5, string2);
                break;
            }
            case "CORNER_LR_PROJECTION_X_PRODUCT": {
                this.parseCorner(6, string2);
                break;
            }
            case "CORNER_LR_PROJECTION_Y_PRODUCT": {
                this.parseCorner(7, string2);
                break;
            }
            case "PANCHROMATIC_LINES": {
                this.parseGridSize(1, string2);
                break;
            }
            case "PANCHROMATIC_SAMPLES": {
                this.parseGridSize(0, string2);
                break;
            }
            case "REFLECTIVE_LINES": {
                this.parseGridSize(3, string2);
                break;
            }
            case "REFLECTIVE_SAMPLES": {
                this.parseGridSize(2, string2);
                break;
            }
            case "THERMAL_LINES": {
                this.parseGridSize(5, string2);
                break;
            }
            case "THERMAL_SAMPLES": {
                this.parseGridSize(4, string2);
                break;
            }
            case "GRID_CELL_SIZE_PANCHROMATIC": 
            case "GRID_CELL_SIZE_REFLECTIVE": 
            case "GRID_CELL_SIZE_THERMAL": {
                this.addResolution(Double.parseDouble(string2));
                break;
            }
            case "FILE_NAME_BAND_": {
                DefaultBand defaultBand = this.band(string, n);
                if (defaultBand == null) break;
                defaultBand.getNames().add(new DefaultIdentifier(string2));
                break;
            }
            case "METADATA_FILE_NAME": {
                if (this.filename != null) break;
                this.filename = string2;
                break;
            }
            case "CLOUD_COVER": {
                double d = Double.parseDouble(string2);
                if (!(d >= 0.0)) break;
                this.setCloudCoverPercentage(d);
                break;
            }
            case "SUN_AZIMUTH": {
                this.setIlluminationAzimuthAngle(Double.parseDouble(string2));
                break;
            }
            case "SUN_ELEVATION": {
                this.setIlluminationElevationAngle(Double.parseDouble(string2));
                break;
            }
            case "QUANTIZE_CAL_MIN_BAND_": {
                Double d = this.parseDouble(string2);
                DefaultBand defaultBand = this.band(string, n);
                if (defaultBand == null) break;
                defaultBand.setMinValue(d);
                break;
            }
            case "QUANTIZE_CAL_MAX_BAND_": {
                Double d = this.parseDouble(string2);
                DefaultBand defaultBand = this.band(string, n);
                if (defaultBand == null) break;
                defaultBand.setMaxValue(d);
                break;
            }
            case "RADIANCE_MULT_BAND_": {
                this.setTransferFunction(string, n, true, string2);
                break;
            }
            case "RADIANCE_ADD_BAND_": {
                this.setTransferFunction(string, n, false, string2);
                break;
            }
            case "MAP_PROJECTION": {
                if ("UTM".equalsIgnoreCase(string2)) {
                    this.projection = null;
                    break;
                }
                if (!"PS".equalsIgnoreCase(string2)) break;
                try {
                    this.projection = this.factories.getMathTransformFactory().getDefaultParameters("EPSG:9829");
                    this.utmZone = (short)-1;
                    break;
                }
                catch (NoSuchIdentifierException noSuchIdentifierException) {
                    throw new DataStoreReferencingException(noSuchIdentifierException);
                }
            }
            case "DATUM": {
                this.datum = CommonCRS.valueOf((String)Strings.toUpperCase((String)string2, (Characters.Filter)Characters.Filter.LETTERS_AND_DIGITS));
                break;
            }
            case "UTM_ZONE": {
                if (this.utmZone != 0) break;
                this.utmZone = Short.parseShort(string2);
                break;
            }
            case "VERTICAL_LON_FROM_POLE": {
                this.setProjectionParameter(string, "central_meridian", string2, false);
                break;
            }
            case "TRUE_SCALE_LAT": {
                this.setProjectionParameter(string, "standard_parallel_1", string2, false);
                break;
            }
            case "FALSE_EASTING": {
                this.setProjectionParameter(string, "false_easting", string2, true);
                break;
            }
            case "FALSE_NORTHING": {
                this.setProjectionParameter(string, "false_northing", string2, true);
            }
        }
    }

    private void setTransferFunction(String string, int n, boolean bl, String string2) {
        Double d = this.parseDouble(string2);
        DefaultBand defaultBand = this.band(string, n);
        if (defaultBand != null) {
            defaultBand.setTransferFunctionType(TransferFunctionType.LINEAR);
            if (bl) {
                defaultBand.setScaleFactor(d);
            } else {
                defaultBand.setOffset(d);
            }
        }
    }

    private DefaultBand band(String string, int n) {
        DefaultBand defaultBand;
        if (n < 1 || n > BAND_NAMES.length) {
            this.listeners.warning(this.errors().getString((short)144, (Object)(string + n), (Object)n));
            return null;
        }
        if ((defaultBand = this.bands[--n]) == null) {
            defaultBand = new DefaultBand();
            defaultBand.setDescription((InternationalString)new SimpleInternationalString(BAND_NAMES[n]));
            defaultBand.setPeakResponse(Double.valueOf(WAVELENGTHS[n]));
            defaultBand.setBoundUnits((Unit<Length>)Units.NANOMETRE);
            this.bands[n] = defaultBand;
        }
        return defaultBand;
    }

    private void setProjectionParameter(String string, String string2, String string3, boolean bl) {
        if (this.projection != null) {
            this.projection.parameter(string2).setValue(Double.parseDouble(string3), bl ? Units.METRE : Units.DEGREE);
        } else {
            this.listeners.warning(this.errors().getString((short)141, (Object)this.filename, (Object)string));
        }
    }

    private void flushSceneTime() {
        Temporal temporal = this.sceneTime;
        if (temporal != null) {
            this.sceneTime = null;
            Date date = StandardDateFormat.toDate((TemporalAccessor)temporal);
            this.addAcquisitionTime(date);
            try {
                this.addTemporalExtent(date, date);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.warning(null, null, unsupportedOperationException);
            }
        }
    }

    private boolean toBoundingBox(int n) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        int n2 = n + 8;
        while (--n2 >= n) {
            double d5 = this.corners[n2];
            if (d5 < d2) {
                d2 = d5;
            }
            if (d5 > d4) {
                d4 = d5;
            }
            if ((d5 = this.corners[--n2]) < d) {
                d = d5;
            }
            if (!(d5 > d3)) continue;
            d3 = d5;
        }
        if (d < d3 && d2 < d4) {
            this.corners[n] = d;
            this.corners[++n] = d3;
            this.corners[++n] = d2;
            this.corners[++n] = d4;
            return true;
        }
        return false;
    }

    final Metadata getMetadata() throws FactoryException {
        ProjectedCRS projectedCRS;
        this.addLanguage(Locale.ENGLISH, MetadataBuilder.Scope.METADATA);
        this.addResourceScope(ScopeCode.valueOf((String)"COVERAGE"), null);
        this.addTopicCategory(TopicCategory.GEOSCIENTIFIC_INFORMATION);
        try {
            this.flushSceneTime();
        }
        catch (DateTimeException dateTimeException) {
            this.warning(null, null, dateTimeException);
        }
        if (this.datum != null) {
            if (this.utmZone > 0) {
                this.addReferenceSystem((ReferenceSystem)this.datum.universal(1.0, TransverseMercator.Zoner.UTM.centralMeridian((int)this.utmZone)));
            }
            if (this.projection != null) {
                double d = this.projection.parameter("standard_parallel_1").doubleValue();
                projectedCRS = (ProjectedCRS)CRS.forCode((String)("EPSG:" + (d >= 0.0 ? 3995 : 3031)));
                if (this.datum != CommonCRS.WGS84 || Math.abs(d) != 71.0 || this.projection.parameter("false_easting").doubleValue() != 0.0 || this.projection.parameter("false_northing").doubleValue() != 0.0 || this.projection.parameter("central_meridian").doubleValue() != 0.0) {
                    projectedCRS = ((GeodeticObjectBuilder)new GeodeticObjectBuilder(this.listeners.getLocale()).addName((CharSequence)"Polar stereographic")).setConversion(this.projection).createProjectedCRS(this.datum.geographic(), projectedCRS.getCoordinateSystem());
                }
                this.addReferenceSystem((ReferenceSystem)projectedCRS);
            }
        }
        if (this.toBoundingBox(8)) {
            this.addExtent(this.corners, 8);
        }
        for (int i = 0; i < this.gridSizes.length; i += 2) {
            int n = this.gridSizes[i];
            int n2 = this.gridSizes[i + 1];
            if ((n | n2) == 0) continue;
            this.newGridRepresentation(MetadataBuilder.GridType.GEORECTIFIED);
            this.setAxisName(0, DimensionNameType.SAMPLE);
            this.setAxisName(1, DimensionNameType.LINE);
            this.setAxisSize(0, Integer.toUnsignedLong(n));
            this.setAxisSize(1, Integer.toUnsignedLong(n2));
        }
        this.setISOStandards(true);
        DefaultMetadata defaultMetadata = this.build(false);
        if (defaultMetadata != null) {
            DefaultCoverageDescription defaultCoverageDescription = (DefaultCoverageDescription)CollectionsExt.singletonOrNull(defaultMetadata.getContentInfo());
            if (defaultCoverageDescription != null) {
                projectedCRS = new DefaultAttributeGroup[3];
                for (int i = 0; i < this.bands.length; ++i) {
                    DefaultBand defaultBand = this.bands[i];
                    if (defaultBand == null) continue;
                    int n = 2692437 >>> 2 * i & 3;
                    Object object = projectedCRS[n];
                    if (object == null) {
                        object = new DefaultAttributeGroup(CoverageContentType.PHYSICAL_MEASUREMENT, null);
                        defaultCoverageDescription.getAttributeGroups().add((DefaultAttributeGroup)object);
                        projectedCRS[n] = object;
                    }
                    object.getAttributes().add(defaultBand);
                }
            }
            defaultMetadata.transitionTo(ModifiableMetadata.State.FINAL);
        }
        return defaultMetadata;
    }

    private String getFilename() {
        return this.filename != null ? this.filename : Vocabulary.getResources((Locale)this.listeners.getLocale()).getString((short)108);
    }

    private String toLongName(String string) {
        if (this.group != null) {
            string = this.group + ':' + string;
        }
        return string;
    }

    private void warning(String string, BufferedReader bufferedReader, Exception exception) {
        if (string != null) {
            String string2 = this.getFilename();
            if (bufferedReader instanceof LineNumberReader) {
                string2 = string2 + ":" + ((LineNumberReader)bufferedReader).getLineNumber();
            }
            string = this.errors().getString((short)11, (Object)this.toLongName(string), (Object)string2);
        }
        this.listeners.warning(string, exception);
    }

    private Errors errors() {
        return Errors.getResources((Locale)this.listeners.getLocale());
    }
}

