/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.apache.sis.util.ArgumentChecks;

public class FrequencySortedSet<E>
extends AbstractSet<E>
implements SortedSet<E>,
Comparator<E>,
Serializable {
    private static final long serialVersionUID = 6034102231354388179L;
    private final Map<E, Integer> count;
    private final int order;
    private transient E[] sorted;
    private transient int[] frequencies;
    private static final Comparator<Map.Entry<?, Integer>> COMPARATOR = (entry, entry2) -> ((Integer)entry.getValue()).compareTo((Integer)entry2.getValue());

    public FrequencySortedSet() {
        this.count = new LinkedHashMap<E, Integer>();
        this.order = 0;
    }

    public FrequencySortedSet(boolean bl) {
        this.count = new LinkedHashMap<E, Integer>();
        this.order = bl ? -1 : 0;
    }

    public FrequencySortedSet(int n, boolean bl) {
        this.count = new LinkedHashMap<E, Integer>(n);
        this.order = bl ? -1 : 0;
    }

    @Override
    public int size() {
        return this.count.size();
    }

    @Override
    public boolean isEmpty() {
        return this.count.isEmpty();
    }

    public boolean add(E e, int n3) throws IllegalArgumentException {
        if (n3 != 0) {
            ArgumentChecks.ensurePositive("occurrence", n3);
            this.sorted = null;
            return this.count.merge(e, n3 ^= this.order, (n, n2) -> Math.addExact(n, n2) - this.order) == n3;
        }
        return false;
    }

    @Override
    public boolean add(E e) {
        return this.add(e, 1);
    }

    @Override
    public boolean contains(Object object) {
        return this.count.containsKey(object);
    }

    @Override
    public boolean remove(Object object) {
        if (this.count.remove(object) != null) {
            this.sorted = null;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.frequencies = null;
        this.sorted = null;
        this.count.clear();
    }

    @Override
    public Iterator<E> iterator() {
        this.ensureSorted();
        return new Iter(this.sorted, 0, this.sorted.length);
    }

    @Override
    public SortedSet<E> headSet(E e) {
        return new SubSet(false, null, true, e);
    }

    @Override
    public SortedSet<E> tailSet(E e) {
        return new SubSet(true, e, false, null);
    }

    @Override
    public SortedSet<E> subSet(E e, E e2) {
        return new SubSet(true, e, true, e2);
    }

    @Override
    public E first() throws NoSuchElementException {
        this.ensureSorted();
        if (this.sorted.length != 0) {
            return this.sorted[0];
        }
        throw new NoSuchElementException();
    }

    @Override
    public E last() throws NoSuchElementException {
        this.ensureSorted();
        int n = this.sorted.length;
        if (n != 0) {
            return this.sorted[n - 1];
        }
        throw new NoSuchElementException();
    }

    private void ensureSorted() {
        if (this.sorted == null) {
            Map.Entry[] entryArray = this.count.entrySet().toArray(new Map.Entry[this.count.size()]);
            Arrays.sort(entryArray, COMPARATOR);
            int n = entryArray.length;
            this.sorted = new Object[n];
            if (this.frequencies == null || this.frequencies.length != n) {
                this.frequencies = new int[n];
            }
            for (int i = 0; i < n; ++i) {
                Map.Entry entry = entryArray[i];
                this.sorted[i] = entry.getKey();
                this.frequencies[i] = (Integer)entry.getValue() ^ this.order;
            }
        }
    }

    @Override
    public final Comparator<E> comparator() {
        return this;
    }

    @Override
    public final int compare(E e, E e2) {
        return this.signedFrequency(e) - this.signedFrequency(e2);
    }

    private int signedFrequency(E e) {
        Integer n = this.count.get(e);
        return n != null ? n : 0;
    }

    public int frequency(E e) {
        return this.signedFrequency(e) ^ this.order;
    }

    public int[] frequencies() {
        this.ensureSorted();
        return (int[])this.frequencies.clone();
    }

    @Override
    public Object[] toArray() {
        this.ensureSorted();
        return (Object[])this.sorted.clone();
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        this.ensureSorted();
        if (objectArray.length < this.sorted.length) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.sorted.length);
        }
        System.arraycopy(this.sorted, 0, objectArray, 0, this.sorted.length);
        return objectArray;
    }

    private final class SubSet
    extends AbstractSet<E>
    implements SortedSet<E>,
    Serializable {
        private static final long serialVersionUID = 6843072153603161179L;
        private transient E[] elements;
        private final E fromElement;
        private final E toElement;
        private final boolean hasFrom;
        private final boolean hasTo;
        private transient int lower;
        private transient int upper;

        SubSet(boolean bl, E e, boolean bl2, E e2) {
            this.fromElement = e;
            this.toElement = e2;
            this.hasFrom = bl;
            this.hasTo = bl2;
        }

        @Override
        public Comparator<E> comparator() {
            return FrequencySortedSet.this;
        }

        private void ensureValidRange() {
            if (this.elements == null || this.elements != FrequencySortedSet.this.sorted) {
                FrequencySortedSet.this.ensureSorted();
                this.elements = FrequencySortedSet.this.sorted;
                if (this.hasFrom) {
                    this.lower = Arrays.binarySearch(this.elements, this.fromElement, FrequencySortedSet.this);
                    if (this.lower < 0) {
                        this.lower ^= 0xFFFFFFFF;
                    }
                }
                if (this.hasTo) {
                    this.upper = Arrays.binarySearch(this.elements, this.toElement, FrequencySortedSet.this);
                    if (this.upper < 0) {
                        this.upper ^= 0xFFFFFFFF;
                    }
                    if (this.upper < this.lower) {
                        this.upper = this.lower;
                    }
                } else {
                    this.upper = this.elements.length;
                }
            }
        }

        @Override
        public Iterator<E> iterator() {
            this.ensureValidRange();
            return new Iter(this.elements, this.lower, this.upper);
        }

        @Override
        public int size() {
            this.ensureValidRange();
            return this.upper - this.lower;
        }

        @Override
        public E first() {
            this.ensureValidRange();
            if (this.lower != this.upper) {
                return this.elements[this.lower];
            }
            throw new NoSuchElementException();
        }

        @Override
        public E last() {
            this.ensureValidRange();
            if (this.lower != this.upper) {
                return this.elements[this.upper - 1];
            }
            throw new NoSuchElementException();
        }

        @Override
        public SortedSet<E> headSet(E e) {
            return this.subSet(this.fromElement, e, this.hasFrom ? 0 : 2);
        }

        @Override
        public SortedSet<E> tailSet(E e) {
            return this.subSet(e, this.toElement, this.hasTo ? 0 : 1);
        }

        @Override
        public SortedSet<E> subSet(E e, E e2) {
            return this.subSet(e, e2, 0);
        }

        private SortedSet<E> subSet(E e, E e2, int n) {
            if (this.hasFrom && FrequencySortedSet.this.compare(e, this.fromElement) < 0) {
                e = this.fromElement;
            }
            if (this.hasTo && FrequencySortedSet.this.compare(e2, this.toElement) > 0) {
                e2 = this.toElement;
            }
            switch (n) {
                default: {
                    throw new AssertionError(n);
                }
                case 0: {
                    return FrequencySortedSet.this.subSet(e, e2);
                }
                case 1: {
                    return FrequencySortedSet.this.tailSet(e);
                }
                case 2: 
            }
            return FrequencySortedSet.this.headSet(e2);
        }
    }

    private final class Iter
    implements Iterator<E> {
        private final E[] elements;
        private final int lower;
        private final int upper;
        private int index;

        Iter(E[] EArray, int n, int n2) {
            this.elements = EArray;
            this.index = n;
            this.lower = n;
            this.upper = n2;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.upper;
        }

        @Override
        public E next() {
            if (this.index < this.upper) {
                return this.elements[this.index++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.index == this.lower || !FrequencySortedSet.this.remove(this.elements[this.index - 1])) {
                throw new IllegalStateException();
            }
        }
    }
}

