/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.xml.stream;

import java.io.EOFException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.internal.storage.xml.stream.StaxDataStore;
import org.apache.sis.internal.storage.xml.stream.StaxStreamIO;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.internal.util.StandardDateFormat;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.xml.MarshalContext;

public abstract class StaxStreamReader
extends StaxStreamIO
implements XMLStreamConstants,
Spliterator<AbstractFeature>,
Runnable {
    protected final XMLStreamReader reader;
    private boolean isNextDone;
    private Unmarshaller unmarshaller;

    protected StaxStreamReader(StaxDataStore staxDataStore) throws Exception {
        super(staxDataStore);
        this.reader = staxDataStore.createReader(this);
    }

    @Override
    public int characteristics() {
        return 1296;
    }

    @Override
    public abstract boolean tryAdvance(Consumer<? super AbstractFeature> var1) throws BackingStoreException;

    @Override
    public Spliterator<AbstractFeature> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    protected final XMLStreamReader getSubReader(final QName qName) throws XMLStreamException {
        return new StreamReaderDelegate(this.reader){
            private int nested;

            @Override
            public boolean hasNext() throws XMLStreamException {
                return this.nested >= 0 && super.hasNext();
            }

            @Override
            public int next() throws XMLStreamException {
                if (this.nested < 0) {
                    throw new NoSuchElementException();
                }
                int n = super.next();
                switch (n) {
                    case 1: {
                        if (!qName.equals(this.getName())) break;
                        ++this.nested;
                        break;
                    }
                    case 2: {
                        if (!qName.equals(this.getName())) break;
                        --this.nested;
                    }
                }
                return n;
            }
        };
    }

    protected final void moveToRootElement(Predicate<String> predicate, String string) throws EOFException, XMLStreamException, DataStoreContentException {
        if (!this.reader.isStartElement()) {
            do {
                if (this.reader.hasNext()) continue;
                throw new EOFException(this.endOfFile());
            } while (this.reader.next() != 1);
        }
        if (!predicate.test(this.reader.getNamespaceURI()) || !string.equals(this.reader.getLocalName())) {
            throw new DataStoreContentException(this.errors().getString((short)139, this.owner.getFormatName(), this.owner.getDisplayName()));
        }
    }

    protected final void skipUntilEnd(QName qName) throws EOFException, XMLStreamException {
        assert (this.reader.getEventType() == 1);
        this.isNextDone = false;
        int n = 0;
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    if (!qName.equals(this.reader.getName())) break;
                    ++n;
                    break;
                }
                case 2: {
                    if (!qName.equals(this.reader.getName()) || --n >= 0) break;
                    return;
                }
            }
        }
        throw new EOFException(this.endOfFile());
    }

    protected final int next() throws XMLStreamException {
        if (!this.isNextDone) {
            return this.reader.next();
        }
        this.isNextDone = false;
        return this.reader.getEventType();
    }

    protected final String getElementText() throws XMLStreamException {
        String string = this.reader.getElementText();
        if (string != null && !(string = string.trim()).isEmpty()) {
            return string;
        }
        return null;
    }

    protected final URI getElementAsURI() throws XMLStreamException, URISyntaxException {
        Context context = Context.current();
        return Context.converter((Context)context).toURI((MarshalContext)context, this.getElementText());
    }

    protected final Integer getElementAsInteger() throws XMLStreamException {
        String string = this.getElementText();
        return string != null ? Integer.valueOf(string) : null;
    }

    protected final Double getElementAsDouble() throws XMLStreamException {
        String string = this.getElementText();
        return string != null ? Numerics.valueOf(StaxStreamReader.parseDouble(string)) : null;
    }

    protected final Date getElementAsDate() throws XMLStreamException {
        String string = this.getElementText();
        return string != null ? StandardDateFormat.toDate(StandardDateFormat.FORMAT.parse(string)) : null;
    }

    protected final Temporal getElementAsTemporal() throws XMLStreamException {
        return StandardDateFormat.parseBest(this.getElementText());
    }

    protected final List<String> getElementAsList() throws XMLStreamException {
        String string = this.getElementText();
        return string != null ? Arrays.asList(string.split(" ")) : null;
    }

    protected static double parseDouble(String string) throws NumberFormatException {
        if (!string.endsWith("INF")) {
            return Double.parseDouble(string);
        }
        block0 : switch (string.length()) {
            case 4: {
                switch (string.charAt(0)) {
                    default: {
                        break block0;
                    }
                    case '-': {
                        return Double.NEGATIVE_INFINITY;
                    }
                    case '+': 
                }
            }
            case 3: {
                return Double.POSITIVE_INFINITY;
            }
        }
        throw new NumberFormatException(string);
    }

    protected static boolean parseBoolean(String string) {
        if (string.length() == 1) {
            switch (string.charAt(0)) {
                case '0': {
                    return false;
                }
                case '1': {
                    return true;
                }
            }
        }
        return Boolean.parseBoolean(string);
    }

    protected final <T> T unmarshal(Class<T> clazz) throws XMLStreamException, JAXBException {
        Unmarshaller unmarshaller = this.unmarshaller;
        if (unmarshaller == null) {
            unmarshaller = this.getMarshallerPool().acquireUnmarshaller();
            for (Map.Entry entry : this.owner.configuration.entrySet()) {
                unmarshaller.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
        this.unmarshaller = null;
        JAXBElement jAXBElement = unmarshaller.unmarshal(this.reader, clazz);
        this.unmarshaller = unmarshaller;
        this.isNextDone = true;
        return (T)jAXBElement.getValue();
    }

    @Override
    public void close() throws Exception {
        Unmarshaller unmarshaller = this.unmarshaller;
        if (unmarshaller != null) {
            this.unmarshaller = null;
            this.getMarshallerPool().recycle(unmarshaller);
        }
        this.reader.close();
        super.close();
    }

    @Override
    public final void run() throws BackingStoreException {
        try {
            this.close();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BackingStoreException(exception);
        }
    }

    protected final String endOfFile() {
        return this.errors().getString((short)137, this.owner.getDisplayName());
    }

    protected final String canNotParseFile() {
        return IOUtilities.canNotReadFile((Locale)this.owner.getLocale(), (String)this.owner.getFormatName(), (String)this.owner.getDisplayName(), (Object)this.reader);
    }

    protected final String nestedElement(String string) {
        return this.errors().getString((short)94, string);
    }
}

