/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.xml.stream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stax.StAXResult;
import org.apache.sis.internal.storage.xml.stream.InputType;
import org.apache.sis.internal.storage.xml.stream.StaxDataStore;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

enum OutputType {
    STAX((Class)XMLStreamWriter.class, InputType.STAX){

        @Override
        XMLStreamWriter create(StaxDataStore staxDataStore, Object object) {
            return (XMLStreamWriter)object;
        }
    }
    ,
    STREAM((Class)OutputStream.class, InputType.STREAM){

        @Override
        XMLStreamWriter create(StaxDataStore staxDataStore, Object object) throws XMLStreamException {
            XMLOutputFactory xMLOutputFactory = staxDataStore.outputFactory();
            return staxDataStore.encoding != null ? xMLOutputFactory.createXMLStreamWriter((OutputStream)object, staxDataStore.encoding.name()) : xMLOutputFactory.createXMLStreamWriter((OutputStream)object);
        }

        @Override
        Closeable snapshot(Object object) {
            if (object instanceof ByteArrayOutputStream) {
                return new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
            }
            return super.snapshot(object);
        }
    }
    ,
    CHARACTERS((Class)Writer.class, InputType.CHARACTERS){

        @Override
        XMLStreamWriter create(StaxDataStore staxDataStore, Object object) throws XMLStreamException {
            return staxDataStore.outputFactory().createXMLStreamWriter((Writer)object);
        }

        @Override
        Closeable snapshot(Object object) {
            if (object instanceof StringWriter) {
                return new StringReader(object.toString());
            }
            return super.snapshot(object);
        }
    }
    ,
    RESULT((Class)Result.class, InputType.SOURCE){

        @Override
        XMLStreamWriter create(StaxDataStore staxDataStore, Object object) throws XMLStreamException {
            return staxDataStore.outputFactory().createXMLStreamWriter((Result)object);
        }
    }
    ,
    NODE((Class)Node.class, InputType.NODE){

        @Override
        XMLStreamWriter create(StaxDataStore staxDataStore, Object object) throws XMLStreamException {
            return staxDataStore.outputFactory().createXMLStreamWriter(new DOMResult((Node)object));
        }
    }
    ,
    SAX((Class)ContentHandler.class, InputType.SAX){

        @Override
        XMLStreamWriter create(StaxDataStore staxDataStore, Object object) throws XMLStreamException {
            return staxDataStore.outputFactory().createXMLStreamWriter(new SAXResult((ContentHandler)object));
        }
    }
    ,
    EVENT((Class)XMLEventWriter.class, InputType.EVENT){

        @Override
        XMLStreamWriter create(StaxDataStore staxDataStore, Object object) throws XMLStreamException {
            return staxDataStore.outputFactory().createXMLStreamWriter(new StAXResult((XMLEventWriter)object));
        }
    };

    private final Class<?> outputType;
    final InputType inputType;

    private OutputType(Class<?> clazz, InputType inputType) {
        this.inputType = inputType;
        this.outputType = clazz;
    }

    abstract XMLStreamWriter create(StaxDataStore var1, Object var2) throws XMLStreamException;

    Closeable snapshot(Object object) {
        return null;
    }

    static OutputType forType(Class<?> clazz) {
        for (OutputType outputType : OutputType.values()) {
            if (!outputType.outputType.isAssignableFrom(clazz)) continue;
            return outputType;
        }
        return null;
    }
}

