/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.util.Collection;
import java.util.Locale;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.NamedElement;
import org.apache.sis.internal.netcdf.Resources;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Vector;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;

public abstract class Node
extends NamedElement {
    protected final Decoder decoder;

    protected Node(Decoder decoder) {
        this.decoder = decoder;
    }

    public abstract Collection<String> getAttributeNames();

    public abstract Class<?> getAttributeType(String var1);

    protected abstract Object getAttributeValue(String var1);

    public final String getAttributeAsString(String string) {
        Object object = this.getAttributeValue(string);
        if (object == null || object instanceof String) {
            return (String)object;
        }
        String[] stringArray = Node.toArray(object);
        if (stringArray == null) {
            return object.toString();
        }
        String string2 = null;
        for (String string3 : stringArray) {
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            if (string2.equals(string3)) continue;
            return null;
        }
        return string2;
    }

    public final CharSequence[] getAttributeAsStrings(String string, char c) {
        Object object = this.getAttributeValue(string);
        if (object != null) {
            CharSequence[] charSequenceArray = Node.toArray(object);
            if (charSequenceArray == null) {
                charSequenceArray = CharSequences.split(object.toString(), c);
            }
            if (charSequenceArray.length != 0) {
                return charSequenceArray;
            }
        }
        return null;
    }

    private static String[] toArray(Object object) {
        Object object2;
        int n;
        String[] stringArray;
        Object object3;
        if (object instanceof Object[]) {
            object3 = (Object[])object;
            stringArray = new String[((Object[])object3).length];
            for (n = 0; n < stringArray.length; ++n) {
                object2 = object3[n];
                if (object2 == null) continue;
                stringArray[n] = object2.toString();
            }
        } else if (object instanceof Vector) {
            object3 = (Vector)object;
            stringArray = new String[((Vector)object3).size()];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = ((Vector)object3).stringValue(n);
            }
        } else {
            return null;
        }
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            object2 = stringArray[n];
            if (object2 == null) continue;
            if (((String)(object2 = ((String)object2).trim())).isEmpty()) {
                object2 = null;
            } else {
                bl = true;
            }
            stringArray[n] = object2;
        }
        return bl ? stringArray : null;
    }

    public final double getAttributeAsNumber(String string) {
        Object object = this.getAttributeValue(string);
        Number number = null;
        if (object instanceof Number) {
            number = (Number)object;
        } else if (object instanceof String) {
            number = this.decoder.parseNumber(string, (String)object);
        } else if (object instanceof Vector) {
            Vector vector = (Vector)object;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                Number number2 = vector.get(i);
                if (number2 == null) continue;
                if (number == null) {
                    number = number2;
                    continue;
                }
                if (number.equals(number2)) continue;
                return Double.NaN;
            }
        }
        if (number == null) {
            return Double.NaN;
        }
        double d = number.doubleValue();
        float f = (float)d;
        if ((double)f == d) {
            d = DecimalFunctions.floatToDouble(f);
        }
        return d;
    }

    public final Vector getAttributeAsVector(String string) {
        Object object = this.getAttributeValue(string);
        if (object instanceof Vector) {
            return (Vector)object;
        }
        if (object instanceof Float) {
            return Vector.createForDecimal(new float[]{((Float)object).floatValue()});
        }
        if (object instanceof Number) {
            return Vector.create(new Number[]{(Number)object}, false);
        }
        return null;
    }

    protected final Locale getLocale() {
        return this.decoder.listeners.getLocale();
    }

    protected final Resources resources() {
        return Resources.forLocale(this.getLocale());
    }

    final Errors errors() {
        return Errors.getResources(this.getLocale());
    }

    protected final void warning(Class<?> clazz, String string, short s, Object ... objectArray) {
        Node.warning(this.decoder.listeners, clazz, string, null, null, s, objectArray);
    }

    final void error(Class<?> clazz, String string, Exception exception, short s, Object ... objectArray) {
        Node.warning(this.decoder.listeners, clazz, string, exception, this.errors(), s, objectArray);
    }
}

