/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.CRSBuilder;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.NamedElement;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.NullArgumentException;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.FactoryException;

public abstract class Grid
extends NamedElement {
    public static final int MIN_DIMENSION = 2;
    static final int MIN_SPAN = 2;
    private Axis[] axes;
    private CoordinateReferenceSystem crs;
    private boolean isCRSDetermined;
    private GridGeometry geometry;
    private boolean isGeometryDetermined;
    private PixelInCell anchor = PixelInCell.CELL_CENTER;

    protected Grid() {
    }

    protected abstract Grid forDimensions(Dimension[] var1);

    public abstract int getSourceDimensions();

    public abstract int getTargetDimensions();

    protected abstract List<Dimension> getDimensions();

    public final Axis[] getAxes(Decoder decoder) throws IOException, DataStoreException {
        if (this.axes == null) {
            this.axes = this.createAxes(decoder);
            Axis[] axisArray = new Axis[this.axes.length];
            int n = 0;
            int n2 = axisArray.length;
            Object object = this.axes;
            int n3 = ((Axis[])object).length;
            for (int i = 0; i < n3; ++i) {
                Axis axis;
                axisArray[(axis = object[i]).getDimension() <= 1 ? n++ : --n2] = axis;
            }
            n2 = axisArray.length;
            while (n < axisArray.length) {
                object = axisArray[n];
                if (n < n2 && ((Axis)object).isWraparound()) {
                    System.arraycopy(axisArray, n + 1, axisArray, n, --n2 - n);
                    axisArray[n2] = object;
                    continue;
                }
                ((Axis)object).mainDimensionFirst(axisArray, n);
                ++n;
            }
        }
        return this.axes;
    }

    protected abstract Axis[] createAxes(Decoder var1) throws IOException, DataStoreException;

    protected abstract boolean containsAllNamedAxes(String[] var1);

    final CoordinateReferenceSystem getCoordinateReferenceSystem(Decoder decoder, List<Exception> list) throws IOException, DataStoreException {
        block9: {
            if (!this.isCRSDetermined) {
                try {
                    this.isCRSDetermined = true;
                    ArrayList arrayList = new ArrayList();
                    for (Axis axis : this.getAxes(decoder)) {
                        CRSBuilder.dispatch(arrayList, axis);
                    }
                    Axis[] axisArray = new SingleCRS[arrayList.size()];
                    for (int i = 0; i < axisArray.length; ++i) {
                        axisArray[i] = ((CRSBuilder)arrayList.get(i)).build(decoder);
                    }
                    switch (axisArray.length) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.crs = axisArray[0];
                            break;
                        }
                        default: {
                            this.crs = decoder.getCRSFactory().createCompoundCRS(Collections.singletonMap("name", this.getName()), (CoordinateReferenceSystem[])axisArray);
                            break;
                        }
                    }
                }
                catch (NullArgumentException | FactoryException throwable) {
                    if (!Grid.isNewWarning((Exception)throwable, list)) break block9;
                    this.canNotCreate(decoder, "getCoordinateReferenceSystem", (short)11, (Exception)throwable);
                }
            }
        }
        return this.crs;
    }

    private static boolean isNewWarning(Exception exception, List<Exception> list) {
        if (list != null) {
            for (Exception exception2 : list) {
                if (!Exceptions.messageEquals(exception, exception2)) continue;
                return false;
            }
            list.add(exception);
        }
        return true;
    }

    private GridExtent getExtent(Axis[] axisArray) {
        List<Dimension> list = this.getDimensions();
        int n = list.size();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            long l = list.get(i).length();
            if (l <= 0L) {
                return null;
            }
            lArray[n - 1 - i] = l;
        }
        DimensionNameType[] dimensionNameTypeArray = new DimensionNameType[n];
        switch (n) {
            default: {
                dimensionNameTypeArray[1] = DimensionNameType.ROW;
            }
            case 1: {
                dimensionNameTypeArray[0] = DimensionNameType.COLUMN;
            }
            case 0: 
        }
        for (Axis axis : axisArray) {
            DimensionNameType dimensionNameType;
            if (axis.getDimension() != 1) continue;
            if (AxisDirections.isVertical((AxisDirection)axis.direction)) {
                dimensionNameType = DimensionNameType.VERTICAL;
            } else {
                if (!AxisDirections.isTemporal((AxisDirection)axis.direction)) continue;
                dimensionNameType = DimensionNameType.TIME;
            }
            int n2 = axis.sourceDimensions[0];
            n2 = dimensionNameTypeArray.length - 1 - n2;
            if (n2 < 0) continue;
            dimensionNameTypeArray[n2] = dimensionNameType;
        }
        return new GridExtent(dimensionNameTypeArray, null, lArray, false);
    }

    final GridGeometry getGridGeometry(Decoder decoder) throws IOException, DataStoreException {
        if (!this.isGeometryDetermined) {
            try {
                Object[] objectArray;
                int n;
                int n2;
                this.isGeometryDetermined = true;
                Axis[] axisArray = this.getAxes(decoder);
                int n3 = this.getSourceDimensions();
                int n4 = this.getTargetDimensions();
                int[] nArray = new int[axisArray.length];
                ArrayList<MathTransform> arrayList = new ArrayList<MathTransform>(axisArray.length);
                MatrixSIS matrixSIS = Matrices.createZero((int)(n4 + 1), (int)(n3 + 1));
                matrixSIS.setElement(n4--, n3--, 1.0);
                for (int i = 0; i < axisArray.length; ++i) {
                    if (axisArray[i].trySetTransform((Matrix)matrixSIS, n3, i, arrayList)) continue;
                    nArray[arrayList.size() - 1] = i;
                }
                int[] nArray2 = new int[arrayList.size()];
                Arrays.fill(nArray2, -1);
                block7: for (n2 = 0; n2 < nArray2.length; ++n2) {
                    n = nArray[n2];
                    objectArray = axisArray[n];
                    block8: for (int n5 : objectArray.sourceDimensions) {
                        n5 = n3 - n5;
                        int n6 = matrixSIS.getNumRow();
                        while (--n6 >= 0) {
                            if (matrixSIS.getElement(n6, n5) == 0.0) continue;
                            continue block8;
                        }
                        nArray2[n2] = n5;
                        matrixSIS.setElement(n, n5, 1.0);
                        continue block7;
                    }
                }
                block10: for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    if (arrayList.get(n2) != null) continue;
                    n = n2;
                    block11: while (++n < arrayList.size()) {
                        MathTransform mathTransform;
                        int n5;
                        if (arrayList.get(n) != null) continue;
                        objectArray = new Axis[]{axisArray[nArray[n2]], axisArray[nArray[n]]};
                        int n7 = nArray2[n2];
                        int n8 = nArray2[n];
                        switch (n7 - n8) {
                            case -1: {
                                break;
                            }
                            case 1: {
                                ArraysExt.swap(objectArray, 0, 1);
                                break;
                            }
                            default: {
                                continue block11;
                            }
                        }
                        if ((mathTransform = objectArray[0].createLocalizationGrid((Axis)objectArray[1])) == null) continue;
                        arrayList.set(n2, mathTransform);
                        arrayList.remove(n);
                        n5 = arrayList.size() - n;
                        System.arraycopy(nArray, n + 1, nArray, n, n5);
                        System.arraycopy(nArray2, n + 1, nArray2, n, n5);
                        if (n8 >= n7) continue block10;
                        nArray2[n2] = n8;
                        continue block10;
                    }
                }
                MathTransform mathTransform = null;
                n = arrayList.size();
                objectArray = decoder.getMathTransformFactory();
                arrayList.add(objectArray.createAffineTransform((Matrix)matrixSIS));
                for (int i = 0; i <= n; ++i) {
                    MathTransform mathTransform2 = (MathTransform)arrayList.get(i);
                    if (mathTransform2 == null) continue;
                    if (i < n) {
                        int n9 = nArray2[i];
                        mathTransform2 = objectArray.createPassThroughTransform(n9, mathTransform2, n3 + 1 - (n9 + mathTransform2.getSourceDimensions()));
                    }
                    mathTransform = mathTransform == null ? mathTransform2 : objectArray.createConcatenatedTransform(mathTransform, mathTransform2);
                }
                CoordinateReferenceSystem coordinateReferenceSystem = this.getCoordinateReferenceSystem(decoder, null);
                if (CRS.getHorizontalComponent((CoordinateReferenceSystem)coordinateReferenceSystem) instanceof GeographicCRS) {
                    for (Axis axis : axisArray) {
                        if (!axis.isCellCorner()) continue;
                        this.anchor = PixelInCell.CELL_CORNER;
                        break;
                    }
                }
                this.geometry = new GridGeometry(this.getExtent(axisArray), this.anchor, mathTransform, coordinateReferenceSystem);
            }
            catch (IllegalGridGeometryException | FactoryException throwable) {
                this.canNotCreate(decoder, "getGridGeometry", (short)12, (Exception)throwable);
            }
        }
        return this.geometry;
    }

    final PixelInCell getAnchor() {
        return this.anchor;
    }

    private void canNotCreate(Decoder decoder, String string, short s, Exception exception) {
        Grid.warning(decoder.listeners, Grid.class, string, exception, null, s, decoder.getFilename(), this.getName(), exception.getLocalizedMessage());
    }
}

